/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization;

import org.apache.commons.math.optimization.AbstractConvergenceChecker;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.util.FastMath;

public class SimpleRealPointChecker
extends AbstractConvergenceChecker<RealPointValuePair> {
    public SimpleRealPointChecker() {
    }

    public SimpleRealPointChecker(double relativeThreshold, double absoluteThreshold) {
        super(relativeThreshold, absoluteThreshold);
    }

    @Override
    public boolean converged(int iteration, RealPointValuePair previous, RealPointValuePair current) {
        double[] p = previous.getPoint();
        double[] c = current.getPoint();
        int i = 0;
        while (i < p.length) {
            double size;
            double difference = FastMath.abs(p[i] - c[i]);
            if (difference > (size = FastMath.max(FastMath.abs(p[i]), FastMath.abs(c[i]))) * this.getRelativeThreshold() && difference > this.getAbsoluteThreshold()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

