/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization;

import org.apache.commons.math.optimization.AbstractConvergenceChecker;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.util.FastMath;

public class SimpleScalarValueChecker
extends AbstractConvergenceChecker<RealPointValuePair> {
    public SimpleScalarValueChecker() {
    }

    public SimpleScalarValueChecker(double relativeThreshold, double absoluteThreshold) {
        super(relativeThreshold, absoluteThreshold);
    }

    @Override
    public boolean converged(int iteration, RealPointValuePair previous, RealPointValuePair current) {
        double size;
        double c;
        double p = previous.getValue();
        double difference = FastMath.abs(p - (c = current.getValue()));
        return difference <= (size = FastMath.max(FastMath.abs(p), FastMath.abs(c))) * this.getRelativeThreshold() || difference <= this.getAbsoluteThreshold();
    }
}

