/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization;

import org.apache.commons.math.optimization.AbstractConvergenceChecker;
import org.apache.commons.math.optimization.VectorialPointValuePair;

public class SimpleVectorialPointChecker
extends AbstractConvergenceChecker<VectorialPointValuePair> {
    public SimpleVectorialPointChecker() {
    }

    public SimpleVectorialPointChecker(double relativeThreshold, double absoluteThreshold) {
        super(relativeThreshold, absoluteThreshold);
    }

    @Override
    public boolean converged(int iteration, VectorialPointValuePair previous, VectorialPointValuePair current) {
        double[] p = previous.getPointRef();
        double[] c = current.getPointRef();
        int i = 0;
        while (i < p.length) {
            double size;
            double pi = p[i];
            double ci = c[i];
            double difference = Math.abs(pi - ci);
            if (difference > (size = Math.max(Math.abs(pi), Math.abs(ci))) * this.getRelativeThreshold() && difference > this.getAbsoluteThreshold()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

