/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization;

import org.apache.commons.math.optimization.AbstractConvergenceChecker;
import org.apache.commons.math.optimization.VectorialPointValuePair;
import org.apache.commons.math.util.FastMath;

public class SimpleVectorialValueChecker
extends AbstractConvergenceChecker<VectorialPointValuePair> {
    public SimpleVectorialValueChecker() {
    }

    public SimpleVectorialValueChecker(double relativeThreshold, double absoluteThreshold) {
        super(relativeThreshold, absoluteThreshold);
    }

    @Override
    public boolean converged(int iteration, VectorialPointValuePair previous, VectorialPointValuePair current) {
        double[] p = previous.getValueRef();
        double[] c = current.getValueRef();
        int i = 0;
        while (i < p.length) {
            double size;
            double pi = p[i];
            double ci = c[i];
            double difference = FastMath.abs(pi - ci);
            if (difference > (size = FastMath.max(FastMath.abs(pi), FastMath.abs(ci))) * this.getRelativeThreshold() && difference > this.getAbsoluteThreshold()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

