/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.direct;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.optimization.ConvergenceChecker;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.MultivariateRealOptimizer;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.SimpleScalarValueChecker;
import org.apache.commons.math.optimization.general.AbstractScalarOptimizer;

public abstract class DirectSearchOptimizer
extends AbstractScalarOptimizer
implements MultivariateRealOptimizer {
    protected RealPointValuePair[] simplex;
    private double[][] startConfiguration;

    protected DirectSearchOptimizer() {
        this.setConvergenceChecker(new SimpleScalarValueChecker());
    }

    public void setStartConfiguration(double[] steps) throws IllegalArgumentException {
        int n = steps.length;
        this.startConfiguration = new double[n][n];
        int i = 0;
        while (i < n) {
            double[] vertexI = this.startConfiguration[i];
            int j = 0;
            while (j < i + 1) {
                if (steps[j] == 0.0) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.EQUAL_VERTICES_IN_SIMPLEX, j, j + 1);
                }
                System.arraycopy(steps, 0, vertexI, 0, j + 1);
                ++j;
            }
            ++i;
        }
    }

    public void setStartConfiguration(double[][] referenceSimplex) throws IllegalArgumentException {
        int n = referenceSimplex.length - 1;
        if (n < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.SIMPLEX_NEED_ONE_POINT, new Object[0]);
        }
        this.startConfiguration = new double[n][n];
        double[] ref0 = referenceSimplex[0];
        int i = 0;
        while (i < n + 1) {
            double[] refI = referenceSimplex[i];
            if (refI.length != n) {
                throw new DimensionMismatchException(refI.length, n);
            }
            int j = 0;
            while (j < i) {
                double[] refJ = referenceSimplex[j];
                boolean allEquals = true;
                int k = 0;
                while (k < n) {
                    if (refI[k] != refJ[k]) {
                        allEquals = false;
                        break;
                    }
                    ++k;
                }
                if (allEquals) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.EQUAL_VERTICES_IN_SIMPLEX, i, j);
                }
                ++j;
            }
            if (i > 0) {
                double[] confI = this.startConfiguration[i - 1];
                int k = 0;
                while (k < n) {
                    confI[k] = refI[k] - ref0[k];
                    ++k;
                }
            }
            ++i;
        }
    }

    @Override
    protected RealPointValuePair doOptimize() throws FunctionEvaluationException {
        double[] startPoint = this.getStartPoint();
        if (this.startConfiguration == null || this.startConfiguration.length != startPoint.length) {
            double[] unit = new double[startPoint.length];
            Arrays.fill(unit, 1.0);
            this.setStartConfiguration(unit);
        }
        final boolean isMinim = this.getGoalType() == GoalType.MINIMIZE;
        Comparator<RealPointValuePair> comparator = new Comparator<RealPointValuePair>(){

            @Override
            public int compare(RealPointValuePair o1, RealPointValuePair o2) {
                double v1 = o1.getValue();
                double v2 = o2.getValue();
                return isMinim ? Double.compare(v1, v2) : Double.compare(v2, v1);
            }
        };
        this.buildSimplex(startPoint);
        this.evaluateSimplex(comparator);
        RealPointValuePair[] previous = new RealPointValuePair[this.simplex.length];
        int iteration = 0;
        ConvergenceChecker<RealPointValuePair> checker = this.getConvergenceChecker();
        while (true) {
            if (iteration > 0) {
                boolean converged = true;
                int i = 0;
                while (i < this.simplex.length) {
                    converged &= checker.converged(iteration, previous[i], this.simplex[i]);
                    ++i;
                }
                if (converged) {
                    return this.simplex[0];
                }
            }
            System.arraycopy(this.simplex, 0, previous, 0, this.simplex.length);
            this.iterateSimplex(comparator);
            ++iteration;
        }
    }

    protected abstract void iterateSimplex(Comparator<RealPointValuePair> var1) throws FunctionEvaluationException;

    private void buildSimplex(double[] startPoint) {
        int n = startPoint.length;
        if (n != this.startConfiguration.length) {
            throw new DimensionMismatchException(n, this.startConfiguration.length);
        }
        this.simplex = new RealPointValuePair[n + 1];
        this.simplex[0] = new RealPointValuePair(startPoint, Double.NaN);
        int i = 0;
        while (i < n) {
            double[] confI = this.startConfiguration[i];
            double[] vertexI = new double[n];
            int k = 0;
            while (k < n) {
                vertexI[k] = startPoint[k] + confI[k];
                ++k;
            }
            this.simplex[i + 1] = new RealPointValuePair(vertexI, Double.NaN);
            ++i;
        }
    }

    protected void evaluateSimplex(Comparator<RealPointValuePair> comparator) throws FunctionEvaluationException {
        int i = 0;
        while (i < this.simplex.length) {
            RealPointValuePair vertex = this.simplex[i];
            double[] point = vertex.getPointRef();
            if (Double.isNaN(vertex.getValue())) {
                this.simplex[i] = new RealPointValuePair(point, this.computeObjectiveValue(point), false);
            }
            ++i;
        }
        Arrays.sort(this.simplex, comparator);
    }

    protected void replaceWorstPoint(RealPointValuePair pointValuePair, Comparator<RealPointValuePair> comparator) {
        int n = this.simplex.length - 1;
        int i = 0;
        while (i < n) {
            if (comparator.compare(this.simplex[i], pointValuePair) > 0) {
                RealPointValuePair tmp = this.simplex[i];
                this.simplex[i] = pointValuePair;
                pointValuePair = tmp;
            }
            ++i;
        }
        this.simplex[n] = pointValuePair;
    }
}

