/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.direct;

import java.util.Comparator;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.optimization.ConvergenceChecker;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.direct.DirectSearchOptimizer;

public class MultiDirectional
extends DirectSearchOptimizer {
    private final double khi;
    private final double gamma;

    public MultiDirectional() {
        this.khi = 2.0;
        this.gamma = 0.5;
    }

    public MultiDirectional(double khi, double gamma) {
        this.khi = khi;
        this.gamma = gamma;
    }

    @Override
    protected void iterateSimplex(Comparator<RealPointValuePair> comparator) throws FunctionEvaluationException {
        boolean converged;
        ConvergenceChecker<RealPointValuePair> checker = this.getConvergenceChecker();
        int iteration = 0;
        do {
            ++iteration;
            RealPointValuePair[] original = this.simplex;
            RealPointValuePair best = original[0];
            RealPointValuePair reflected = this.evaluateNewSimplex(original, 1.0, comparator);
            if (comparator.compare(reflected, best) < 0) {
                RealPointValuePair[] reflectedSimplex = this.simplex;
                RealPointValuePair expanded = this.evaluateNewSimplex(original, this.khi, comparator);
                if (comparator.compare(reflected, expanded) <= 0) {
                    this.simplex = reflectedSimplex;
                }
                return;
            }
            RealPointValuePair contracted = this.evaluateNewSimplex(original, this.gamma, comparator);
            if (comparator.compare(contracted, best) < 0) {
                return;
            }
            converged = true;
            int i = 0;
            while (i < this.simplex.length) {
                converged &= checker.converged(iteration, original[i], this.simplex[i]);
                ++i;
            }
        } while (!converged);
    }

    private RealPointValuePair evaluateNewSimplex(RealPointValuePair[] original, double coeff, Comparator<RealPointValuePair> comparator) throws FunctionEvaluationException {
        double[] xSmallest = original[0].getPointRef();
        int n = xSmallest.length;
        this.simplex = new RealPointValuePair[n + 1];
        this.simplex[0] = original[0];
        int i = 1;
        while (i <= n) {
            double[] xOriginal = original[i].getPointRef();
            double[] xTransformed = new double[n];
            int j = 0;
            while (j < n) {
                xTransformed[j] = xSmallest[j] + coeff * (xSmallest[j] - xOriginal[j]);
                ++j;
            }
            this.simplex[i] = new RealPointValuePair(xTransformed, Double.NaN, false);
            ++i;
        }
        this.evaluateSimplex(comparator);
        return this.simplex[0];
    }
}

