/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.direct;

import java.util.Comparator;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.direct.DirectSearchOptimizer;

public class NelderMead
extends DirectSearchOptimizer {
    private final double rho;
    private final double khi;
    private final double gamma;
    private final double sigma;

    public NelderMead() {
        this.rho = 1.0;
        this.khi = 2.0;
        this.gamma = 0.5;
        this.sigma = 0.5;
    }

    public NelderMead(double rho, double khi, double gamma, double sigma) {
        this.rho = rho;
        this.khi = khi;
        this.gamma = gamma;
        this.sigma = sigma;
    }

    @Override
    protected void iterateSimplex(Comparator<RealPointValuePair> comparator) throws FunctionEvaluationException {
        int j;
        int n = this.simplex.length - 1;
        RealPointValuePair best = this.simplex[0];
        RealPointValuePair secondBest = this.simplex[n - 1];
        RealPointValuePair worst = this.simplex[n];
        double[] xWorst = worst.getPointRef();
        double[] centroid = new double[n];
        int i = 0;
        while (i < n) {
            double[] x = this.simplex[i].getPointRef();
            j = 0;
            while (j < n) {
                int n2 = j;
                centroid[n2] = centroid[n2] + x[j];
                ++j;
            }
            ++i;
        }
        double scaling = 1.0 / (double)n;
        j = 0;
        while (j < n) {
            int n3 = j++;
            centroid[n3] = centroid[n3] * scaling;
        }
        double[] xR = new double[n];
        int j2 = 0;
        while (j2 < n) {
            xR[j2] = centroid[j2] + this.rho * (centroid[j2] - xWorst[j2]);
            ++j2;
        }
        RealPointValuePair reflected = new RealPointValuePair(xR, this.computeObjectiveValue(xR), false);
        if (comparator.compare(best, reflected) <= 0 && comparator.compare(reflected, secondBest) < 0) {
            this.replaceWorstPoint(reflected, comparator);
        } else if (comparator.compare(reflected, best) < 0) {
            double[] xE = new double[n];
            int j3 = 0;
            while (j3 < n) {
                xE[j3] = centroid[j3] + this.khi * (xR[j3] - centroid[j3]);
                ++j3;
            }
            RealPointValuePair expanded = new RealPointValuePair(xE, this.computeObjectiveValue(xE), false);
            if (comparator.compare(expanded, reflected) < 0) {
                this.replaceWorstPoint(expanded, comparator);
            } else {
                this.replaceWorstPoint(reflected, comparator);
            }
        } else {
            double[] xC;
            if (comparator.compare(reflected, worst) < 0) {
                xC = new double[n];
                int j4 = 0;
                while (j4 < n) {
                    xC[j4] = centroid[j4] + this.gamma * (xR[j4] - centroid[j4]);
                    ++j4;
                }
                RealPointValuePair outContracted = new RealPointValuePair(xC, this.computeObjectiveValue(xC), false);
                if (comparator.compare(outContracted, reflected) <= 0) {
                    this.replaceWorstPoint(outContracted, comparator);
                    return;
                }
            } else {
                xC = new double[n];
                int j5 = 0;
                while (j5 < n) {
                    xC[j5] = centroid[j5] - this.gamma * (centroid[j5] - xWorst[j5]);
                    ++j5;
                }
                RealPointValuePair inContracted = new RealPointValuePair(xC, this.computeObjectiveValue(xC), false);
                if (comparator.compare(inContracted, worst) < 0) {
                    this.replaceWorstPoint(inContracted, comparator);
                    return;
                }
            }
            double[] xSmallest = this.simplex[0].getPointRef();
            int i2 = 1;
            while (i2 < this.simplex.length) {
                double[] x = this.simplex[i2].getPoint();
                int j6 = 0;
                while (j6 < n) {
                    x[j6] = xSmallest[j6] + this.sigma * (x[j6] - xSmallest[j6]);
                    ++j6;
                }
                this.simplex[i2] = new RealPointValuePair(x, Double.NaN, false);
                ++i2;
            }
            this.evaluateSimplex(comparator);
        }
    }
}

