/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.DifferentiableMultivariateVectorialFunction;
import org.apache.commons.math.analysis.MultivariateMatrixFunction;
import org.apache.commons.math.exception.ConvergenceException;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.optimization.ConvergenceChecker;
import org.apache.commons.math.optimization.DifferentiableMultivariateVectorialOptimizer;
import org.apache.commons.math.optimization.VectorialPointValuePair;
import org.apache.commons.math.optimization.general.BaseAbstractVectorialOptimizer;
import org.apache.commons.math.util.FastMath;

public abstract class AbstractLeastSquaresOptimizer
extends BaseAbstractVectorialOptimizer<DifferentiableMultivariateVectorialFunction>
implements DifferentiableMultivariateVectorialOptimizer {
    protected double[][] weightedResidualJacobian;
    protected int cols;
    protected int rows;
    protected double[] point;
    protected double[] objective;
    protected double[] residuals;
    protected double[] weightedResiduals;
    protected double cost;
    private MultivariateMatrixFunction jF;
    private int jacobianEvaluations;

    protected AbstractLeastSquaresOptimizer() {
    }

    protected AbstractLeastSquaresOptimizer(ConvergenceChecker<VectorialPointValuePair> checker, int maxEvaluations) {
        super(checker, maxEvaluations);
    }

    public int getJacobianEvaluations() {
        return this.jacobianEvaluations;
    }

    protected void updateJacobian() throws FunctionEvaluationException {
        ++this.jacobianEvaluations;
        this.weightedResidualJacobian = this.jF.value(this.point);
        if (this.weightedResidualJacobian.length != this.rows) {
            throw new FunctionEvaluationException(this.point, (Localizable)LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, this.weightedResidualJacobian.length, this.rows);
        }
        double[] residualsWeights = this.getWeightRef();
        int i = 0;
        while (i < this.rows) {
            double[] ji = this.weightedResidualJacobian[i];
            double wi = FastMath.sqrt(residualsWeights[i]);
            int j = 0;
            while (j < this.cols) {
                this.weightedResidualJacobian[i][j] = -ji[j] * wi;
                ++j;
            }
            ++i;
        }
    }

    protected void updateResidualsAndCost() throws FunctionEvaluationException {
        this.objective = this.computeObjectiveValue(this.point);
        if (this.objective.length != this.rows) {
            throw new FunctionEvaluationException(this.point, (Localizable)LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, this.objective.length, this.rows);
        }
        double[] targetValues = this.getTargetRef();
        double[] residualsWeights = this.getWeightRef();
        this.cost = 0.0;
        int index = 0;
        int i = 0;
        while (i < this.rows) {
            double residual = targetValues[i] - this.objective[i];
            this.weightedResiduals[i] = residual * FastMath.sqrt(residualsWeights[i]);
            this.cost += residualsWeights[i] * residual * residual;
            index += this.cols;
            ++i;
        }
        this.cost = FastMath.sqrt(this.cost);
    }

    public double getRMS() {
        return FastMath.sqrt(this.getChiSquare() / (double)this.rows);
    }

    public double getChiSquare() {
        return this.cost * this.cost;
    }

    public double[][] getCovariances() throws FunctionEvaluationException {
        this.updateJacobian();
        double[][] jTj = new double[this.cols][this.cols];
        int i = 0;
        while (i < this.cols) {
            int j = i;
            while (j < this.cols) {
                double sum = 0.0;
                int k = 0;
                while (k < this.rows) {
                    sum += this.weightedResidualJacobian[k][i] * this.weightedResidualJacobian[k][j];
                    ++k;
                }
                jTj[i][j] = sum;
                jTj[j][i] = sum;
                ++j;
            }
            ++i;
        }
        try {
            RealMatrix inverse = new LUDecompositionImpl(MatrixUtils.createRealMatrix(jTj)).getSolver().getInverse();
            return inverse.getData();
        }
        catch (InvalidMatrixException ime) {
            throw new ConvergenceException(LocalizedFormats.UNABLE_TO_COMPUTE_COVARIANCE_SINGULAR_PROBLEM);
        }
    }

    public double[] guessParametersErrors() throws FunctionEvaluationException {
        if (this.rows <= this.cols) {
            throw new ConvergenceException((Localizable)LocalizedFormats.NO_DEGREES_OF_FREEDOM, this.rows, this.cols);
        }
        double[] errors = new double[this.cols];
        double c = FastMath.sqrt(this.getChiSquare() / (double)(this.rows - this.cols));
        double[][] covar = this.getCovariances();
        int i = 0;
        while (i < errors.length) {
            errors[i] = FastMath.sqrt(covar[i][i]) * c;
            ++i;
        }
        return errors;
    }

    @Override
    public VectorialPointValuePair optimize(DifferentiableMultivariateVectorialFunction f, double[] target, double[] weights, double[] startPoint) throws FunctionEvaluationException {
        this.jacobianEvaluations = 0;
        this.jF = f.jacobian();
        this.residuals = new double[target.length];
        this.point = (double[])startPoint.clone();
        this.rows = target.length;
        this.cols = this.point.length;
        this.weightedResidualJacobian = new double[this.rows][this.cols];
        this.weightedResiduals = new double[this.rows];
        this.cost = Double.POSITIVE_INFINITY;
        return super.optimize(f, target, weights, startPoint);
    }
}

