/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.DifferentiableMultivariateRealFunction;
import org.apache.commons.math.analysis.MultivariateVectorialFunction;
import org.apache.commons.math.optimization.ConvergenceChecker;
import org.apache.commons.math.optimization.DifferentiableMultivariateRealOptimizer;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.general.BaseAbstractScalarOptimizer;

public abstract class AbstractScalarDifferentiableOptimizer
extends BaseAbstractScalarOptimizer<DifferentiableMultivariateRealFunction>
implements DifferentiableMultivariateRealOptimizer {
    private MultivariateVectorialFunction gradient;

    protected AbstractScalarDifferentiableOptimizer() {
    }

    protected AbstractScalarDifferentiableOptimizer(ConvergenceChecker<RealPointValuePair> checker, int maxEvaluations) {
        super(checker, maxEvaluations);
    }

    protected double[] computeObjectiveGradient(double[] evaluationPoint) throws FunctionEvaluationException {
        return this.gradient.value(evaluationPoint);
    }

    @Override
    public RealPointValuePair optimize(DifferentiableMultivariateRealFunction f, GoalType goalType, double[] startPoint) throws FunctionEvaluationException {
        this.gradient = f.gradient();
        return super.optimize(f, goalType, startPoint);
    }
}

