/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.MultivariateRealFunction;
import org.apache.commons.math.exception.MaxCountExceededException;
import org.apache.commons.math.exception.NullArgumentException;
import org.apache.commons.math.exception.TooManyEvaluationsException;
import org.apache.commons.math.optimization.BaseMultivariateRealOptimizer;
import org.apache.commons.math.optimization.ConvergenceChecker;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.SimpleScalarValueChecker;
import org.apache.commons.math.util.Incrementor;

public abstract class BaseAbstractScalarOptimizer<T extends MultivariateRealFunction>
implements BaseMultivariateRealOptimizer<T> {
    protected final Incrementor evaluations = new Incrementor();
    private ConvergenceChecker<RealPointValuePair> checker;
    private GoalType goal;
    private double[] start;
    private MultivariateRealFunction function;

    protected BaseAbstractScalarOptimizer() {
        this(new SimpleScalarValueChecker(), Integer.MAX_VALUE);
    }

    protected BaseAbstractScalarOptimizer(ConvergenceChecker<RealPointValuePair> checker, int maxEvaluations) {
        this.checker = checker;
        this.evaluations.setMaximalCount(maxEvaluations);
    }

    @Override
    public void setMaxEvaluations(int maxEvaluations) {
        this.evaluations.setMaximalCount(maxEvaluations);
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    @Override
    public void setConvergenceChecker(ConvergenceChecker<RealPointValuePair> convergenceChecker) {
        this.checker = convergenceChecker;
    }

    @Override
    public ConvergenceChecker<RealPointValuePair> getConvergenceChecker() {
        return this.checker;
    }

    protected double computeObjectiveValue(double[] point) throws FunctionEvaluationException {
        try {
            this.evaluations.incrementCount();
        }
        catch (MaxCountExceededException e) {
            throw new TooManyEvaluationsException(e.getMax());
        }
        return this.function.value(point);
    }

    @Override
    public RealPointValuePair optimize(T f, GoalType goalType, double[] startPoint) throws FunctionEvaluationException {
        if (f == null) {
            throw new NullArgumentException();
        }
        if (goalType == null) {
            throw new NullArgumentException();
        }
        if (startPoint == null) {
            throw new NullArgumentException();
        }
        this.evaluations.resetCount();
        this.function = f;
        this.goal = goalType;
        this.start = (double[])startPoint.clone();
        return this.doOptimize();
    }

    public GoalType getGoalType() {
        return this.goal;
    }

    public double[] getStartPoint() {
        return (double[])this.start.clone();
    }

    protected abstract RealPointValuePair doOptimize() throws FunctionEvaluationException;
}

