/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.MultivariateVectorialFunction;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.MaxCountExceededException;
import org.apache.commons.math.exception.NullArgumentException;
import org.apache.commons.math.exception.TooManyEvaluationsException;
import org.apache.commons.math.optimization.BaseMultivariateVectorialOptimizer;
import org.apache.commons.math.optimization.ConvergenceChecker;
import org.apache.commons.math.optimization.SimpleVectorialValueChecker;
import org.apache.commons.math.optimization.VectorialPointValuePair;
import org.apache.commons.math.util.Incrementor;

public abstract class BaseAbstractVectorialOptimizer<FUNC extends MultivariateVectorialFunction>
implements BaseMultivariateVectorialOptimizer<FUNC> {
    protected final Incrementor evaluations = new Incrementor();
    private ConvergenceChecker<VectorialPointValuePair> checker;
    private double[] target;
    private double[] weight;
    private double[] start;
    private MultivariateVectorialFunction function;

    protected BaseAbstractVectorialOptimizer() {
        this(new SimpleVectorialValueChecker(), Integer.MAX_VALUE);
    }

    protected BaseAbstractVectorialOptimizer(ConvergenceChecker<VectorialPointValuePair> checker, int maxEvaluations) {
        this.checker = checker;
        this.evaluations.setMaximalCount(maxEvaluations);
    }

    @Override
    public void setMaxEvaluations(int maxEvaluations) {
        this.evaluations.setMaximalCount(maxEvaluations);
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    @Override
    public void setConvergenceChecker(ConvergenceChecker<VectorialPointValuePair> convergenceChecker) {
        this.checker = convergenceChecker;
    }

    @Override
    public ConvergenceChecker<VectorialPointValuePair> getConvergenceChecker() {
        return this.checker;
    }

    protected double[] computeObjectiveValue(double[] point) throws FunctionEvaluationException {
        try {
            this.evaluations.incrementCount();
        }
        catch (MaxCountExceededException e) {
            throw new TooManyEvaluationsException(e.getMax());
        }
        return this.function.value(point);
    }

    @Override
    public VectorialPointValuePair optimize(FUNC f, double[] t, double[] w, double[] startPoint) throws FunctionEvaluationException {
        if (f == null) {
            throw new NullArgumentException();
        }
        if (t == null) {
            throw new NullArgumentException();
        }
        if (w == null) {
            throw new NullArgumentException();
        }
        if (startPoint == null) {
            throw new NullArgumentException();
        }
        if (t.length != w.length) {
            throw new DimensionMismatchException(t.length, w.length);
        }
        this.evaluations.resetCount();
        this.function = f;
        this.target = (double[])t.clone();
        this.weight = (double[])w.clone();
        this.start = (double[])startPoint.clone();
        return this.doOptimize();
    }

    public double[] getStartPoint() {
        return (double[])this.start.clone();
    }

    protected abstract VectorialPointValuePair doOptimize() throws FunctionEvaluationException;

    protected double[] getTargetRef() {
        return this.target;
    }

    protected double[] getWeightRef() {
        return this.weight;
    }
}

