/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.exception.ConvergenceException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.BlockRealMatrix;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.QRDecompositionImpl;
import org.apache.commons.math.optimization.ConvergenceChecker;
import org.apache.commons.math.optimization.VectorialPointValuePair;
import org.apache.commons.math.optimization.general.AbstractLeastSquaresOptimizer;

public class GaussNewtonOptimizer
extends AbstractLeastSquaresOptimizer {
    private final boolean useLU;

    public GaussNewtonOptimizer(boolean useLU) {
        this.useLU = useLU;
    }

    @Override
    public VectorialPointValuePair doOptimize() throws FunctionEvaluationException {
        ConvergenceChecker<VectorialPointValuePair> checker = this.getConvergenceChecker();
        VectorialPointValuePair current = null;
        int iter = 0;
        boolean converged = false;
        while (!converged) {
            ++iter;
            VectorialPointValuePair previous = current;
            this.updateResidualsAndCost();
            this.updateJacobian();
            current = new VectorialPointValuePair(this.point, this.objective);
            double[] targetValues = this.getTargetRef();
            double[] residualsWeights = this.getWeightRef();
            double[] b = new double[this.cols];
            double[][] a = new double[this.cols][this.cols];
            int i = 0;
            while (i < this.rows) {
                double[] grad = this.weightedResidualJacobian[i];
                double weight = residualsWeights[i];
                double residual = this.objective[i] - targetValues[i];
                double wr = weight * residual;
                int j = 0;
                while (j < this.cols) {
                    int n = j;
                    b[n] = b[n] + wr * grad[j];
                    ++j;
                }
                int k = 0;
                while (k < this.cols) {
                    double[] ak = a[k];
                    double wgk = weight * grad[k];
                    int l = 0;
                    while (l < this.cols) {
                        int n = l;
                        ak[n] = ak[n] + wgk * grad[l];
                        ++l;
                    }
                    ++k;
                }
                ++i;
            }
            try {
                BlockRealMatrix mA = new BlockRealMatrix(a);
                DecompositionSolver solver = this.useLU ? new LUDecompositionImpl(mA).getSolver() : new QRDecompositionImpl(mA).getSolver();
                double[] dX = solver.solve(b);
                int i2 = 0;
                while (i2 < this.cols) {
                    int n = i2;
                    this.point[n] = this.point[n] + dX[i2];
                    ++i2;
                }
            }
            catch (InvalidMatrixException e) {
                throw new ConvergenceException(LocalizedFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM);
            }
            if (checker == null || previous == null) continue;
            converged = checker.converged(iter, previous, current);
        }
        return current;
    }
}

