/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.BrentSolver;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolver;
import org.apache.commons.math.exception.MathIllegalStateException;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.general.AbstractScalarDifferentiableOptimizer;
import org.apache.commons.math.optimization.general.ConjugateGradientFormula;
import org.apache.commons.math.optimization.general.Preconditioner;
import org.apache.commons.math.util.FastMath;

public class NonLinearConjugateGradientOptimizer
extends AbstractScalarDifferentiableOptimizer {
    private final ConjugateGradientFormula updateFormula;
    private Preconditioner preconditioner;
    private UnivariateRealSolver solver;
    private double initialStep;
    private double[] point;

    public NonLinearConjugateGradientOptimizer(ConjugateGradientFormula updateFormula) {
        this.updateFormula = updateFormula;
        this.preconditioner = null;
        this.solver = null;
        this.initialStep = 1.0;
    }

    public void setPreconditioner(Preconditioner preconditioner) {
        this.preconditioner = preconditioner;
    }

    public void setLineSearchSolver(UnivariateRealSolver lineSearchSolver) {
        this.solver = lineSearchSolver;
    }

    public void setInitialStep(double initialStep) {
        this.initialStep = initialStep <= 0.0 ? 1.0 : initialStep;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected RealPointValuePair doOptimize() throws FunctionEvaluationException {
        if (this.preconditioner == null) {
            this.preconditioner = new IdentityPreconditioner();
        }
        if (this.solver == null) {
            this.solver = new BrentSolver();
        }
        this.point = this.getStartPoint();
        goal = this.getGoalType();
        n = this.point.length;
        r = this.computeObjectiveGradient(this.point);
        if (goal == GoalType.MINIMIZE) {
            i = 0;
            while (i < n) {
                r[i] = -r[i];
                ++i;
            }
        }
        steepestDescent = this.preconditioner.precondition(this.point, r);
        searchDirection = (double[])steepestDescent.clone();
        delta = 0.0;
        i = 0;
        while (i < n) {
            delta += r[i] * searchDirection[i];
            ++i;
        }
        current = null;
        iter = 0;
        block4: while (true) {
            objective = this.computeObjectiveValue(this.point);
            previous = current;
            current = new RealPointValuePair(this.point, objective);
            if (previous != null && this.getConvergenceChecker().converged(++iter, previous, current)) {
                return current;
            }
            dTd = 0.0;
            var19_23 = searchDirection;
            var18_21 = searchDirection.length;
            var17_19 = 0;
            while (var17_19 < var18_21) {
                di = var19_23[var17_19];
                dTd += di * di;
                ++var17_19;
            }
            lsf = new LineSearchFunction(searchDirection);
            try {
                step = this.solver.solve(lsf, 0.0, this.findUpperBound(lsf, 0.0, this.initialStep));
                i = 0;
                while (i < this.point.length) {
                    v0 = i;
                    this.point[v0] = this.point[v0] + step * searchDirection[i];
                    ++i;
                }
            }
            catch (ConvergenceException e) {
                throw new org.apache.commons.math.exception.ConvergenceException();
            }
            r = this.computeObjectiveGradient(this.point);
            if (goal == GoalType.MINIMIZE) {
                i = 0;
                while (i < n) {
                    r[i] = -r[i];
                    ++i;
                }
            }
            deltaOld = delta;
            newSteepestDescent = this.preconditioner.precondition(this.point, r);
            delta = 0.0;
            i = 0;
            while (i < n) {
                delta += r[i] * newSteepestDescent[i];
                ++i;
            }
            if (this.updateFormula == ConjugateGradientFormula.FLETCHER_REEVES) {
                beta = delta / deltaOld;
            } else {
                deltaMid = 0.0;
                i = 0;
                while (i < r.length) {
                    deltaMid += r[i] * steepestDescent[i];
                    ++i;
                }
                beta = (delta - deltaMid) / deltaOld;
            }
            steepestDescent = newSteepestDescent;
            if (iter % n == 0 || beta < 0.0) {
                searchDirection = (double[])steepestDescent.clone();
                continue;
            }
            i = 0;
            while (true) {
                if (i < n) ** break;
                continue block4;
                searchDirection[i] = steepestDescent[i] + beta * searchDirection[i];
                ++i;
            }
            break;
        }
    }

    private double findUpperBound(UnivariateRealFunction f, double a, double h) throws FunctionEvaluationException {
        double yA;
        double yB = yA = f.value(a);
        double step = h;
        while (step < Double.MAX_VALUE) {
            double b = a + step;
            yB = f.value(b);
            if (yA * yB <= 0.0) {
                return b;
            }
            step *= FastMath.max(2.0, yA / yB);
        }
        throw new MathIllegalStateException((Localizable)LocalizedFormats.UNABLE_TO_BRACKET_OPTIMUM_IN_LINE_SEARCH, new Object[0]);
    }

    private static class IdentityPreconditioner
    implements Preconditioner {
        private IdentityPreconditioner() {
        }

        @Override
        public double[] precondition(double[] variables, double[] r) {
            return (double[])r.clone();
        }
    }

    private class LineSearchFunction
    implements UnivariateRealFunction {
        private final double[] searchDirection;

        public LineSearchFunction(double[] searchDirection) {
            this.searchDirection = searchDirection;
        }

        @Override
        public double value(double x) throws FunctionEvaluationException {
            double[] shiftedPoint = (double[])NonLinearConjugateGradientOptimizer.this.point.clone();
            int i = 0;
            while (i < shiftedPoint.length) {
                int n = i;
                shiftedPoint[n] = shiftedPoint[n] + x * this.searchDirection[i];
                ++i;
            }
            double[] gradient = NonLinearConjugateGradientOptimizer.this.computeObjectiveGradient(shiftedPoint);
            double dotProduct = 0.0;
            int i2 = 0;
            while (i2 < gradient.length) {
                dotProduct += gradient[i2] * this.searchDirection[i2];
                ++i2;
            }
            return dotProduct;
        }
    }
}

