/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import java.util.Arrays;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.exception.NotStrictlyPositiveException;
import org.apache.commons.math.exception.NumberIsTooSmallException;
import org.apache.commons.math.optimization.ConvergenceChecker;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.general.AbstractScalarOptimizer;
import org.apache.commons.math.optimization.univariate.BracketFinder;
import org.apache.commons.math.optimization.univariate.BrentOptimizer;
import org.apache.commons.math.optimization.univariate.UnivariateRealPointValuePair;
import org.apache.commons.math.util.FastMath;

public class PowellOptimizer
extends AbstractScalarOptimizer {
    private static final double MIN_RELATIVE_TOLERANCE = 2.0 * FastMath.ulp(1.0);
    private double relativeThreshold;
    private double absoluteThreshold;
    private LineSearch line;

    public PowellOptimizer(double rel, double abs) {
        if (rel < MIN_RELATIVE_TOLERANCE) {
            throw new NumberIsTooSmallException(rel, (Number)MIN_RELATIVE_TOLERANCE, true);
        }
        if (abs <= 0.0) {
            throw new NotStrictlyPositiveException(abs);
        }
        this.relativeThreshold = rel;
        this.absoluteThreshold = abs;
        double minTol = 1.0E-4;
        double lsRel = Math.min(FastMath.sqrt(this.relativeThreshold), 1.0E-4);
        double lsAbs = Math.min(FastMath.sqrt(this.absoluteThreshold), 1.0E-4);
        this.line = new LineSearch(lsRel, lsAbs);
    }

    @Override
    public void setMaxEvaluations(int maxEvaluations) {
        super.setMaxEvaluations(maxEvaluations);
        this.line.setMaxEvaluations(maxEvaluations);
    }

    @Override
    protected RealPointValuePair doOptimize() throws FunctionEvaluationException {
        GoalType goal = this.getGoalType();
        double[] guess = this.getStartPoint();
        int n = guess.length;
        double[][] direc = new double[n][n];
        int i = 0;
        while (i < n) {
            direc[i][i] = 1.0;
            ++i;
        }
        ConvergenceChecker<RealPointValuePair> checker = this.getConvergenceChecker();
        double[] x = guess;
        double fVal = this.computeObjectiveValue(x);
        double[] x1 = (double[])x.clone();
        int iter = 0;
        while (true) {
            ++iter;
            double fX = fVal;
            double fX2 = 0.0;
            double delta = 0.0;
            int bigInd = 0;
            double alphaMin = 0.0;
            int i2 = 0;
            while (i2 < n) {
                double[] d = Arrays.copyOf(direc[i2], n);
                fX2 = fVal;
                UnivariateRealPointValuePair optimum = this.line.search(x, d);
                fVal = optimum.getValue();
                alphaMin = optimum.getPoint();
                double[][] result = this.newPointAndDirection(x, d, alphaMin);
                x = result[0];
                if (fX2 - fVal > delta) {
                    delta = fX2 - fVal;
                    bigInd = i2;
                }
                ++i2;
            }
            boolean stop = 2.0 * (fX - fVal) <= this.relativeThreshold * (FastMath.abs(fX) + FastMath.abs(fVal)) + this.absoluteThreshold;
            RealPointValuePair previous = new RealPointValuePair(x1, fX);
            RealPointValuePair current = new RealPointValuePair(x, fVal);
            if (!stop && checker != null) {
                stop = checker.converged(iter, previous, current);
            }
            if (stop) {
                if (goal == GoalType.MINIMIZE) {
                    return fVal < fX ? current : previous;
                }
                return fVal > fX ? current : previous;
            }
            double[] d = new double[n];
            double[] x2 = new double[n];
            int i3 = 0;
            while (i3 < n) {
                d[i3] = x[i3] - x1[i3];
                x2[i3] = 2.0 * x[i3] - x1[i3];
                ++i3;
            }
            x1 = (double[])x.clone();
            fX2 = this.computeObjectiveValue(x2);
            if (!(fX > fX2)) continue;
            double t = 2.0 * (fX + fX2 - 2.0 * fVal);
            double temp = fX - fVal - delta;
            t *= temp * temp;
            temp = fX - fX2;
            if (!((t -= delta * temp * temp) < 0.0)) continue;
            UnivariateRealPointValuePair optimum = this.line.search(x, d);
            fVal = optimum.getValue();
            alphaMin = optimum.getPoint();
            double[][] result = this.newPointAndDirection(x, d, alphaMin);
            x = result[0];
            int lastInd = n - 1;
            direc[bigInd] = direc[lastInd];
            direc[lastInd] = result[1];
        }
    }

    private double[][] newPointAndDirection(double[] p, double[] d, double optimum) {
        int n = p.length;
        double[][] result = new double[2][n];
        double[] nP = result[0];
        double[] nD = result[1];
        int i = 0;
        while (i < n) {
            nD[i] = d[i] * optimum;
            nP[i] = p[i] + nD[i];
            ++i;
        }
        return result;
    }

    private class LineSearch
    extends BrentOptimizer {
        private final BracketFinder bracket;

        LineSearch(double rel, double abs) {
            super(rel, abs);
            this.bracket = new BracketFinder();
        }

        public UnivariateRealPointValuePair search(final double[] p, final double[] d) throws FunctionEvaluationException {
            final int n = p.length;
            UnivariateRealFunction f = new UnivariateRealFunction(){

                @Override
                public double value(double alpha) throws FunctionEvaluationException {
                    double[] x = new double[n];
                    int i = 0;
                    while (i < n) {
                        x[i] = p[i] + alpha * d[i];
                        ++i;
                    }
                    double obj = PowellOptimizer.this.computeObjectiveValue(x);
                    return obj;
                }
            };
            GoalType goal = PowellOptimizer.this.getGoalType();
            this.bracket.search(f, goal, 0.0, 1.0);
            return this.optimize(f, goal, this.bracket.getLo(), this.bracket.getHi(), this.bracket.getMid());
        }
    }
}

