/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.linear;

import java.util.ArrayList;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.linear.AbstractLinearOptimizer;
import org.apache.commons.math.optimization.linear.NoFeasibleSolutionException;
import org.apache.commons.math.optimization.linear.SimplexTableau;
import org.apache.commons.math.optimization.linear.UnboundedSolutionException;
import org.apache.commons.math.util.MathUtils;

public class SimplexSolver
extends AbstractLinearOptimizer {
    private static final double DEFAULT_EPSILON = 1.0E-6;
    protected final double epsilon;

    public SimplexSolver() {
        this(1.0E-6);
    }

    public SimplexSolver(double epsilon) {
        this.epsilon = epsilon;
    }

    private Integer getPivotColumn(SimplexTableau tableau) {
        double minValue = 0.0;
        Integer minPos = null;
        int i = tableau.getNumObjectiveFunctions();
        while (i < tableau.getWidth() - 1) {
            if (MathUtils.compareTo(tableau.getEntry(0, i), minValue, this.epsilon) < 0) {
                minValue = tableau.getEntry(0, i);
                minPos = i;
            }
            ++i;
        }
        return minPos;
    }

    private Integer getPivotRow(SimplexTableau tableau, int col) {
        ArrayList<Integer> minRatioPositions = new ArrayList<Integer>();
        double minRatio = Double.MAX_VALUE;
        int i = tableau.getNumObjectiveFunctions();
        while (i < tableau.getHeight()) {
            double rhs = tableau.getEntry(i, tableau.getWidth() - 1);
            double entry = tableau.getEntry(i, col);
            if (MathUtils.compareTo(entry, 0.0, this.epsilon) > 0) {
                double ratio = rhs / entry;
                if (MathUtils.equals(ratio, minRatio, this.epsilon)) {
                    minRatioPositions.add(i);
                } else if (ratio < minRatio) {
                    minRatio = ratio;
                    minRatioPositions = new ArrayList();
                    minRatioPositions.add(i);
                }
            }
            ++i;
        }
        if (minRatioPositions.size() == 0) {
            return null;
        }
        if (minRatioPositions.size() > 1) {
            for (Integer row : minRatioPositions) {
                int i2 = 0;
                while (i2 < tableau.getNumArtificialVariables()) {
                    int column = i2 + tableau.getArtificialVariableOffset();
                    if (MathUtils.equals(tableau.getEntry(row, column), 1.0, this.epsilon) && row.equals(tableau.getBasicRow(column))) {
                        return row;
                    }
                    ++i2;
                }
            }
        }
        return (Integer)minRatioPositions.get(0);
    }

    protected void doIteration(SimplexTableau tableau) throws OptimizationException {
        this.incrementIterationsCounter();
        Integer pivotCol = this.getPivotColumn(tableau);
        Integer pivotRow = this.getPivotRow(tableau, pivotCol);
        if (pivotRow == null) {
            throw new UnboundedSolutionException();
        }
        double pivotVal = tableau.getEntry(pivotRow, pivotCol);
        tableau.divideRow(pivotRow, pivotVal);
        int i = 0;
        while (i < tableau.getHeight()) {
            if (i != pivotRow) {
                double multiplier = tableau.getEntry(i, pivotCol);
                tableau.subtractRow(i, pivotRow, multiplier);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void solvePhase1(SimplexTableau tableau) throws OptimizationException {
        if (tableau.getNumArtificialVariables() != 0) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.doIteration(tableau);
lbl4:
            // 2 sources

            ** while (!tableau.isOptimal())
        }
lbl5:
        // 1 sources

        if (!MathUtils.equals(tableau.getEntry(0, tableau.getRhsOffset()), 0.0, this.epsilon)) {
            throw new NoFeasibleSolutionException();
        }
    }

    @Override
    public RealPointValuePair doOptimize() throws OptimizationException {
        SimplexTableau tableau = new SimplexTableau(this.function, this.linearConstraints, this.goal, this.nonNegative, this.epsilon);
        this.solvePhase1(tableau);
        tableau.dropPhase1Objective();
        while (!tableau.isOptimal()) {
            this.doIteration(tableau);
        }
        return tableau.getSolution();
    }
}

