/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.univariate;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.exception.MaxCountExceededException;
import org.apache.commons.math.exception.NullArgumentException;
import org.apache.commons.math.exception.TooManyEvaluationsException;
import org.apache.commons.math.optimization.ConvergenceChecker;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.univariate.UnivariateRealOptimizer;
import org.apache.commons.math.optimization.univariate.UnivariateRealPointValuePair;
import org.apache.commons.math.util.Incrementor;

public abstract class AbstractUnivariateRealOptimizer
implements UnivariateRealOptimizer {
    private ConvergenceChecker<UnivariateRealPointValuePair> checker;
    private final Incrementor evaluations = new Incrementor();
    private GoalType goal;
    private double searchMin;
    private double searchMax;
    private double searchStart;
    private UnivariateRealFunction function;

    @Override
    public void setMaxEvaluations(int maxEvaluations) {
        this.evaluations.setMaximalCount(maxEvaluations);
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    public GoalType getGoalType() {
        return this.goal;
    }

    public double getMin() {
        return this.searchMin;
    }

    public double getMax() {
        return this.searchMax;
    }

    public double getStartValue() {
        return this.searchStart;
    }

    protected double computeObjectiveValue(double point) throws FunctionEvaluationException {
        try {
            this.evaluations.incrementCount();
        }
        catch (MaxCountExceededException e) {
            throw new TooManyEvaluationsException(e.getMax());
        }
        return this.function.value(point);
    }

    @Override
    public UnivariateRealPointValuePair optimize(UnivariateRealFunction f, GoalType goalType, double min, double max, double startValue) throws FunctionEvaluationException {
        if (f == null) {
            throw new NullArgumentException();
        }
        if (goalType == null) {
            throw new NullArgumentException();
        }
        this.searchMin = min;
        this.searchMax = max;
        this.searchStart = startValue;
        this.goal = goalType;
        this.function = f;
        this.evaluations.resetCount();
        return this.doOptimize();
    }

    @Override
    public UnivariateRealPointValuePair optimize(UnivariateRealFunction f, GoalType goalType, double min, double max) throws FunctionEvaluationException {
        return this.optimize(f, goalType, min, max, min + 0.5 * (max - min));
    }

    @Override
    public void setConvergenceChecker(ConvergenceChecker<UnivariateRealPointValuePair> c) {
        this.checker = c;
    }

    @Override
    public ConvergenceChecker<UnivariateRealPointValuePair> getConvergenceChecker() {
        return this.checker;
    }

    protected abstract UnivariateRealPointValuePair doOptimize() throws FunctionEvaluationException;
}

