/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.univariate;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.exception.NotStrictlyPositiveException;
import org.apache.commons.math.exception.NumberIsTooSmallException;
import org.apache.commons.math.optimization.ConvergenceChecker;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.univariate.AbstractUnivariateRealOptimizer;
import org.apache.commons.math.optimization.univariate.UnivariateRealPointValuePair;
import org.apache.commons.math.util.FastMath;
import org.apache.commons.math.util.MathUtils;

public class BrentOptimizer
extends AbstractUnivariateRealOptimizer {
    private static final double GOLDEN_SECTION = 0.5 * (3.0 - FastMath.sqrt(5.0));
    private static final double MIN_RELATIVE_TOLERANCE = 2.0 * FastMath.ulp(1.0);
    private final double relativeThreshold;
    private final double absoluteThreshold;

    public BrentOptimizer(double rel, double abs) {
        if (rel < MIN_RELATIVE_TOLERANCE) {
            throw new NumberIsTooSmallException(rel, (Number)MIN_RELATIVE_TOLERANCE, true);
        }
        if (abs <= 0.0) {
            throw new NotStrictlyPositiveException(abs);
        }
        this.relativeThreshold = rel;
        this.absoluteThreshold = abs;
    }

    @Override
    protected UnivariateRealPointValuePair doOptimize() throws FunctionEvaluationException {
        double x;
        double b;
        double a;
        boolean isMinim = this.getGoalType() == GoalType.MINIMIZE;
        double lo = this.getMin();
        double mid = this.getStartValue();
        double hi = this.getMax();
        ConvergenceChecker<UnivariateRealPointValuePair> checker = this.getConvergenceChecker();
        if (lo < hi) {
            a = lo;
            b = hi;
        } else {
            a = hi;
            b = lo;
        }
        double v = x = mid;
        double w = x;
        double d = 0.0;
        double e = 0.0;
        double fx = this.computeObjectiveValue(x);
        if (!isMinim) {
            fx = -fx;
        }
        double fv = fx;
        double fw = fx;
        UnivariateRealPointValuePair previous = null;
        UnivariateRealPointValuePair current = new UnivariateRealPointValuePair(x, isMinim ? fx : -fx);
        int iter = 0;
        while (true) {
            boolean stop;
            double m = 0.5 * (a + b);
            double tol1 = this.relativeThreshold * FastMath.abs(x) + this.absoluteThreshold;
            double tol2 = 2.0 * tol1;
            boolean bl = stop = FastMath.abs(x - m) <= tol2 - 0.5 * (b - a);
            if (!stop) {
                double p = 0.0;
                double q = 0.0;
                double r = 0.0;
                double u = 0.0;
                if (FastMath.abs(e) > tol1) {
                    r = (x - w) * (fx - fv);
                    q = (x - v) * (fx - fw);
                    p = (x - v) * q - (x - w) * r;
                    if ((q = 2.0 * (q - r)) > 0.0) {
                        p = -p;
                    } else {
                        q = -q;
                    }
                    r = e;
                    e = d;
                    if (p > q * (a - x) && p < q * (b - x) && FastMath.abs(p) < FastMath.abs(0.5 * q * r)) {
                        d = p / q;
                        u = x + d;
                        if (u - a < tol2 || b - u < tol2) {
                            d = x <= m ? tol1 : -tol1;
                        }
                    } else {
                        e = x < m ? b - x : a - x;
                        d = GOLDEN_SECTION * e;
                    }
                } else {
                    e = x < m ? b - x : a - x;
                    d = GOLDEN_SECTION * e;
                }
                u = FastMath.abs(d) < tol1 ? (d >= 0.0 ? x + tol1 : x - tol1) : x + d;
                double fu = this.computeObjectiveValue(u);
                if (!isMinim) {
                    fu = -fu;
                }
                if (fu <= fx) {
                    if (u < x) {
                        b = x;
                    } else {
                        a = x;
                    }
                    v = w;
                    fv = fw;
                    w = x;
                    fw = fx;
                    x = u;
                    fx = fu;
                } else {
                    if (u < x) {
                        a = u;
                    } else {
                        b = u;
                    }
                    if (fu <= fw || MathUtils.equals(w, x)) {
                        v = w;
                        fv = fw;
                        w = u;
                        fw = fu;
                    } else if (fu <= fv || MathUtils.equals(v, x) || MathUtils.equals(v, w)) {
                        v = u;
                        fv = fu;
                    }
                }
                previous = current;
                current = new UnivariateRealPointValuePair(x, isMinim ? fx : -fx);
                if (checker != null && checker.converged(iter, previous, current)) {
                    return current;
                }
            } else {
                return current;
            }
            ++iter;
        }
    }
}

