/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.univariate;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.exception.ConvergenceException;
import org.apache.commons.math.exception.MathIllegalStateException;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.optimization.ConvergenceChecker;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.univariate.BaseUnivariateRealOptimizer;
import org.apache.commons.math.optimization.univariate.UnivariateRealPointValuePair;
import org.apache.commons.math.random.RandomGenerator;
import org.apache.commons.math.util.FastMath;

public class MultiStartUnivariateRealOptimizer<FUNC extends UnivariateRealFunction>
implements BaseUnivariateRealOptimizer<FUNC> {
    private final BaseUnivariateRealOptimizer<FUNC> optimizer;
    private int maxEvaluations;
    private int totalEvaluations;
    private int starts;
    private RandomGenerator generator;
    private UnivariateRealPointValuePair[] optima;

    public MultiStartUnivariateRealOptimizer(BaseUnivariateRealOptimizer<FUNC> optimizer, int starts, RandomGenerator generator) {
        this.optimizer = optimizer;
        this.starts = starts;
        this.generator = generator;
    }

    @Override
    public void setConvergenceChecker(ConvergenceChecker<UnivariateRealPointValuePair> checker) {
        this.optimizer.setConvergenceChecker(checker);
    }

    @Override
    public ConvergenceChecker<UnivariateRealPointValuePair> getConvergenceChecker() {
        return this.optimizer.getConvergenceChecker();
    }

    @Override
    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    @Override
    public int getEvaluations() {
        return this.totalEvaluations;
    }

    @Override
    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
        this.optimizer.setMaxEvaluations(maxEvaluations);
    }

    public UnivariateRealPointValuePair[] getOptima() {
        if (this.optima == null) {
            throw new MathIllegalStateException((Localizable)LocalizedFormats.NO_OPTIMUM_COMPUTED_YET, new Object[0]);
        }
        return (UnivariateRealPointValuePair[])this.optima.clone();
    }

    @Override
    public UnivariateRealPointValuePair optimize(FUNC f, GoalType goal, double min, double max) throws FunctionEvaluationException {
        this.optima = new UnivariateRealPointValuePair[this.starts];
        this.totalEvaluations = 0;
        int i = 0;
        while (i < this.starts) {
            try {
                double bound1 = i == 0 ? min : min + this.generator.nextDouble() * (max - min);
                double bound2 = i == 0 ? max : min + this.generator.nextDouble() * (max - min);
                this.optima[i] = this.optimizer.optimize(f, goal, FastMath.min(bound1, bound2), FastMath.max(bound1, bound2));
            }
            catch (FunctionEvaluationException fee) {
                this.optima[i] = null;
            }
            catch (ConvergenceException ce) {
                this.optima[i] = null;
            }
            int usedEvaluations = this.optimizer.getEvaluations();
            this.optimizer.setMaxEvaluations(this.optimizer.getMaxEvaluations() - usedEvaluations);
            this.totalEvaluations += usedEvaluations;
            ++i;
        }
        this.sortPairs(goal);
        if (this.optima[0] == null) {
            throw new ConvergenceException((Localizable)LocalizedFormats.NO_CONVERGENCE_WITH_ANY_START_POINT, this.starts);
        }
        return this.optima[0];
    }

    @Override
    public UnivariateRealPointValuePair optimize(FUNC f, GoalType goalType, double min, double max, double startValue) throws FunctionEvaluationException {
        return this.optimize(f, goalType, min, max);
    }

    private void sortPairs(final GoalType goal) {
        Arrays.sort(this.optima, new Comparator<UnivariateRealPointValuePair>(){

            @Override
            public int compare(UnivariateRealPointValuePair o1, UnivariateRealPointValuePair o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : 1;
                }
                if (o2 == null) {
                    return -1;
                }
                double v1 = o1.getValue();
                double v2 = o2.getValue();
                return goal == GoalType.MINIMIZE ? Double.compare(v1, v2) : Double.compare(v2, v1);
            }
        });
    }
}

