/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.random.EmpiricalDistribution;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomDataImpl;
import org.apache.commons.math.stat.descriptive.StatisticalSummary;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.apache.commons.math.util.FastMath;

public class EmpiricalDistributionImpl
implements Serializable,
EmpiricalDistribution {
    private static final long serialVersionUID = 5729073523949762654L;
    private List<SummaryStatistics> binStats = null;
    private SummaryStatistics sampleStats = null;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;
    private double delta = 0.0;
    private int binCount = 1000;
    private boolean loaded = false;
    private double[] upperBounds = null;
    private RandomData randomData = new RandomDataImpl();

    public EmpiricalDistributionImpl() {
        this.binStats = new ArrayList<SummaryStatistics>();
    }

    public EmpiricalDistributionImpl(int binCount) {
        this.binCount = binCount;
        this.binStats = new ArrayList<SummaryStatistics>();
    }

    @Override
    public void load(double[] in) {
        ArrayDataAdapter da = new ArrayDataAdapter(in);
        try {
            ((DataAdapter)da).computeStats();
            this.fillBinStats(in);
        }
        catch (IOException e) {
            throw new MathRuntimeException(e);
        }
        this.loaded = true;
    }

    @Override
    public void load(URL url) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        try {
            StreamDataAdapter da = new StreamDataAdapter(in);
            ((DataAdapter)da).computeStats();
            if (this.sampleStats.getN() == 0L) {
                throw MathRuntimeException.createEOFException(LocalizedFormats.URL_CONTAINS_NO_DATA, url);
            }
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            this.fillBinStats(in);
            this.loaded = true;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void load(File file) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            StreamDataAdapter da = new StreamDataAdapter(in);
            ((DataAdapter)da).computeStats();
            in = new BufferedReader(new FileReader(file));
            this.fillBinStats(in);
            this.loaded = true;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void fillBinStats(Object in) throws IOException {
        this.min = this.sampleStats.getMin();
        this.max = this.sampleStats.getMax();
        this.delta = (this.max - this.min) / Double.valueOf(this.binCount);
        if (!this.binStats.isEmpty()) {
            this.binStats.clear();
        }
        int i = 0;
        while (i < this.binCount) {
            SummaryStatistics stats = new SummaryStatistics();
            this.binStats.add(i, stats);
            ++i;
        }
        DataAdapterFactory aFactory = new DataAdapterFactory();
        DataAdapter da = aFactory.getAdapter(in);
        da.computeBinStats();
        this.upperBounds = new double[this.binCount];
        this.upperBounds[0] = (double)this.binStats.get(0).getN() / (double)this.sampleStats.getN();
        int i2 = 1;
        while (i2 < this.binCount - 1) {
            this.upperBounds[i2] = this.upperBounds[i2 - 1] + (double)this.binStats.get(i2).getN() / (double)this.sampleStats.getN();
            ++i2;
        }
        this.upperBounds[this.binCount - 1] = 1.0;
    }

    private int findBin(double value) {
        return FastMath.min(FastMath.max((int)FastMath.ceil((value - this.min) / this.delta) - 1, 0), this.binCount - 1);
    }

    @Override
    public double getNextValue() throws IllegalStateException {
        if (!this.loaded) {
            throw MathRuntimeException.createIllegalStateException(LocalizedFormats.DISTRIBUTION_NOT_LOADED, new Object[0]);
        }
        double x = FastMath.random();
        int i = 0;
        while (i < this.binCount) {
            SummaryStatistics stats;
            if (x <= this.upperBounds[i] && (stats = this.binStats.get(i)).getN() > 0L) {
                if (stats.getStandardDeviation() > 0.0) {
                    return this.randomData.nextGaussian(stats.getMean(), stats.getStandardDeviation());
                }
                return stats.getMean();
            }
            ++i;
        }
        throw new MathRuntimeException(LocalizedFormats.NO_BIN_SELECTED, new Object[0]);
    }

    @Override
    public StatisticalSummary getSampleStats() {
        return this.sampleStats;
    }

    @Override
    public int getBinCount() {
        return this.binCount;
    }

    @Override
    public List<SummaryStatistics> getBinStats() {
        return this.binStats;
    }

    @Override
    public double[] getUpperBounds() {
        double[] binUpperBounds = new double[this.binCount];
        binUpperBounds[0] = this.min + this.delta;
        int i = 1;
        while (i < this.binCount - 1) {
            binUpperBounds[i] = binUpperBounds[i - 1] + this.delta;
            ++i;
        }
        binUpperBounds[this.binCount - 1] = this.max;
        return binUpperBounds;
    }

    public double[] getGeneratorUpperBounds() {
        int len = this.upperBounds.length;
        double[] out = new double[len];
        System.arraycopy(this.upperBounds, 0, out, 0, len);
        return out;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    private class ArrayDataAdapter
    extends DataAdapter {
        private double[] inputArray;

        public ArrayDataAdapter(double[] in) {
            this.inputArray = in;
        }

        @Override
        public void computeStats() throws IOException {
            EmpiricalDistributionImpl.this.sampleStats = new SummaryStatistics();
            int i = 0;
            while (i < this.inputArray.length) {
                EmpiricalDistributionImpl.this.sampleStats.addValue(this.inputArray[i]);
                ++i;
            }
        }

        @Override
        public void computeBinStats() throws IOException {
            int i = 0;
            while (i < this.inputArray.length) {
                SummaryStatistics stats = (SummaryStatistics)EmpiricalDistributionImpl.this.binStats.get(EmpiricalDistributionImpl.this.findBin(this.inputArray[i]));
                stats.addValue(this.inputArray[i]);
                ++i;
            }
        }
    }

    private abstract class DataAdapter {
        private DataAdapter() {
        }

        public abstract void computeBinStats() throws IOException;

        public abstract void computeStats() throws IOException;
    }

    private class DataAdapterFactory {
        private DataAdapterFactory() {
        }

        public DataAdapter getAdapter(Object in) {
            if (in instanceof BufferedReader) {
                BufferedReader inputStream = (BufferedReader)in;
                return new StreamDataAdapter(inputStream);
            }
            if (in instanceof double[]) {
                double[] inputArray = (double[])in;
                return new ArrayDataAdapter(inputArray);
            }
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INPUT_DATA_FROM_UNSUPPORTED_DATASOURCE, in.getClass().getName(), BufferedReader.class.getName(), double[].class.getName());
        }
    }

    private class StreamDataAdapter
    extends DataAdapter {
        private BufferedReader inputStream;

        public StreamDataAdapter(BufferedReader in) {
            this.inputStream = in;
        }

        @Override
        public void computeBinStats() throws IOException {
            String str = null;
            double val = 0.0;
            while ((str = this.inputStream.readLine()) != null) {
                val = Double.parseDouble(str);
                SummaryStatistics stats = (SummaryStatistics)EmpiricalDistributionImpl.this.binStats.get(EmpiricalDistributionImpl.this.findBin(val));
                stats.addValue(val);
            }
            this.inputStream.close();
            this.inputStream = null;
        }

        @Override
        public void computeStats() throws IOException {
            String str = null;
            double val = 0.0;
            EmpiricalDistributionImpl.this.sampleStats = new SummaryStatistics();
            while ((str = this.inputStream.readLine()) != null) {
                val = Double.valueOf(str);
                EmpiricalDistributionImpl.this.sampleStats.addValue(val);
            }
            this.inputStream.close();
            this.inputStream = null;
        }
    }
}

