/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import org.apache.commons.math.random.MersenneTwister;
import org.apache.commons.math.random.RandomGenerator;
import org.apache.commons.math.random.RandomVectorGenerator;
import org.apache.commons.math.util.FastMath;

public class UnitSphereRandomVectorGenerator
implements RandomVectorGenerator {
    private final RandomGenerator rand;
    private final int dimension;

    public UnitSphereRandomVectorGenerator(int dimension, RandomGenerator rand) {
        this.dimension = dimension;
        this.rand = rand;
    }

    public UnitSphereRandomVectorGenerator(int dimension) {
        this(dimension, new MersenneTwister());
    }

    @Override
    public double[] nextVector() {
        double normSq;
        double[] v = new double[this.dimension];
        do {
            normSq = 0.0;
            int i = 0;
            while (i < this.dimension) {
                double comp;
                v[i] = comp = 2.0 * this.rand.nextDouble() - 1.0;
                normSq += comp * comp;
                ++i;
            }
        } while (normSq > 1.0);
        double f = 1.0 / FastMath.sqrt(normSq);
        int i = 0;
        while (i < this.dimension) {
            int n = i++;
            v[n] = v[n] * f;
        }
        return v;
    }
}

