/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.clustering;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.math.stat.clustering.Clusterable;
import org.apache.commons.math.util.MathUtils;

public class EuclideanIntegerPoint
implements Clusterable<EuclideanIntegerPoint>,
Serializable {
    private static final long serialVersionUID = 3946024775784901369L;
    private final int[] point;

    public EuclideanIntegerPoint(int[] point) {
        this.point = point;
    }

    public int[] getPoint() {
        return this.point;
    }

    @Override
    public double distanceFrom(EuclideanIntegerPoint p) {
        return MathUtils.distance(this.point, p.getPoint());
    }

    @Override
    public EuclideanIntegerPoint centroidOf(Collection<EuclideanIntegerPoint> points) {
        int[] centroid = new int[this.getPoint().length];
        for (EuclideanIntegerPoint p : points) {
            int i = 0;
            while (i < centroid.length) {
                int n = i;
                centroid[n] = centroid[n] + p.getPoint()[i];
                ++i;
            }
        }
        int i = 0;
        while (i < centroid.length) {
            int n = i++;
            centroid[n] = centroid[n] / points.size();
        }
        return new EuclideanIntegerPoint(centroid);
    }

    public boolean equals(Object other) {
        if (!(other instanceof EuclideanIntegerPoint)) {
            return false;
        }
        int[] otherPoint = ((EuclideanIntegerPoint)other).getPoint();
        if (this.point.length != otherPoint.length) {
            return false;
        }
        int i = 0;
        while (i < this.point.length) {
            if (this.point[i] != otherPoint[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        int[] nArray = this.point;
        int n = this.point.length;
        int n2 = 0;
        while (n2 < n) {
            Integer i = nArray[n2];
            hashCode += i.hashCode() * 13 + 7;
            ++n2;
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("(");
        int[] coordinates = this.getPoint();
        int i = 0;
        while (i < coordinates.length) {
            buff.append(coordinates[i]);
            if (i < coordinates.length - 1) {
                buff.append(",");
            }
            ++i;
        }
        buff.append(")");
        return buff.toString();
    }
}

