/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.NotPositiveException;
import org.apache.commons.math.exception.NullArgumentException;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.stat.descriptive.UnivariateStatistic;

public abstract class AbstractUnivariateStatistic
implements UnivariateStatistic {
    @Override
    public double evaluate(double[] values) {
        this.test(values, 0, 0);
        return this.evaluate(values, 0, values.length);
    }

    @Override
    public abstract double evaluate(double[] var1, int var2, int var3);

    @Override
    public abstract UnivariateStatistic copy();

    protected boolean test(double[] values, int begin, int length) {
        return this.test(values, begin, length, false);
    }

    protected boolean test(double[] values, int begin, int length, boolean allowEmpty) {
        if (values == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY);
        }
        if (begin < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, begin);
        }
        if (length < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, length);
        }
        if (begin + length > values.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, new Object[0]);
        }
        return length != 0 || allowEmpty;
    }

    protected boolean test(double[] values, double[] weights, int begin, int length) {
        return this.test(values, weights, begin, length, false);
    }

    protected boolean test(double[] values, double[] weights, int begin, int length, boolean allowEmpty) {
        if (weights == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY);
        }
        if (weights.length != values.length) {
            throw new DimensionMismatchException(weights.length, values.length);
        }
        boolean containsPositiveWeight = false;
        int i = begin;
        while (i < begin + length) {
            if (Double.isNaN(weights[i])) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NAN_ELEMENT_AT_INDEX, i);
            }
            if (Double.isInfinite(weights[i])) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, weights[i], i);
            }
            if (weights[i] < 0.0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NEGATIVE_ELEMENT_AT_INDEX, i, weights[i]);
            }
            if (!containsPositiveWeight && weights[i] > 0.0) {
                containsPositiveWeight = true;
            }
            ++i;
        }
        if (!containsPositiveWeight) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.WEIGHT_AT_LEAST_ONE_NON_ZERO, new Object[0]);
        }
        return this.test(values, begin, length, allowEmpty);
    }
}

