/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class Sum
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -8231831954703408316L;
    private long n;
    private double value;

    public Sum() {
        this.n = 0L;
        this.value = 0.0;
    }

    public Sum(Sum original) {
        Sum.copy(original, this);
    }

    @Override
    public void increment(double d) {
        this.value += d;
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 0.0;
        this.n = 0L;
    }

    @Override
    public double evaluate(double[] values, int begin, int length) {
        double sum = Double.NaN;
        if (this.test(values, begin, length, true)) {
            sum = 0.0;
            int i = begin;
            while (i < begin + length) {
                sum += values[i];
                ++i;
            }
        }
        return sum;
    }

    public double evaluate(double[] values, double[] weights, int begin, int length) {
        double sum = Double.NaN;
        if (this.test(values, weights, begin, length, true)) {
            sum = 0.0;
            int i = begin;
            while (i < begin + length) {
                sum += values[i] * weights[i];
                ++i;
            }
        }
        return sum;
    }

    public double evaluate(double[] values, double[] weights) {
        return this.evaluate(values, weights, 0, values.length);
    }

    @Override
    public Sum copy() {
        Sum result = new Sum();
        Sum.copy(this, result);
        return result;
    }

    public static void copy(Sum source, Sum dest) {
        dest.n = source.n;
        dest.value = source.value;
    }
}

