/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math.util.FastMath;

public class SumOfLogs
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -370076995648386763L;
    private int n;
    private double value;

    public SumOfLogs() {
        this.value = 0.0;
        this.n = 0;
    }

    public SumOfLogs(SumOfLogs original) {
        SumOfLogs.copy(original, this);
    }

    @Override
    public void increment(double d) {
        this.value += FastMath.log(d);
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 0.0;
        this.n = 0;
    }

    @Override
    public double evaluate(double[] values, int begin, int length) {
        double sumLog = Double.NaN;
        if (this.test(values, begin, length, true)) {
            sumLog = 0.0;
            int i = begin;
            while (i < begin + length) {
                sumLog += FastMath.log(values[i]);
                ++i;
            }
        }
        return sumLog;
    }

    @Override
    public SumOfLogs copy() {
        SumOfLogs result = new SumOfLogs();
        SumOfLogs.copy(this, result);
        return result;
    }

    public static void copy(SumOfLogs source, SumOfLogs dest) {
        dest.n = source.n;
        dest.value = source.value;
    }
}

