/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import org.matheclipse.core.convert.ConversionException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Blank;
import org.matheclipse.core.reflection.system.Complex;
import org.matheclipse.core.reflection.system.Pattern;
import org.matheclipse.core.reflection.system.Rational;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FloatNode;
import org.matheclipse.parser.client.ast.FractionNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.ast.IntegerNode;
import org.matheclipse.parser.client.ast.PatternNode;
import org.matheclipse.parser.client.ast.StringNode;
import org.matheclipse.parser.client.ast.SymbolNode;

public class AST2Expr {
    public static final AST2Expr CONST = new AST2Expr(ASTNode.class, IExpr.class);

    public AST2Expr(Class<ASTNode> sType, Class<IExpr> tType) {
    }

    public IAST convert(IAST ast, FunctionNode functionNode) throws ConversionException {
        ast.set(0, this.convert(functionNode.get(0)));
        int i = 1;
        while (i < functionNode.size()) {
            ast.add(this.convert(functionNode.get(i)));
            ++i;
        }
        return ast;
    }

    public IExpr convert(ASTNode node) throws ConversionException {
        if (node == null) {
            return null;
        }
        if (node instanceof FunctionNode) {
            IExpr expr;
            FunctionNode functionNode = (FunctionNode)node;
            IAST ast = F.ast(this.convert(functionNode.get(0)), functionNode.size(), false);
            int i = 1;
            while (i < functionNode.size()) {
                ast.add(this.convert(functionNode.get(i)));
                ++i;
            }
            IExpr head = ast.head();
            if (head.equals(F.PatternHead)) {
                IExpr expr2 = Pattern.CONST.evaluate(ast);
                if (expr2 != null) {
                    return expr2;
                }
            } else if (head.equals(F.BlankHead)) {
                IExpr expr3 = Blank.CONST.evaluate(ast);
                if (expr3 != null) {
                    return expr3;
                }
            } else if (head.equals(F.ComplexHead)) {
                IExpr expr4 = Complex.CONST.evaluate(ast);
                if (expr4 != null) {
                    return expr4;
                }
            } else if (head.equals(F.RationalHead) && (expr = Rational.CONST.evaluate(ast)) != null) {
                return expr;
            }
            return ast;
        }
        if (node instanceof SymbolNode) {
            if (node.getString().equals("I")) {
                return F.CI;
            }
            if (node.getString().equals("Infinity")) {
                return F.CInfinity;
            }
            return F.symbol(node.getString());
        }
        if (node instanceof PatternNode) {
            PatternNode pn = (PatternNode)node;
            return F.pattern((ISymbol)this.convert(pn.getSymbol()), this.convert(pn.getConstraint()), pn.isDefault());
        }
        if (node instanceof IntegerNode) {
            IntegerNode integerNode = (IntegerNode)node;
            String iStr = integerNode.getString();
            if (iStr != null) {
                return F.integer(iStr, integerNode.getNumberFormat());
            }
            return F.integer(integerNode.getIntValue());
        }
        if (node instanceof FractionNode) {
            FractionNode fr = (FractionNode)node;
            if (fr.isSign()) {
                return F.fraction((IInteger)this.convert(fr.getNumerator()), (IInteger)this.convert(fr.getDenominator())).negate();
            }
            return F.fraction((IInteger)this.convert(((FractionNode)node).getNumerator()), (IInteger)this.convert(((FractionNode)node).getDenominator()));
        }
        if (node instanceof StringNode) {
            return F.stringx(node.getString());
        }
        if (node instanceof FloatNode) {
            return F.num(node.getString());
        }
        return F.symbol(node.toString());
    }
}

