/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import org.apache.commons.math.FieldElement;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.ArrayFieldVector;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.BlockFieldMatrix;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldVector;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.matheclipse.core.expression.ExprFieldElement;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Convert {
    private Convert() {
    }

    public static IExpr doubleToExprTranspose(double[][] dd) {
        IAST list = F.List();
        try {
            int j = 0;
            while (j < dd[0].length) {
                IAST row = F.List();
                int i = 0;
                while (i < dd.length) {
                    row.add(F.num(dd[i][j]));
                    ++i;
                }
                list.add(row);
                ++j;
            }
            list.addEvalFlags(32);
            return list;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static FieldMatrix<ExprFieldElement> list2Matrix(IAST listMatrix) throws ClassCastException, IndexOutOfBoundsException {
        if (listMatrix == null) {
            return null;
        }
        IExpr header = listMatrix.head();
        if (header != F.List) {
            return null;
        }
        IAST currInRow = (IAST)listMatrix.get(1);
        if (currInRow.size() == 1) {
            FieldElement[][] array = new ExprFieldElement[0][0];
            return new BlockFieldMatrix(array);
        }
        int rowSize = listMatrix.size() - 1;
        int colSize = currInRow.size() - 1;
        FieldElement[][] elements = new ExprFieldElement[rowSize][colSize];
        int i = 1;
        while (i < rowSize + 1) {
            currInRow = (IAST)listMatrix.get(i);
            if (currInRow.head() != F.List) {
                return null;
            }
            int j = 1;
            while (j < colSize + 1) {
                elements[i - 1][j - 1] = new ExprFieldElement((IExpr)currInRow.get(j));
                ++j;
            }
            ++i;
        }
        return new BlockFieldMatrix(elements);
    }

    public static IAST matrix2List(FieldMatrix<ExprFieldElement> matrix) {
        if (matrix == null) {
            return null;
        }
        int rowSize = matrix.getRowDimension();
        int colSize = matrix.getColumnDimension();
        IAST out = F.List();
        int i = 0;
        while (i < rowSize) {
            IAST currOutRow = F.List();
            out.add(currOutRow);
            int j = 0;
            while (j < colSize) {
                IExpr expr = matrix.getEntry(i, j).getExpr();
                if (expr instanceof INumber) {
                    currOutRow.add(expr);
                } else {
                    currOutRow.add(F.eval(F.Together(expr)));
                }
                ++j;
            }
            ++i;
        }
        out.addEvalFlags(32);
        return out;
    }

    public static RealMatrix list2RealMatrix(IAST listMatrix) throws ClassCastException, IndexOutOfBoundsException {
        if (listMatrix == null) {
            return null;
        }
        IExpr header = listMatrix.head();
        if (header != F.List) {
            return null;
        }
        IAST currInRow = (IAST)listMatrix.get(1);
        if (currInRow.size() == 1) {
            double[][] array = new double[0][0];
            return new Array2DRowRealMatrix(array);
        }
        int rowSize = listMatrix.size() - 1;
        int colSize = currInRow.size() - 1;
        double[][] elements = new double[rowSize][colSize];
        int i = 1;
        while (i < rowSize + 1) {
            currInRow = (IAST)listMatrix.get(i);
            if (currInRow.head() != F.List) {
                return null;
            }
            int j = 1;
            while (j < colSize + 1) {
                elements[i - 1][j - 1] = ((ISignedNumber)currInRow.get(j)).doubleValue();
                ++j;
            }
            ++i;
        }
        return new Array2DRowRealMatrix(elements);
    }

    public static IAST realMatrix2List(RealMatrix matrix) {
        if (matrix == null) {
            return null;
        }
        int rowSize = matrix.getRowDimension();
        int colSize = matrix.getColumnDimension();
        IAST out = F.List();
        int i = 0;
        while (i < rowSize) {
            IAST currOutRow = F.List();
            out.add(currOutRow);
            int j = 0;
            while (j < colSize) {
                currOutRow.add(F.num(matrix.getEntry(i, j)));
                ++j;
            }
            ++i;
        }
        out.addEvalFlags(32);
        return out;
    }

    public static FieldVector<ExprFieldElement> list2Vector(IAST listVector) throws ClassCastException, IndexOutOfBoundsException {
        if (listVector == null) {
            return null;
        }
        IExpr header = listVector.head();
        if (header != F.List) {
            return null;
        }
        int rowSize = listVector.size() - 1;
        FieldElement[] elements = new ExprFieldElement[rowSize];
        int i = 0;
        while (i < rowSize) {
            elements[i] = new ExprFieldElement((IExpr)listVector.get(i + 1));
            ++i;
        }
        return new ArrayFieldVector(elements);
    }

    public static RealVector list2RealVector(IAST listVector) throws ClassCastException, IndexOutOfBoundsException {
        if (listVector == null) {
            return null;
        }
        IExpr header = listVector.head();
        if (header != F.List) {
            return null;
        }
        int rowSize = listVector.size() - 1;
        double[] elements = new double[rowSize];
        int i = 0;
        while (i < rowSize) {
            elements[i] = ((ISignedNumber)listVector.get(i + 1)).doubleValue();
            ++i;
        }
        return new ArrayRealVector(elements);
    }

    public static IAST vector2List(FieldVector<ExprFieldElement> vector) {
        if (vector == null) {
            return null;
        }
        int rowSize = vector.getDimension();
        IAST out = F.List();
        int i = 0;
        while (i < rowSize) {
            out.add(vector.getEntry(i).getExpr());
            ++i;
        }
        out.addEvalFlags(64);
        return out;
    }

    public static IAST realVector2List(RealVector vector) {
        if (vector == null) {
            return null;
        }
        int rowSize = vector.getDimension();
        IAST out = F.function(F.List);
        int i = 0;
        while (i < rowSize) {
            out.add(F.num(vector.getEntry(i)));
            ++i;
        }
        out.addEvalFlags(64);
        return out;
    }

    public static IExpr polynomialFunction2Expr(PolynomialFunction pf, ISymbol sym) {
        double[] coefficients = pf.getCoefficients();
        IAST sum = F.Plus();
        if (coefficients[0] == 0.0 && coefficients.length == 1) {
            return F.C0;
        }
        sum.add(F.num(coefficients[0]));
        int i = 1;
        while (i < coefficients.length) {
            if (coefficients[i] != 0.0) {
                sum.add(F.Times((IExpr)F.num(coefficients[i]), (IExpr)F.Power((IExpr)sym, F.integer(i))));
            }
            ++i;
        }
        return sum;
    }
}

