/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.integrate.Integral;
import edu.jas.integrate.LogIntegral;
import edu.jas.integrate.QuotIntegral;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.Quotient;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class JASConvert<C extends RingElem<C>> {
    private final RingFactory<C> fRingFactory;
    private final TermOrder fTermOrder;
    private final GenPolynomialRing<C> fPolyFactory;
    private final GenPolynomialRing<BigInteger> fBigIntegerPolyFactory;
    private final List<? extends IExpr> fVariables;

    public JASConvert(List<? extends IExpr> variablesList, RingFactory<C> ringFactory) {
        this(variablesList, ringFactory, new TermOrder(2));
    }

    public JASConvert(List<? extends IExpr> variablesList, RingFactory<C> ringFactory, TermOrder termOrder) {
        this.fRingFactory = ringFactory;
        this.fVariables = variablesList;
        String[] vars = new String[this.fVariables.size()];
        int i = 0;
        while (i < this.fVariables.size()) {
            vars[i] = this.fVariables.get(i).toString();
            ++i;
        }
        this.fTermOrder = termOrder;
        this.fPolyFactory = new GenPolynomialRing<C>(this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
        this.fBigIntegerPolyFactory = new GenPolynomialRing<BigInteger>(BigInteger.ZERO, this.fVariables.size(), this.fTermOrder, vars);
    }

    public GenPolynomial<C> expr2Poly(IExpr exprPoly) throws ArithmeticException, ClassCastException {
        if (exprPoly instanceof IAST) {
            IAST ast = (IAST)exprPoly;
            GenPolynomial<Object> result = this.fPolyFactory.getZERO();
            GenPolynomial<C> p = this.fPolyFactory.getZERO();
            if (ast.isASTSizeGE(F.Plus, 2)) {
                IExpr expr = (IExpr)ast.get(1);
                result = this.expr2Poly(expr);
                int i = 2;
                while (i < ast.size()) {
                    expr = (IExpr)ast.get(i);
                    p = this.expr2Poly(expr);
                    result = result.sum((Object)p);
                    ++i;
                }
                return result;
            }
            if (ast.isASTSizeGE(F.Times, 2)) {
                IExpr expr = (IExpr)ast.get(1);
                result = this.expr2Poly(expr);
                int i = 2;
                while (i < ast.size()) {
                    expr = (IExpr)ast.get(i);
                    p = this.expr2Poly(expr);
                    result = result.multiply((Object)p);
                    ++i;
                }
                return result;
            }
            if (ast.isAST(F.Power, 3)) {
                IExpr expr = (IExpr)ast.get(1);
                int i = 0;
                while (i < this.fVariables.size()) {
                    if (this.fVariables.get(i).equals(expr)) {
                        ExpVector e = ExpVector.create(this.fVariables.size(), i, ((IInteger)ast.get(2)).toInt());
                        return ((GenPolynomial)this.fPolyFactory.getONE()).multiply(e);
                    }
                    ++i;
                }
            }
        } else {
            if (exprPoly instanceof ISymbol) {
                int i = 0;
                while (i < this.fVariables.size()) {
                    if (this.fVariables.get(i).equals(exprPoly)) {
                        ExpVector e = ExpVector.create(this.fVariables.size(), i, 1L);
                        return ((GenPolynomial)this.fPolyFactory.getONE()).multiply(e);
                    }
                    ++i;
                }
                return new GenPolynomial<IExpr>(this.fPolyFactory, exprPoly);
            }
            if (exprPoly instanceof IInteger) {
                return this.fPolyFactory.fromInteger(((IInteger)exprPoly).toInt());
            }
            if (exprPoly instanceof IFraction) {
                java.math.BigInteger n = ((IFraction)exprPoly).getBigNumerator().toJavaBigInteger();
                java.math.BigInteger d = ((IFraction)exprPoly).getBigDenominator().toJavaBigInteger();
                BigRational nr = new BigRational(n);
                BigRational dr = new BigRational(d);
                BigRational r = nr.divide(dr);
                return new GenPolynomial<BigRational>(this.fPolyFactory, r);
            }
        }
        if (exprPoly.isFree((Predicate<IExpr>)Predicates.in(this.fVariables))) {
            return new GenPolynomial<IExpr>(this.fPolyFactory, exprPoly);
        }
        throw new ClassCastException(exprPoly.toString());
    }

    public Object[] factorTerms(GenPolynomial<BigRational> A) {
        return PolyUtil.integerFromRationalCoefficientsFactor(this.fBigIntegerPolyFactory, A);
    }

    public GenPolynomialRing<C> getPolynomialRingFactory() {
        return this.fPolyFactory;
    }

    public GenPolynomial<BigInteger> integerFromRationalCoefficients(GenPolynomial<BigRational> A) {
        return PolyUtil.integerFromRationalCoefficients(this.fBigIntegerPolyFactory, A);
    }

    public IAST integerPoly2Expr(GenPolynomial<BigInteger> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        IAST result = F.Plus();
        for (Monomial<BigInteger> monomial : poly) {
            BigInteger coeff = monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IInteger coeffValue = F.integer(coeff.getVal());
            IAST monomTimes = F.Times((IExpr)coeffValue);
            int i = 0;
            while (i < exp.length()) {
                long lExp = exp.getVal(i);
                if (lExp != 0L) {
                    monomTimes.add(F.Power(this.fVariables.get(i), F.integer(lExp)));
                }
                ++i;
            }
            result.add(monomTimes);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public IAST integral2Expr(Integral<BigRational> integral) {
        IAST sum = F.Plus();
        GenPolynomial<BigRational> pol = integral.pol;
        List rational = integral.rational;
        List logarithm = integral.logarithm;
        if (!pol.isZERO()) {
            sum.add(this.poly2Expr(pol, null));
        }
        if (rational.size() != 0) {
            void var6_7;
            boolean bl = false;
            while (var6_7 < rational.size()) {
                sum.add(F.Times((IExpr)this.poly2Expr(rational.get((int)(++var6_7)), null), (IExpr)F.Power((IExpr)this.poly2Expr(rational.get((int)(++var6_7)), null), F.CN1)));
            }
        }
        if (logarithm.size() != 0) {
            for (LogIntegral<BigRational> logIntegral : logarithm) {
                sum.add(this.logIntegral2Expr(logIntegral));
            }
        }
        return sum;
    }

    public IAST logIntegral2Expr(LogIntegral<BigRational> logIntegral) {
        int i;
        IAST plus = F.Plus();
        List cfactors = logIntegral.cfactors;
        List cdenom = logIntegral.cdenom;
        List afactors = logIntegral.afactors;
        List adenom = logIntegral.adenom;
        if (cfactors.size() > 0) {
            i = 0;
            while (i < cfactors.size()) {
                BigRational cp = (BigRational)cfactors.get(i);
                GenPolynomial<BigRational> p = cdenom.get(i);
                plus.add(F.Times((IExpr)F.fraction(cp.numerator(), cp.denominator()), (IExpr)F.Log(this.poly2Expr(p, null))));
                ++i;
            }
        }
        if (afactors.size() > 0) {
            i = 0;
            while (i < afactors.size()) {
                AlgebraicNumber ap = afactors.get(i);
                ElemFactory ar = ap.factory();
                GenPolynomial<AlgebraicNumber<BigRational>> p = adenom.get(i);
                if (p.degree(0) < ((AlgebraicNumberRing)ar).modul.degree(0)) {
                    ((AlgebraicNumberRing)ar).modul.degree(0);
                }
                GenPolynomial<BigRational> v = ap.getVal();
                IAST times = F.Times();
                AlgebraicNumber arGen = ((AlgebraicNumberRing)ar).getGenerator();
                if (p.degree(0) < ((AlgebraicNumberRing)ar).modul.degree(0) && ((AlgebraicNumberRing)ar).modul.degree(0) > 2L) {
                    IAST rootOf = F.function(F.RootOf);
                    rootOf.add(this.poly2Expr(((AlgebraicNumberRing)ar).modul, null));
                    times.add(rootOf);
                    throw new UnsupportedOperationException("JASConvert#logIntegral2Expr()");
                }
                times.add(this.poly2Expr(v, null));
                times.add(F.Log(this.polyAlgebraicNumber2Expr(p)));
                plus.add(times);
                ++i;
            }
        }
        return plus;
    }

    public IAST modIntegerPoly2Expr(GenPolynomial<ModInteger> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        IAST result = F.Plus();
        for (Monomial<ModInteger> monomial : poly) {
            ModInteger coeff = monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IInteger coeffValue = F.integer(coeff.getVal());
            IAST monomTimes = F.Times((IExpr)coeffValue);
            int i = 0;
            while (i < exp.length()) {
                long lExp = exp.getVal(i);
                if (lExp != 0L) {
                    monomTimes.add(F.Power(this.fVariables.get(i), F.integer(lExp)));
                }
                ++i;
            }
            result.add(monomTimes);
        }
        return result;
    }

    public IAST poly2Expr(GenPolynomial<BigRational> poly) throws ArithmeticException, ClassCastException {
        return this.poly2Expr(poly, null);
    }

    public IAST poly2Expr(GenPolynomial<BigRational> poly, IExpr variable) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        boolean getVar = variable == null;
        IAST result = F.Plus();
        for (Monomial<BigRational> monomial : poly) {
            BigRational coeff = monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IFraction coeffValue = F.fraction(coeff.numerator(), coeff.denominator());
            IAST monomTimes = F.Times((IExpr)coeffValue);
            int i = 0;
            while (i < exp.length()) {
                long lExp = exp.getVal(i);
                if (lExp != 0L) {
                    if (getVar) {
                        variable = this.fVariables.get(i);
                    }
                    monomTimes.add(F.Power(variable, F.integer(lExp)));
                }
                ++i;
            }
            result.add(monomTimes);
        }
        return result;
    }

    public IAST polyAlgebraicNumber2Expr(GenPolynomial<AlgebraicNumber<BigRational>> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        SortedMap<ExpVector, AlgebraicNumber<BigRational>> val = poly.getMap();
        if (val.size() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        IAST result = F.Plus();
        String symbolName = ((GenPolynomialRing)poly.factory()).getVars()[0];
        ISymbol sym = F.symbol(symbolName);
        for (Map.Entry<ExpVector, AlgebraicNumber<BigRational>> m : val.entrySet()) {
            AlgebraicNumber<BigRational> c = m.getValue();
            IAST times = F.Times();
            ExpVector e = m.getKey();
            if (!c.isONE() || e.isZERO()) {
                times.add(this.algebraicNumber2Expr(c, sym));
            }
            if (e != null && sym != null) {
                long lExp = e.getVal(0);
                if (lExp != 0L) {
                    times.add(F.Power((IExpr)sym, F.integer(lExp)));
                } else {
                    times.add(F.Power((IExpr)sym, F.integer(lExp)));
                }
            }
            if (times.size() <= 1) continue;
            result.add(times);
        }
        return result;
    }

    public IAST algebraicNumber2Expr(AlgebraicNumber<BigRational> coeff, IExpr variable) throws ArithmeticException, ClassCastException {
        GenPolynomial<BigRational> val = coeff.val;
        return this.poly2Expr(val, variable);
    }

    public IAST quotIntegral2Expr(QuotIntegral<BigRational> integral) {
        IAST sum = F.Plus();
        List rational = integral.rational;
        List logarithm = integral.logarithm;
        if (rational.size() != 0) {
            int i = 0;
            while (i < rational.size()) {
                Quotient quotient = rational.get(i);
                GenPolynomial<BigRational> qNum = quotient.num;
                GenPolynomial<BigRational> qDen = quotient.den;
                sum.add(F.Times((IExpr)this.poly2Expr(qNum, null), (IExpr)F.Power((IExpr)this.poly2Expr(qDen, null), F.CN1)));
                ++i;
            }
        }
        if (logarithm.size() != 0) {
            for (LogIntegral<BigRational> logIntegral : logarithm) {
                sum.add(this.logIntegral2Expr(logIntegral));
            }
        }
        return sum;
    }

    public IAST rationalPoly2Expr(GenPolynomial<BigRational> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        IAST result = F.Plus();
        for (Monomial<BigRational> monomial : poly) {
            BigRational coeff = monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IFraction coeffValue = F.fraction(coeff.numerator(), coeff.denominator());
            IAST monomTimes = F.Times((IExpr)coeffValue);
            int i = 0;
            while (i < exp.length()) {
                long lExp = exp.getVal(i);
                if (lExp != 0L) {
                    monomTimes.add(F.Power(this.fVariables.get(i), F.integer(lExp)));
                }
                ++i;
            }
            result.add(monomTimes);
        }
        return result;
    }

    public static IComplex jas2Complex(Complex<BigRational> c) {
        IFraction re = F.fraction(c.getRe().numerator(), c.getRe().denominator());
        IFraction im = F.fraction(c.getIm().numerator(), c.getIm().denominator());
        return F.complex(re, im);
    }
}

