/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import apache.harmony.math.BigInteger;
import java.math.BigDecimal;
import java.util.List;
import org.matheclipse.core.convert.ConversionException;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Object2Expr {
    public static final Object2Expr CONST = new Object2Expr(Object.class, IExpr.class);

    public Object2Expr(Class sType, Class tType) {
    }

    public IExpr convert(Object obj) throws ConversionException {
        if (obj == null) {
            return F.Null;
        }
        if (obj instanceof IExpr) {
            return (IExpr)obj;
        }
        if (obj instanceof Boolean) {
            if (((Boolean)obj).booleanValue()) {
                return F.True;
            }
            return F.False;
        }
        if (obj instanceof BigInteger) {
            return F.integer((BigInteger)obj);
        }
        if (obj instanceof java.math.BigInteger) {
            return F.integer((java.math.BigInteger)obj);
        }
        if (obj instanceof Number) {
            if (obj instanceof BigDecimal) {
                return F.num(((BigDecimal)obj).doubleValue());
            }
            if (obj instanceof Double) {
                return F.num((Double)obj);
            }
            if (obj instanceof Float) {
                return F.num(((Float)obj).doubleValue());
            }
            return F.integer(((Number)obj).longValue());
        }
        if (obj instanceof List) {
            List lst = (List)obj;
            IAST list = null;
            if (lst.size() == 0) {
                list = F.List();
            } else {
                ISymbol head = F.symbol(lst.get(0).toString());
                list = F.function(head);
                int i = 1;
                while (i < lst.size()) {
                    list.add(this.convert(lst.get(i)));
                    ++i;
                }
            }
            return list;
        }
        if (obj instanceof Object[]) {
            IAST list = F.List();
            Object[] array = (Object[])obj;
            int i = 0;
            while (i < array.length) {
                list.add(this.convert(array[i]));
                ++i;
            }
            return list;
        }
        if (obj instanceof int[]) {
            return AST.newInstance(F.List, (int[])obj);
        }
        if (obj instanceof double[]) {
            return AST.newInstance(F.List, (double[])obj);
        }
        if (obj instanceof double[][]) {
            double[][] dd = (double[][])obj;
            IAST list = F.List();
            int i = 0;
            while (i < dd.length) {
                IAST row = F.List();
                int j = 0;
                while (j < dd[i].length) {
                    row.add(F.num(dd[i][j]));
                    ++j;
                }
                list.add(row);
                ++i;
            }
            return list;
        }
        if (obj instanceof boolean[]) {
            IAST list = F.List();
            boolean[] array = (boolean[])obj;
            int i = 0;
            while (i < array.length) {
                if (array[i]) {
                    list.add(F.True);
                } else {
                    list.add(F.False);
                }
                ++i;
            }
            return list;
        }
        return F.stringx(obj.toString());
    }
}

