/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert.experimental;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.matheclipse.core.convert.experimental.Term;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class Poly2BigIntegerConverter {
    private Poly2BigIntegerConverter() {
    }

    public static BigInteger[] expr2Polynomial(IExpr expr, ISymbol variable) throws ArithmeticException, ClassCastException {
        Term term;
        BigInteger[] result = null;
        ArrayList<Term> list = new ArrayList<Term>();
        Poly2BigIntegerConverter.expr2TermList(expr, variable, list);
        int exponent = 0;
        int i = 0;
        while (i < list.size()) {
            term = (Term)list.get(i);
            if (term.getExponent() > exponent) {
                exponent = term.getExponent();
            }
            ++i;
        }
        result = new BigInteger[exponent + 1];
        i = 0;
        while (i < result.length) {
            result[i] = BigInteger.ZERO;
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            term = (Term)list.get(i);
            result[term.getExponent()] = term.getCoefficient();
            ++i;
        }
        return result;
    }

    public static void expr2TermList(IExpr expr, ISymbol variable, List<Term> list) throws ArithmeticException, ClassCastException {
        if (expr instanceof IAST) {
            IAST ast = (IAST)expr;
            if (ast.isASTSizeGE(F.Plus, 2)) {
                int i = 1;
                while (i < ast.size()) {
                    list.add(Poly2BigIntegerConverter.expr2term((IExpr)ast.get(i), variable));
                    ++i;
                }
                return;
            }
        } else {
            list.add(Poly2BigIntegerConverter.expr2term(expr, variable));
            return;
        }
        throw new ClassCastException("This expression conversion is not yet implemented: " + expr.toString());
    }

    public static Term expr2term(IExpr expr, ISymbol variable) throws ArithmeticException, ClassCastException {
        if (expr instanceof IAST) {
            IAST ast = (IAST)expr;
            if (ast.isAST(F.Times, 3) && ast.get(1) instanceof IInteger) {
                IExpr arg2 = (IExpr)ast.get(2);
                if (arg2 instanceof IAST) {
                    int exponent = Poly2BigIntegerConverter.getExponent((IAST)arg2, variable);
                    if (exponent > 0) {
                        return new Term(exponent, Poly2BigIntegerConverter.integer2BigInteger((IntegerSym)ast.get(1)));
                    }
                } else if (arg2 instanceof ISymbol && variable.equals(arg2)) {
                    return new Term(1, Poly2BigIntegerConverter.integer2BigInteger((IntegerSym)ast.get(1)));
                }
            } else {
                int exponent = Poly2BigIntegerConverter.getExponent(ast, variable);
                if (exponent > 0) {
                    return new Term(exponent, BigInteger.ONE);
                }
            }
        } else {
            if (expr instanceof ISymbol && variable.equals(expr)) {
                return new Term(1, BigInteger.ONE);
            }
            if (expr instanceof IInteger) {
                return new Term(0, Poly2BigIntegerConverter.integer2BigInteger((IntegerSym)expr));
            }
        }
        throw new ClassCastException("expr2term(): this expression conversion is not yet implemented: " + expr.toString());
    }

    private static int getExponent(IAST ast, ISymbol variable) {
        if (ast.isAST(F.Power, 3) && variable.equals(ast.get(1))) {
            return ((IInteger)ast.get(2)).toInt();
        }
        return -1;
    }

    public static BigInteger integer2BigInteger(IntegerSym expr) {
        return new BigInteger(expr.getBigNumerator().toByteArray());
    }

    public static IExpr polynomial2Expr(BigInteger[] polyArray, ISymbol variable) {
        if (polyArray == null) {
            return null;
        }
        IAST plus = F.Plus();
        int i = 0;
        while (i < polyArray.length) {
            if (!polyArray[i].equals(BigInteger.ZERO)) {
                plus.add(F.Times((IExpr)F.integer(polyArray[i]), (IExpr)F.Power((IExpr)variable, F.integer(i))));
            }
            ++i;
        }
        return plus;
    }
}

