/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert.experimental;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class UnivariateFactorizationOverZ {
    public static void main(String[] args) {
        int polynomialDegree = 5;
        BigInteger[] polynomial = new BigInteger[polynomialDegree + 1];
        polynomial[5] = new BigInteger("-1");
        polynomial[4] = new BigInteger("15");
        polynomial[3] = new BigInteger("-90");
        polynomial[2] = new BigInteger("270");
        polynomial[1] = new BigInteger("-405");
        polynomial[0] = new BigInteger("243");
        System.out.println("polynomial is ");
        int index = polynomialDegree;
        while (index >= 0) {
            System.out.print(polynomial[index]);
            if (index > 0) {
                System.out.print("x^");
                System.out.print(index);
                System.out.print(" + ");
            }
            --index;
        }
        System.out.println();
        System.out.println();
        List univariateFactorizationOverZresult = UnivariateFactorizationOverZ.univariateFactorizationOverZ(polynomial, polynomialDegree);
        System.out.println("factors are");
        int runIndex = 0;
        while (runIndex <= univariateFactorizationOverZresult.size() - 1) {
            System.out.print("(");
            index = (Integer)univariateFactorizationOverZresult.get(runIndex);
            while (index >= 0) {
                BigInteger temp = ((BigInteger[])univariateFactorizationOverZresult.get(runIndex + 1))[index];
                if (!temp.equals(BigInteger.ZERO)) {
                    if (!temp.equals(BigInteger.ONE) || index <= 0) {
                        System.out.print(temp);
                    }
                    if (index > 0) {
                        System.out.print("x^");
                        System.out.print(index);
                        System.out.print(" + ");
                    }
                }
                --index;
            }
            System.out.print(")");
            Integer itemp = (Integer)univariateFactorizationOverZresult.get(runIndex + 2);
            if (itemp != 1) {
                System.out.print("^");
                System.out.print((Integer)univariateFactorizationOverZresult.get(runIndex + 2));
            }
            runIndex += 3;
        }
        System.out.println();
        System.out.println();
    }

    public static List univariateFactorizationOverZ(BigInteger[] polynomial, int polynomialDegree) {
        int columnIndex;
        int runIndex;
        int index;
        ArrayList dummyList = new ArrayList();
        ArrayList<Object> factors = new ArrayList<Object>();
        ArrayList<Object> newFactors = new ArrayList<Object>();
        boolean negate = false;
        if (polynomial[polynomialDegree].compareTo(BigInteger.ZERO) == -1) {
            negate = true;
            index = 0;
            while (index <= polynomialDegree) {
                polynomial[index] = polynomial[index].negate();
                ++index;
            }
        }
        BigInteger content = polynomial[0].gcd(polynomial[1]);
        if (polynomialDegree > 1) {
            index = 2;
            while (index <= polynomialDegree) {
                content = content.gcd(polynomial[index]);
                ++index;
            }
        }
        index = 0;
        while (index <= polynomialDegree) {
            polynomial[index] = polynomial[index].divide(content);
            ++index;
        }
        if (negate) {
            content = content.negate();
        }
        BigInteger[] dummy = new BigInteger[]{content};
        factors.add(0);
        factors.add(dummy);
        factors.add(polynomialDegree);
        factors.add(polynomial);
        boolean halt = false;
        while (!halt) {
            int polynomialPrimeDegree;
            BigInteger[] polynomialPrime = new BigInteger[polynomialDegree];
            index = polynomialPrimeDegree = polynomialDegree - 1;
            while (index >= 0) {
                polynomialPrime[index] = polynomial[index + 1].multiply(BigInteger.valueOf(index + 1));
                --index;
            }
            BigInteger[][][] dummyOne = new BigInteger[polynomialDegree + 1][3][3];
            index = 0;
            while (index <= polynomialDegree) {
                dummyOne[index][1][1] = polynomial[index];
                dummyOne[index][1][2] = BigInteger.ONE;
                dummyOne[index][2][1] = BigInteger.ZERO;
                dummyOne[index][2][2] = BigInteger.ONE;
                ++index;
            }
            BigInteger[][][] dummyTwo = new BigInteger[polynomialPrimeDegree + 1][3][3];
            index = 0;
            while (index <= polynomialPrimeDegree) {
                dummyTwo[index][1][1] = polynomialPrime[index];
                dummyTwo[index][1][2] = BigInteger.ONE;
                dummyTwo[index][2][1] = BigInteger.ZERO;
                dummyTwo[index][2][2] = BigInteger.ONE;
                ++index;
            }
            List univariatePolynomialGCDresult = UnivariateFactorizationOverZ.univariatePolynomialGCD(dummyOne, dummyTwo, polynomialDegree, polynomialPrimeDegree, 100);
            if ((Integer)univariatePolynomialGCDresult.get(0) == 0 && ((BigInteger[][][])univariatePolynomialGCDresult.get(1))[0][1][1].compareTo(BigInteger.ONE) == 0) {
                halt = true;
                continue;
            }
            factors.remove(factors.size() - 1);
            factors.remove(factors.size() - 1);
            int dummyTwoDegree = (Integer)univariatePolynomialGCDresult.get(0);
            dummyTwo = new BigInteger[dummyTwoDegree + 1][3][3];
            index = 0;
            while (index <= dummyTwoDegree) {
                dummyTwo[index][1][1] = ((BigInteger[][][])univariatePolynomialGCDresult.get(1))[index][1][1];
                dummyTwo[index][1][2] = BigInteger.ONE;
                dummyTwo[index][2][1] = BigInteger.ZERO;
                dummyTwo[index][2][2] = BigInteger.ONE;
                ++index;
            }
            List polynomialDivisionResult = UnivariateFactorizationOverZ.polynomialDivision(dummyOne, dummyTwo, polynomialDegree, dummyTwoDegree);
            dummy = new BigInteger[(Integer)polynomialDivisionResult.get(0) + 1];
            index = 0;
            while (index <= (Integer)polynomialDivisionResult.get(0)) {
                dummy[index] = ((BigInteger[][][])polynomialDivisionResult.get(2))[index][1][1];
                ++index;
            }
            factors.add((Integer)polynomialDivisionResult.get(0));
            factors.add(dummy);
            dummy = new BigInteger[dummyTwoDegree + 1];
            index = 0;
            while (index <= dummyTwoDegree) {
                dummy[index] = dummyTwo[index][1][1];
                ++index;
            }
            factors.add(dummyTwoDegree);
            factors.add(dummy);
            polynomialDegree = (Integer)univariatePolynomialGCDresult.get(0);
            index = 0;
            while (index <= polynomialDegree) {
                polynomial[index] = ((BigInteger[][][])univariatePolynomialGCDresult.get(1))[index][1][1];
                ++index;
            }
        }
        int factorizationCount = 1;
        while (factorizationCount != 0) {
            factorizationCount = 0;
            runIndex = 0;
            while (runIndex <= factors.size() - 1) {
                if ((Integer)factors.get(runIndex) > 0) {
                    List zassenhausResult = UnivariateFactorizationOverZ.zassenhausAlgorithm((BigInteger[])factors.get(runIndex + 1), (Integer)factors.get(runIndex));
                    index = 0;
                    while (index <= zassenhausResult.size() - 1) {
                        if (zassenhausResult.size() == 2) {
                            newFactors.add((Integer)zassenhausResult.get(index));
                            newFactors.add((BigInteger[])zassenhausResult.get(index + 1));
                        } else {
                            ++factorizationCount;
                            newFactors.add((Integer)zassenhausResult.get(index));
                            newFactors.add((BigInteger[])zassenhausResult.get(index + 1));
                            newFactors.add((Integer)zassenhausResult.get(index + 2));
                            newFactors.add((BigInteger[])zassenhausResult.get(index + 3));
                        }
                        index += 4;
                    }
                } else {
                    newFactors.add((Integer)factors.get(runIndex));
                    newFactors.add((BigInteger[])factors.get(runIndex + 1));
                }
                runIndex += 2;
            }
            factors.clear();
            index = 0;
            while (index <= newFactors.size() - 1) {
                dummy = new BigInteger[(Integer)newFactors.get(index) + 1];
                columnIndex = (Integer)newFactors.get(index);
                while (columnIndex >= 0) {
                    dummy[columnIndex] = ((BigInteger[])newFactors.get(index + 1))[columnIndex];
                    --columnIndex;
                }
                factors.add((Integer)newFactors.get(index));
                factors.add(dummy);
                index += 2;
            }
            newFactors.clear();
        }
        newFactors.clear();
        index = 0;
        while (index <= factors.size() - 1) {
            dummy = new BigInteger[(Integer)factors.get(index) + 1];
            columnIndex = (Integer)factors.get(index);
            while (columnIndex >= 0) {
                dummy[columnIndex] = ((BigInteger[])factors.get(index + 1))[columnIndex];
                --columnIndex;
            }
            newFactors.add((Integer)factors.get(index));
            newFactors.add(dummy);
            newFactors.add(1);
            index += 2;
        }
        factors.clear();
        index = 0;
        while (index <= newFactors.size() - 1) {
            dummy = new BigInteger[(Integer)newFactors.get(index) + 1];
            columnIndex = (Integer)newFactors.get(index);
            while (columnIndex >= 0) {
                dummy[columnIndex] = ((BigInteger[])newFactors.get(index + 1))[columnIndex];
                --columnIndex;
            }
            factors.add((Integer)newFactors.get(index));
            factors.add(dummy);
            factors.add((Integer)newFactors.get(index + 2));
            index += 3;
        }
        int startPoint = 0;
        while (startPoint <= factors.size() - 6) {
            boolean match = true;
            while (match) {
                match = false;
                boolean loopHalt = false;
                runIndex = startPoint + 3;
                while (runIndex <= factors.size() - 3 & !loopHalt) {
                    if ((Integer)factors.get(startPoint) == (Integer)factors.get(runIndex)) {
                        halt = false;
                        index = (Integer)factors.get(startPoint);
                        while (index >= 0 & !halt) {
                            if (((BigInteger[])factors.get(startPoint + 1))[index].compareTo(((BigInteger[])factors.get(runIndex + 1))[index]) != 0) {
                                halt = true;
                                continue;
                            }
                            --index;
                        }
                        if (!halt) {
                            match = true;
                            loopHalt = true;
                            int sum = (Integer)factors.get(startPoint + 2) + (Integer)factors.get(runIndex + 2);
                            factors.remove(startPoint + 2);
                            factors.add(startPoint + 2, sum);
                            factors.remove(runIndex);
                            factors.remove(runIndex);
                            factors.remove(runIndex);
                        }
                    }
                    runIndex += 3;
                }
            }
            startPoint += 3;
        }
        int passes = 1;
        while (passes != 0) {
            passes = 0;
            index = 0;
            while (index <= factors.size() - 4) {
                boolean exchange = false;
                if ((Integer)factors.get(index + 2) > (Integer)factors.get(index + 5) || (Integer)factors.get(index + 2) == (Integer)factors.get(index + 5) && (Integer)factors.get(index) > (Integer)factors.get(index + 3)) {
                    exchange = true;
                }
                if ((Integer)factors.get(index + 2) == (Integer)factors.get(index + 5) && (Integer)factors.get(index) == (Integer)factors.get(index + 3)) {
                    halt = false;
                    runIndex = (Integer)factors.get(index);
                    while (runIndex >= 0 & !halt) {
                        if (((BigInteger[])factors.get(index + 1))[runIndex].compareTo(((BigInteger[])factors.get(index + 4))[runIndex]) == 0) {
                            --runIndex;
                            continue;
                        }
                        halt = true;
                    }
                    if (halt && ((BigInteger[])factors.get(index + 1))[runIndex].abs().compareTo(((BigInteger[])factors.get(index + 4))[runIndex].abs()) == 1) {
                        exchange = true;
                    }
                }
                if (exchange) {
                    dummyList.clear();
                    dummyList.add(factors.get(index));
                    dummyList.add(factors.get(index + 1));
                    dummyList.add(factors.get(index + 2));
                    factors.set(index, factors.get(index + 3));
                    factors.set(index + 1, factors.get(index + 4));
                    factors.set(index + 2, factors.get(index + 5));
                    factors.set(index + 3, dummyList.get(0));
                    factors.set(index + 4, dummyList.get(1));
                    factors.set(index + 5, dummyList.get(2));
                    ++passes;
                }
                index += 3;
            }
        }
        return factors;
    }

    public static List zassenhausAlgorithm(BigInteger[] aPolynomial, int aPolynomialDegree) {
        List extendedEuclideanAlgorithmModularResult;
        BigInteger[] trialFactor = new BigInteger[]{};
        BigInteger[] otherFactor = new BigInteger[]{};
        BigInteger leadingCoefficient = aPolynomial[aPolynomialDegree];
        BigInteger modifier = BigInteger.ZERO;
        int partitionNumber = 0;
        int trialFactorDegree = 0;
        int toleranceLimit = 50;
        int otherFactorDegree = 0;
        int PpolynomialPrimeDegree = aPolynomialDegree - 1;
        Random generator = new Random();
        ArrayList<Integer> removalSet = new ArrayList<Integer>();
        ArrayList<Integer> removalSetCompliment = new ArrayList<Integer>();
        ArrayList Glist = new ArrayList();
        ArrayList Hlist = new ArrayList();
        ArrayList<Object> factors = new ArrayList<Object>();
        ArrayList<Object> resultFactors = new ArrayList<Object>();
        BigInteger highestAbsoluteCoefficient = BigInteger.ZERO;
        int index = 0;
        while (index <= aPolynomialDegree) {
            if (aPolynomial[index].abs().compareTo(highestAbsoluteCoefficient) == 1) {
                highestAbsoluteCoefficient = aPolynomial[index].abs();
            }
            ++index;
        }
        BigInteger[] Ppolynomial = new BigInteger[aPolynomialDegree + 1];
        index = 0;
        while (index <= aPolynomialDegree) {
            Ppolynomial[index] = aPolynomial[index];
            ++index;
        }
        BigInteger[] PprimePolynomial = new BigInteger[aPolynomialDegree];
        index = PpolynomialPrimeDegree;
        while (index >= 0) {
            PprimePolynomial[index] = Ppolynomial[index + 1].multiply(BigInteger.valueOf(index + 1));
            --index;
        }
        int pValue = 2;
        boolean halt = false;
        while (!halt) {
            BigInteger testPrime = BigInteger.valueOf(pValue);
            if (testPrime.isProbablePrime(100)) {
                extendedEuclideanAlgorithmModularResult = UnivariateFactorizationOverZ.extendedEuclideanAlgorithmModular(Ppolynomial, PprimePolynomial, aPolynomialDegree, PpolynomialPrimeDegree, testPrime);
                if (!((Boolean)extendedEuclideanAlgorithmModularResult.get(0)).booleanValue()) {
                    if ((Integer)extendedEuclideanAlgorithmModularResult.get(1) == 0 && ((BigInteger[])extendedEuclideanAlgorithmModularResult.get(2))[0].compareTo(BigInteger.ONE) == 0 && leadingCoefficient.divideAndRemainder(BigInteger.valueOf(pValue))[1].compareTo(BigInteger.ZERO) != 0) {
                        halt = true;
                        continue;
                    }
                    ++pValue;
                    continue;
                }
                ++pValue;
                continue;
            }
            ++pValue;
        }
        int normalisedPolynomialDegree = aPolynomialDegree;
        BigInteger[] normalisedPolynomial = new BigInteger[normalisedPolynomialDegree + 1];
        index = 0;
        while (index <= normalisedPolynomialDegree) {
            normalisedPolynomial[index] = aPolynomial[index];
            ++index;
        }
        BigInteger pValueB = BigInteger.valueOf(pValue);
        List inverseElementResult = UnivariateFactorizationOverZ.multiplicativeInverse(leadingCoefficient, pValueB);
        BigInteger inverseElement = (BigInteger)inverseElementResult.get(1);
        index = 0;
        while (index <= normalisedPolynomialDegree) {
            normalisedPolynomial[index] = normalisedPolynomial[index].multiply(inverseElement);
            if (normalisedPolynomial[index].abs().compareTo(pValueB) != -1) {
                normalisedPolynomial[index] = normalisedPolynomial[index].divideAndRemainder(pValueB)[1];
            }
            if (normalisedPolynomial[index].compareTo(BigInteger.ZERO) == -1) {
                normalisedPolynomial[index] = normalisedPolynomial[index].add(pValueB);
            }
            ++index;
        }
        List berlekampFactorizationResult = UnivariateFactorizationOverZ.berlekampAlgorithm(normalisedPolynomial, normalisedPolynomialDegree, pValue);
        int attemptNumber = 1;
        index = berlekampFactorizationResult.size() / 2;
        while (index > berlekampFactorizationResult.size() / 2 - 2) {
            attemptNumber *= index;
            --index;
        }
        attemptNumber = 10 * (attemptNumber / 2);
        if (berlekampFactorizationResult.size() / 2 > 1) {
            int indexCount = 0;
            int runIndex = 0;
            while (runIndex <= berlekampFactorizationResult.size() - 1) {
                indexCount += runIndex;
                BigInteger[] copyArray = new BigInteger[(Integer)berlekampFactorizationResult.get(runIndex) + 1];
                factors.add((Integer)berlekampFactorizationResult.get(runIndex));
                index = (Integer)berlekampFactorizationResult.get(runIndex);
                while (index >= 0) {
                    copyArray[index] = ((BigInteger[])berlekampFactorizationResult.get(runIndex + 1))[index];
                    --index;
                }
                factors.add(copyArray);
                runIndex += 2;
            }
            boolean loopHalt = false;
            int attemptIndex = 1;
            while (!loopHalt & attemptIndex <= attemptNumber) {
                BigInteger[] Hpolynomial;
                int HpolynomialDegree;
                List polynomialArithmeticModularResult;
                BigInteger[] dummy;
                int dummyDegree;
                BigInteger[] Gpolynomial;
                int GpolynomialDegree;
                Glist.clear();
                Hlist.clear();
                removalSet.clear();
                removalSetCompliment.clear();
                runIndex = 0;
                while (runIndex <= berlekampFactorizationResult.size() - 1) {
                    removalSet.add(runIndex);
                    runIndex += 2;
                }
                halt = false;
                while (!halt) {
                    partitionNumber = generator.nextInt(berlekampFactorizationResult.size() / 2);
                    if (partitionNumber == 0) continue;
                    halt = true;
                }
                index = 1;
                while (index <= partitionNumber) {
                    int removalIndex = generator.nextInt(removalSet.size());
                    int value = (Integer)removalSet.get(removalIndex);
                    removalSet.remove(removalIndex);
                    removalSetCompliment.add(value);
                    ++index;
                }
                runIndex = 0;
                while (runIndex <= removalSet.size() - 1) {
                    Glist.add(factors.get((Integer)removalSet.get(runIndex)));
                    Glist.add(factors.get((Integer)removalSet.get(runIndex) + 1));
                    ++runIndex;
                }
                runIndex = 0;
                while (runIndex <= removalSetCompliment.size() - 1) {
                    Hlist.add(factors.get((Integer)removalSetCompliment.get(runIndex)));
                    Hlist.add(factors.get((Integer)removalSetCompliment.get(runIndex) + 1));
                    ++runIndex;
                }
                if (removalSet.size() == 1) {
                    GpolynomialDegree = (Integer)Glist.get(0);
                    Gpolynomial = new BigInteger[GpolynomialDegree + 1];
                    index = GpolynomialDegree;
                    while (index >= 0) {
                        Gpolynomial[index] = ((BigInteger[])Glist.get(1))[index];
                        --index;
                    }
                } else {
                    GpolynomialDegree = (Integer)Glist.get(0);
                    Gpolynomial = new BigInteger[GpolynomialDegree + 1];
                    index = GpolynomialDegree;
                    while (index >= 0) {
                        Gpolynomial[index] = ((BigInteger[])Glist.get(1))[index];
                        --index;
                    }
                    runIndex = 0;
                    while (runIndex <= Glist.size() - 3) {
                        dummyDegree = (Integer)Glist.get(runIndex + 2);
                        dummy = new BigInteger[dummyDegree + 1];
                        index = dummyDegree;
                        while (index >= 0) {
                            dummy[index] = ((BigInteger[])Glist.get(runIndex + 3))[index];
                            --index;
                        }
                        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(Gpolynomial, dummy, GpolynomialDegree, dummyDegree, pValueB, '*');
                        GpolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
                        Gpolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
                        runIndex += 2;
                    }
                }
                if (removalSetCompliment.size() == 1) {
                    HpolynomialDegree = (Integer)Hlist.get(0);
                    Hpolynomial = new BigInteger[HpolynomialDegree + 1];
                    index = HpolynomialDegree;
                    while (index >= 0) {
                        Hpolynomial[index] = ((BigInteger[])Hlist.get(1))[index];
                        --index;
                    }
                } else {
                    HpolynomialDegree = (Integer)Hlist.get(0);
                    Hpolynomial = new BigInteger[HpolynomialDegree + 1];
                    index = HpolynomialDegree;
                    while (index >= 0) {
                        Hpolynomial[index] = ((BigInteger[])Hlist.get(1))[index];
                        --index;
                    }
                    runIndex = 0;
                    while (runIndex <= Hlist.size() - 3) {
                        dummyDegree = (Integer)Hlist.get(runIndex + 2);
                        dummy = new BigInteger[dummyDegree + 1];
                        index = dummyDegree;
                        while (index >= 0) {
                            dummy[index] = ((BigInteger[])Hlist.get(runIndex + 3))[index];
                            --index;
                        }
                        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(Hpolynomial, dummy, HpolynomialDegree, dummyDegree, pValueB, '*');
                        HpolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
                        Hpolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
                        runIndex += 2;
                    }
                }
                index = 0;
                while (index <= GpolynomialDegree) {
                    Gpolynomial[index] = Gpolynomial[index].multiply(leadingCoefficient);
                    if (Gpolynomial[index].abs().compareTo(pValueB) != -1) {
                        Gpolynomial[index] = Gpolynomial[index].divideAndRemainder(pValueB)[1];
                    }
                    if (Gpolynomial[index].compareTo(BigInteger.ZERO) == -1) {
                        Gpolynomial[index] = Gpolynomial[index].add(pValueB);
                    }
                    ++index;
                }
                extendedEuclideanAlgorithmModularResult = UnivariateFactorizationOverZ.extendedEuclideanAlgorithmModular(Gpolynomial, Hpolynomial, GpolynomialDegree, HpolynomialDegree, pValueB);
                int sBezoutDegree = (Integer)extendedEuclideanAlgorithmModularResult.get(3);
                BigInteger[] sBezout = (BigInteger[])extendedEuclideanAlgorithmModularResult.get(4);
                int tBezoutDegree = (Integer)extendedEuclideanAlgorithmModularResult.get(5);
                BigInteger[] tBezout = (BigInteger[])extendedEuclideanAlgorithmModularResult.get(6);
                if ((Integer)extendedEuclideanAlgorithmModularResult.get(1) == 0 && ((BigInteger[])extendedEuclideanAlgorithmModularResult.get(2))[0].compareTo(BigInteger.ONE) == 0) {
                    int kIndex = 1;
                    halt = false;
                    while (kIndex <= toleranceLimit & !halt) {
                        List henselStepResult = UnivariateFactorizationOverZ.henselStep(Ppolynomial, Gpolynomial, Hpolynomial, sBezout, tBezout, aPolynomialDegree, GpolynomialDegree, HpolynomialDegree, sBezoutDegree, tBezoutDegree, pValueB.pow(kIndex));
                        GpolynomialDegree = (Integer)henselStepResult.get(0);
                        Gpolynomial = (BigInteger[])henselStepResult.get(1);
                        HpolynomialDegree = (Integer)henselStepResult.get(2);
                        Hpolynomial = (BigInteger[])henselStepResult.get(3);
                        sBezoutDegree = (Integer)henselStepResult.get(4);
                        sBezout = (BigInteger[])henselStepResult.get(5);
                        tBezoutDegree = (Integer)henselStepResult.get(6);
                        tBezout = (BigInteger[])henselStepResult.get(7);
                        BigInteger highestAbsoluteGpolynomialCoefficient = BigInteger.ZERO;
                        index = 0;
                        while (index <= GpolynomialDegree) {
                            if (Gpolynomial[index].abs().compareTo(highestAbsoluteGpolynomialCoefficient) == 1) {
                                highestAbsoluteGpolynomialCoefficient = Gpolynomial[index].abs();
                            }
                            ++index;
                        }
                        BigInteger highestAbsoluteHpolynomialCoefficient = BigInteger.ZERO;
                        index = 0;
                        while (index <= HpolynomialDegree) {
                            if (Hpolynomial[index].abs().compareTo(highestAbsoluteHpolynomialCoefficient) == 1) {
                                highestAbsoluteHpolynomialCoefficient = Hpolynomial[index].abs();
                            }
                            ++index;
                        }
                        if (highestAbsoluteGpolynomialCoefficient.compareTo(highestAbsoluteCoefficient) == 1 || highestAbsoluteHpolynomialCoefficient.compareTo(highestAbsoluteCoefficient) == 1) {
                            halt = true;
                            modifier = pValueB.pow(kIndex).pow(2);
                            continue;
                        }
                        ++kIndex;
                    }
                    trialFactorDegree = GpolynomialDegree;
                    trialFactor = new BigInteger[trialFactorDegree + 1];
                    index = GpolynomialDegree;
                    while (index >= 0) {
                        trialFactor[index] = Gpolynomial[index].abs().compareTo(highestAbsoluteCoefficient) == 1 ? Gpolynomial[index].subtract(modifier) : Gpolynomial[index];
                        --index;
                    }
                    BigInteger content = trialFactor[0].gcd(trialFactor[1]);
                    if (trialFactorDegree > 1) {
                        index = 2;
                        while (index <= trialFactorDegree) {
                            content = content.gcd(trialFactor[index]);
                            ++index;
                        }
                    }
                    index = 0;
                    while (index <= trialFactorDegree) {
                        trialFactor[index] = trialFactor[index].divide(content);
                        ++index;
                    }
                    int dummyOneDegree = aPolynomialDegree;
                    BigInteger[][][] dummyOne = new BigInteger[dummyOneDegree + 1][3][3];
                    index = 0;
                    while (index <= aPolynomialDegree) {
                        dummyOne[index][1][1] = Ppolynomial[index];
                        dummyOne[index][1][2] = BigInteger.ONE;
                        dummyOne[index][2][1] = BigInteger.ZERO;
                        dummyOne[index][2][2] = BigInteger.ONE;
                        ++index;
                    }
                    int dummyTwoDegree = trialFactorDegree;
                    BigInteger[][][] dummyTwo = new BigInteger[dummyTwoDegree + 1][3][3];
                    index = 0;
                    while (index <= trialFactorDegree) {
                        dummyTwo[index][1][1] = trialFactor[index];
                        dummyTwo[index][1][2] = BigInteger.ONE;
                        dummyTwo[index][2][1] = BigInteger.ZERO;
                        dummyTwo[index][2][2] = BigInteger.ONE;
                        ++index;
                    }
                    List polynomialDivisionResult = UnivariateFactorizationOverZ.polynomialDivision(dummyOne, dummyTwo, dummyOneDegree, dummyTwoDegree);
                    boolean QdenominatorsAllOne = true;
                    index = 0;
                    while (index <= (Integer)polynomialDivisionResult.get(0) & QdenominatorsAllOne) {
                        if (((BigInteger[][][])polynomialDivisionResult.get(2))[index][1][2].compareTo(BigInteger.ONE) != 0) {
                            QdenominatorsAllOne = false;
                            continue;
                        }
                        ++index;
                    }
                    otherFactorDegree = (Integer)polynomialDivisionResult.get(0);
                    otherFactor = new BigInteger[otherFactorDegree + 1];
                    index = otherFactorDegree;
                    while (index >= 0) {
                        otherFactor[index] = ((BigInteger[][][])polynomialDivisionResult.get(2))[index][1][1];
                        --index;
                    }
                    if ((Integer)polynomialDivisionResult.get(1) == 0 & ((BigInteger[][][])polynomialDivisionResult.get(3))[0][1][1].compareTo(BigInteger.ZERO) == 0 & QdenominatorsAllOne) {
                        loopHalt = true;
                        continue;
                    }
                    ++attemptIndex;
                    continue;
                }
                ++attemptIndex;
            }
            if (loopHalt) {
                resultFactors.add(trialFactorDegree);
                resultFactors.add(trialFactor);
                resultFactors.add(otherFactorDegree);
                resultFactors.add(otherFactor);
            } else {
                resultFactors.add(aPolynomialDegree);
                resultFactors.add(Ppolynomial);
            }
        } else {
            resultFactors.add(aPolynomialDegree);
            resultFactors.add(Ppolynomial);
        }
        return resultFactors;
    }

    public static List berlekampAlgorithm(BigInteger[] aPolynomial, int aPolynomialDegree, int qValue) {
        ArrayList<Object> factors = new ArrayList<Object>();
        ArrayList<BigInteger[]> vVectorsList = new ArrayList<BigInteger[]>();
        int index = 0;
        while (index <= aPolynomialDegree) {
            if (aPolynomial[index].abs().compareTo(new BigInteger(String.valueOf(qValue))) != -1) {
                aPolynomial[index] = aPolynomial[index].divideAndRemainder(new BigInteger(String.valueOf(qValue)))[1];
            }
            if (aPolynomial[index].compareTo(BigInteger.ZERO) == -1) {
                aPolynomial[index] = aPolynomial[index].add(new BigInteger(String.valueOf(qValue)));
            }
            ++index;
        }
        boolean halt = false;
        while (!halt && aPolynomialDegree > 0) {
            if (aPolynomial[aPolynomialDegree].compareTo(BigInteger.ZERO) != 0) {
                halt = true;
                continue;
            }
            --aPolynomialDegree;
        }
        if (aPolynomialDegree > 0) {
            int nValue = aPolynomialDegree;
            BigInteger[][] berlekampMatrix = new BigInteger[nValue][nValue];
            BigInteger[][] Mmatrix = new BigInteger[nValue][nValue];
            int columnIndex = 0;
            while (columnIndex <= nValue - 1) {
                berlekampMatrix[0][columnIndex] = columnIndex == 0 ? BigInteger.ONE : BigInteger.ZERO;
                ++columnIndex;
            }
            BigInteger[] berlekampProduct = new BigInteger[nValue];
            BigInteger[] newRow = new BigInteger[nValue];
            BigInteger[] originalRow = new BigInteger[nValue];
            BigInteger[] row = new BigInteger[nValue];
            index = nValue - 1;
            while (index >= 0) {
                berlekampProduct[index] = aPolynomial[index].negate();
                newRow[index] = berlekampProduct[index];
                originalRow[index] = berlekampProduct[index];
                --index;
            }
            int mIndex = 1;
            while (mIndex <= (nValue - 1) * qValue) {
                if (nValue < mIndex) {
                    index = nValue - 1;
                    while (index >= 1) {
                        newRow[index] = berlekampProduct[nValue - 1].multiply(originalRow[index]).add(berlekampProduct[index - 1]);
                        if (newRow[index].abs().compareTo(new BigInteger(String.valueOf(qValue))) != -1) {
                            newRow[index] = newRow[index].divideAndRemainder(new BigInteger(String.valueOf(qValue)))[1];
                        }
                        if (newRow[index].compareTo(BigInteger.ZERO) == -1) {
                            newRow[index] = newRow[index].add(new BigInteger(String.valueOf(qValue)));
                        }
                        --index;
                    }
                    newRow[0] = berlekampProduct[nValue - 1].multiply(originalRow[0]);
                    if (newRow[0].abs().compareTo(new BigInteger(String.valueOf(qValue))) != -1) {
                        newRow[0] = newRow[0].divideAndRemainder(new BigInteger(String.valueOf(qValue)))[1];
                    }
                    if (newRow[0].compareTo(BigInteger.ZERO) == -1) {
                        newRow[0] = newRow[0].add(new BigInteger(String.valueOf(qValue)));
                    }
                    index = nValue - 1;
                    while (index >= 0) {
                        berlekampProduct[index] = newRow[index];
                        --index;
                    }
                } else if (nValue > mIndex) {
                    index = nValue - 1;
                    while (index >= 0) {
                        newRow[index] = index == mIndex ? BigInteger.ONE : BigInteger.ZERO;
                        --index;
                    }
                } else {
                    index = nValue - 1;
                    while (index >= 0) {
                        newRow[index] = aPolynomial[index].negate();
                        if (newRow[index].compareTo(BigInteger.ZERO) == -1) {
                            newRow[index] = newRow[index].add(new BigInteger(String.valueOf(qValue)));
                        }
                        --index;
                    }
                }
                if (mIndex % qValue == 0) {
                    index = nValue - 1;
                    while (index >= 0) {
                        berlekampMatrix[mIndex / qValue][index] = newRow[index];
                        --index;
                    }
                }
                ++mIndex;
            }
            int rowIndex = 0;
            while (rowIndex <= nValue - 1) {
                columnIndex = 0;
                while (columnIndex <= nValue - 1) {
                    if (rowIndex == columnIndex) {
                        Mmatrix[rowIndex][columnIndex] = berlekampMatrix[rowIndex][columnIndex].subtract(BigInteger.ONE);
                        if (Mmatrix[rowIndex][columnIndex].compareTo(BigInteger.ZERO) == -1) {
                            Mmatrix[rowIndex][columnIndex] = Mmatrix[rowIndex][columnIndex].add(new BigInteger(String.valueOf(qValue)));
                        }
                    } else {
                        Mmatrix[rowIndex][columnIndex] = berlekampMatrix[rowIndex][columnIndex];
                    }
                    ++columnIndex;
                }
                ++rowIndex;
            }
            int kIndex = 1;
            while (kIndex <= nValue - 1) {
                int iIndex = kIndex;
                halt = false;
                while (iIndex <= nValue - 1 & !halt) {
                    if (Mmatrix[kIndex][iIndex].compareTo(BigInteger.ZERO) == 0) {
                        ++iIndex;
                        continue;
                    }
                    halt = true;
                }
                boolean pass = false;
                if (halt) {
                    pass = true;
                }
                if (!halt && kIndex < nValue - 1) {
                    iIndex = 0;
                    halt = false;
                    boolean pivotColumnFound = false;
                    while (iIndex <= kIndex - 1 && !pivotColumnFound) {
                        if (Mmatrix[kIndex][iIndex].compareTo(BigInteger.ZERO) == 0) {
                            ++iIndex;
                            continue;
                        }
                        rowIndex = 0;
                        halt = false;
                        while (rowIndex < kIndex && !halt) {
                            if (Mmatrix[rowIndex][iIndex].compareTo(BigInteger.ZERO) == 0) {
                                ++rowIndex;
                                continue;
                            }
                            halt = true;
                        }
                        if (!halt) {
                            pivotColumnFound = true;
                            halt = true;
                            continue;
                        }
                        ++iIndex;
                    }
                    if (pivotColumnFound) {
                        pass = true;
                    } else {
                        halt = false;
                    }
                }
                if (pass) {
                    List inverseElementResult = UnivariateFactorizationOverZ.multiplicativeInverse(Mmatrix[kIndex][iIndex], new BigInteger(String.valueOf(qValue)));
                    BigInteger inverseElement = (BigInteger)inverseElementResult.get(1);
                    rowIndex = 0;
                    while (rowIndex <= nValue - 1) {
                        Mmatrix[rowIndex][iIndex] = Mmatrix[rowIndex][iIndex].multiply(inverseElement);
                        if (Mmatrix[rowIndex][iIndex].abs().compareTo(new BigInteger(String.valueOf(qValue))) != -1) {
                            Mmatrix[rowIndex][iIndex] = Mmatrix[rowIndex][iIndex].divideAndRemainder(new BigInteger(String.valueOf(qValue)))[1];
                        }
                        ++rowIndex;
                    }
                    rowIndex = 0;
                    while (rowIndex <= nValue - 1) {
                        BigInteger dummy = Mmatrix[rowIndex][iIndex];
                        Mmatrix[rowIndex][iIndex] = Mmatrix[rowIndex][kIndex];
                        Mmatrix[rowIndex][kIndex] = dummy;
                        ++rowIndex;
                    }
                    BigInteger[] multipliers = new BigInteger[nValue];
                    iIndex = 0;
                    while (iIndex <= nValue - 1) {
                        multipliers[iIndex] = Mmatrix[kIndex][iIndex];
                        ++iIndex;
                    }
                    iIndex = 0;
                    while (iIndex <= nValue - 1) {
                        if (iIndex != kIndex) {
                            rowIndex = 1;
                            while (rowIndex <= nValue - 1) {
                                Mmatrix[rowIndex][iIndex] = Mmatrix[rowIndex][iIndex].subtract(Mmatrix[rowIndex][kIndex].multiply(multipliers[iIndex]));
                                if (Mmatrix[rowIndex][iIndex].abs().compareTo(new BigInteger(String.valueOf(qValue))) != -1) {
                                    Mmatrix[rowIndex][iIndex] = Mmatrix[rowIndex][iIndex].divideAndRemainder(new BigInteger(String.valueOf(qValue)))[1];
                                }
                                if (Mmatrix[rowIndex][iIndex].compareTo(BigInteger.ZERO) == -1) {
                                    Mmatrix[rowIndex][iIndex] = Mmatrix[rowIndex][iIndex].add(new BigInteger(String.valueOf(qValue)));
                                }
                                ++rowIndex;
                            }
                        }
                        ++iIndex;
                    }
                }
                ++kIndex;
            }
            rowIndex = 0;
            while (rowIndex <= nValue - 1) {
                columnIndex = 0;
                while (columnIndex <= nValue - 1) {
                    Mmatrix[rowIndex][columnIndex] = rowIndex == columnIndex ? BigInteger.ONE.subtract(Mmatrix[rowIndex][columnIndex]) : BigInteger.ZERO.subtract(Mmatrix[rowIndex][columnIndex]);
                    if (Mmatrix[rowIndex][columnIndex].abs().compareTo(new BigInteger(String.valueOf(qValue))) != -1) {
                        Mmatrix[rowIndex][columnIndex] = Mmatrix[rowIndex][columnIndex].divideAndRemainder(new BigInteger(String.valueOf(qValue)))[1];
                    }
                    if (Mmatrix[rowIndex][columnIndex].compareTo(BigInteger.ZERO) == -1) {
                        Mmatrix[rowIndex][columnIndex] = Mmatrix[rowIndex][columnIndex].add(new BigInteger(String.valueOf(qValue)));
                    }
                    ++columnIndex;
                }
                ++rowIndex;
            }
            rowIndex = 0;
            while (rowIndex <= nValue - 1) {
                columnIndex = 0;
                halt = false;
                while (columnIndex <= nValue - 1 && !halt) {
                    if (Mmatrix[rowIndex][columnIndex].compareTo(BigInteger.ZERO) != 0) {
                        halt = true;
                        continue;
                    }
                    ++columnIndex;
                }
                if (halt) {
                    row = new BigInteger[nValue];
                    index = 0;
                    while (index <= nValue - 1) {
                        row[index] = Mmatrix[rowIndex][index];
                        ++index;
                    }
                    vVectorsList.add(row);
                }
                ++rowIndex;
            }
            int kValue = vVectorsList.size();
            int factorIndex = 0;
            factors.add(aPolynomialDegree);
            factors.add(aPolynomial);
            BigInteger[] uPolynomial = new BigInteger[nValue + 1];
            while (factors.size() < 2 * kValue && factorIndex <= factors.size() - 1) {
                int uPolynomialDegree = (Integer)factors.get(factorIndex);
                uPolynomial = new BigInteger[uPolynomialDegree + 1];
                index = 0;
                while (index <= (Integer)factors.get(factorIndex)) {
                    uPolynomial[index] = ((BigInteger[])factors.get(factorIndex + 1))[index];
                    ++index;
                }
                int rIndex = 1;
                while (rIndex <= kValue - 1) {
                    halt = false;
                    int vVectorDegree = nValue - 1;
                    while (vVectorDegree >= 0 & !halt) {
                        if (((BigInteger[])vVectorsList.get(rIndex))[vVectorDegree].compareTo(BigInteger.ZERO) == 0) {
                            --vVectorDegree;
                            continue;
                        }
                        halt = true;
                    }
                    BigInteger[] vVector = new BigInteger[vVectorDegree + 1];
                    columnIndex = 0;
                    while (columnIndex <= vVectorDegree) {
                        vVector[columnIndex] = ((BigInteger[])vVectorsList.get(rIndex))[columnIndex];
                        ++columnIndex;
                    }
                    BigInteger originalElement = vVector[0];
                    int sValue = 0;
                    halt = false;
                    while (sValue <= qValue - 1 & !halt) {
                        vVector[0] = vVector[0].add(new BigInteger(String.valueOf(sValue)));
                        List modularGCDresult = UnivariateFactorizationOverZ.extendedEuclideanAlgorithmModular(uPolynomial, vVector, uPolynomialDegree, vVectorDegree, new BigInteger(String.valueOf(qValue)));
                        if (!((Boolean)modularGCDresult.get(0)).booleanValue()) {
                            boolean gcdEqualsU;
                            int gPolynomialDegree = (Integer)modularGCDresult.get(1);
                            BigInteger[] gPolynomial = (BigInteger[])modularGCDresult.get(2);
                            if (gPolynomialDegree == uPolynomialDegree) {
                                gcdEqualsU = true;
                                int gcdIndex = 0;
                                while (gcdIndex <= gPolynomialDegree & gcdEqualsU) {
                                    if (gPolynomial[gcdIndex].compareTo(uPolynomial[gcdIndex]) != 0) {
                                        gcdEqualsU = false;
                                        continue;
                                    }
                                    ++gcdIndex;
                                }
                            } else {
                                gcdEqualsU = false;
                            }
                            if (!(gPolynomialDegree == 0 && gPolynomial[0].compareTo(BigInteger.ONE) == 0 || gcdEqualsU)) {
                                halt = true;
                                factors.remove(factorIndex);
                                factors.remove(factorIndex);
                                List polynomialDivisionOverFiniteFieldResult = UnivariateFactorizationOverZ.polynomialDivisionOverFiniteField(uPolynomial, gPolynomial, uPolynomialDegree, gPolynomialDegree, new BigInteger(String.valueOf(qValue)));
                                uPolynomialDegree = (Integer)polynomialDivisionOverFiniteFieldResult.get(1);
                                uPolynomial = (BigInteger[])polynomialDivisionOverFiniteFieldResult.get(3);
                                factors.add(factorIndex, gPolynomial);
                                factors.add(factorIndex, gPolynomialDegree);
                                factors.add(factorIndex, uPolynomial);
                                factors.add(factorIndex, uPolynomialDegree);
                            } else {
                                ++sValue;
                            }
                            vVector[0] = originalElement;
                            continue;
                        }
                        ++sValue;
                    }
                    if (halt) continue;
                    ++rIndex;
                }
                if (rIndex <= kValue - 1) continue;
                factorIndex += 2;
            }
        } else {
            factors.add(aPolynomialDegree);
            factors.add(aPolynomial);
        }
        return factors;
    }

    public static List henselStep(BigInteger[] fPolynomial, BigInteger[] gPolynomial, BigInteger[] hPolynomial, BigInteger[] sPolynomial, BigInteger[] tPolynomial, int fPolynomialDegree, int gPolynomialDegree, int hPolynomialDegree, int sPolynomialDegree, int tPolynomialDegree, BigInteger mValue) {
        BigInteger[] unityPolynomial = new BigInteger[1];
        int unityPolynomialDegree = 0;
        ArrayList<Object> result = new ArrayList<Object>(4);
        unityPolynomial[0] = BigInteger.ONE;
        List polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(gPolynomial, hPolynomial, gPolynomialDegree, hPolynomialDegree, mValue.pow(2), '*');
        int ghPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] ghPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(fPolynomial, ghPolynomial, fPolynomialDegree, ghPolynomialDegree, mValue.pow(2), '-');
        int ePolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] ePolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(sPolynomial, ePolynomial, sPolynomialDegree, ePolynomialDegree, mValue.pow(2), '*');
        int sePolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] sePolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        List polynomialDivisionOverFiniteFieldResult = UnivariateFactorizationOverZ.polynomialDivisionOverFiniteField(sePolynomial, hPolynomial, sePolynomialDegree, hPolynomialDegree, mValue.pow(2));
        int qPolynomialDegree = (Integer)polynomialDivisionOverFiniteFieldResult.get(1);
        BigInteger[] qPolynomial = (BigInteger[])polynomialDivisionOverFiniteFieldResult.get(3);
        int rPolynomialDegree = (Integer)polynomialDivisionOverFiniteFieldResult.get(2);
        BigInteger[] rPolynomial = (BigInteger[])polynomialDivisionOverFiniteFieldResult.get(4);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(tPolynomial, ePolynomial, tPolynomialDegree, ePolynomialDegree, mValue.pow(2), '*');
        int tePolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] tePolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(qPolynomial, gPolynomial, qPolynomialDegree, gPolynomialDegree, mValue.pow(2), '*');
        int qgPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] qgPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(gPolynomial, tePolynomial, gPolynomialDegree, tePolynomialDegree, mValue.pow(2), '+');
        int dummyPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] dummyPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(dummyPolynomial, qgPolynomial, dummyPolynomialDegree, qgPolynomialDegree, mValue.pow(2), '+');
        int gStarPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] gStarPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(hPolynomial, rPolynomial, hPolynomialDegree, rPolynomialDegree, mValue.pow(2), '+');
        int hStarPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] hStarPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(sPolynomial, gStarPolynomial, sPolynomialDegree, gStarPolynomialDegree, mValue.pow(2), '*');
        int sgStarPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] sgStarPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(tPolynomial, hStarPolynomial, tPolynomialDegree, hStarPolynomialDegree, mValue.pow(2), '*');
        int thStarPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] thStarPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(sgStarPolynomial, thStarPolynomial, sgStarPolynomialDegree, thStarPolynomialDegree, mValue.pow(2), '+');
        dummyPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        dummyPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(dummyPolynomial, unityPolynomial, dummyPolynomialDegree, unityPolynomialDegree, mValue.pow(2), '-');
        int bPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] bPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(sPolynomial, bPolynomial, sPolynomialDegree, bPolynomialDegree, mValue.pow(2), '*');
        int sbPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] sbPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialDivisionOverFiniteFieldResult = UnivariateFactorizationOverZ.polynomialDivisionOverFiniteField(sbPolynomial, hStarPolynomial, sbPolynomialDegree, hStarPolynomialDegree, mValue.pow(2));
        int cPolynomialDegree = (Integer)polynomialDivisionOverFiniteFieldResult.get(1);
        BigInteger[] cPolynomial = (BigInteger[])polynomialDivisionOverFiniteFieldResult.get(3);
        int dPolynomialDegree = (Integer)polynomialDivisionOverFiniteFieldResult.get(2);
        BigInteger[] dPolynomial = (BigInteger[])polynomialDivisionOverFiniteFieldResult.get(4);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(sPolynomial, dPolynomial, sPolynomialDegree, dPolynomialDegree, mValue.pow(2), '-');
        int sStarPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] sStarPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(tPolynomial, bPolynomial, tPolynomialDegree, bPolynomialDegree, mValue.pow(2), '*');
        int tbPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] tbPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(cPolynomial, gStarPolynomial, cPolynomialDegree, gStarPolynomialDegree, mValue.pow(2), '*');
        int cgStarPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] cgStarPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(tPolynomial, tbPolynomial, tPolynomialDegree, tbPolynomialDegree, mValue.pow(2), '-');
        dummyPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        dummyPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(dummyPolynomial, cgStarPolynomial, dummyPolynomialDegree, cgStarPolynomialDegree, mValue.pow(2), '-');
        int tStarPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
        BigInteger[] tStarPolynomial = (BigInteger[])polynomialArithmeticModularResult.get(1);
        result.add(gStarPolynomialDegree);
        result.add(gStarPolynomial);
        result.add(hStarPolynomialDegree);
        result.add(hStarPolynomial);
        result.add(sStarPolynomialDegree);
        result.add(sStarPolynomial);
        result.add(tStarPolynomialDegree);
        result.add(tStarPolynomial);
        return result;
    }

    public static List extendedEuclideanAlgorithmModular(BigInteger[] polynomialA, BigInteger[] polynomialB, int degreeA, int degreeB, BigInteger qValue) {
        boolean error;
        int dummyDegree;
        BigInteger[] dummy;
        BigInteger[] bezoutX = new BigInteger[]{};
        BigInteger[] bezoutY = new BigInteger[]{};
        BigInteger[] gcd = new BigInteger[]{};
        int degreeOne = degreeA;
        int degreeTwo = degreeB;
        int gcdDegree = 0;
        int bezoutXdegree = 0;
        int bezoutYdegree = 0;
        boolean interchange = false;
        ArrayList<Object> result = new ArrayList<Object>(4);
        BigInteger[] polynomialOne = new BigInteger[degreeOne + 1];
        int index = 0;
        while (index <= degreeOne) {
            polynomialOne[index] = polynomialA[index];
            ++index;
        }
        BigInteger[] polynomialTwo = new BigInteger[degreeTwo + 1];
        index = 0;
        while (index <= degreeTwo) {
            polynomialTwo[index] = polynomialB[index];
            ++index;
        }
        if (degreeOne < degreeTwo) {
            interchange = true;
            dummy = new BigInteger[degreeOne + 1];
            index = 0;
            while (index <= degreeOne) {
                dummy[index] = polynomialOne[index];
                ++index;
            }
            polynomialOne = new BigInteger[degreeTwo + 1];
            index = 0;
            while (index <= degreeTwo) {
                polynomialOne[index] = polynomialTwo[index];
                ++index;
            }
            polynomialTwo = new BigInteger[degreeOne + 1];
            index = 0;
            while (index <= degreeOne) {
                polynomialTwo[index] = dummy[index];
                ++index;
            }
            dummyDegree = degreeOne;
            degreeOne = degreeTwo;
            degreeTwo = dummyDegree;
        }
        index = 0;
        while (index <= degreeOne) {
            if (polynomialOne[index].abs().compareTo(qValue) != -1) {
                polynomialOne[index] = polynomialOne[index].divideAndRemainder(qValue)[1];
            }
            if (polynomialOne[index].compareTo(BigInteger.ZERO) == -1) {
                polynomialOne[index] = polynomialOne[index].add(qValue);
            }
            ++index;
        }
        index = 0;
        while (index <= degreeTwo) {
            if (polynomialTwo[index].abs().compareTo(qValue) != -1) {
                polynomialTwo[index] = polynomialTwo[index].divideAndRemainder(qValue)[1];
            }
            if (polynomialTwo[index].compareTo(BigInteger.ZERO) == -1) {
                polynomialTwo[index] = polynomialTwo[index].add(qValue);
            }
            ++index;
        }
        boolean halt = false;
        while (!halt & degreeOne > 0) {
            if (polynomialOne[degreeOne].compareTo(BigInteger.ZERO) != 0) {
                halt = true;
                continue;
            }
            --degreeOne;
        }
        halt = false;
        while (!halt & degreeTwo > 0) {
            if (polynomialTwo[degreeTwo].compareTo(BigInteger.ZERO) != 0) {
                halt = true;
                continue;
            }
            --degreeTwo;
        }
        if (!(degreeOne == 0 && polynomialOne[degreeOne].compareTo(BigInteger.ZERO) == 0 || degreeTwo == 0 && polynomialTwo[degreeTwo].compareTo(BigInteger.ZERO) == 0)) {
            error = false;
            bezoutXdegree = 0;
            bezoutX = new BigInteger[bezoutXdegree + 1];
            bezoutX[0] = BigInteger.ONE;
            bezoutYdegree = 0;
            bezoutY = new BigInteger[bezoutYdegree + 1];
            bezoutY[0] = BigInteger.ZERO;
            int xPolynomialDegree = 0;
            BigInteger[] xPolynomial = new BigInteger[xPolynomialDegree + 1];
            xPolynomial[0] = BigInteger.ZERO;
            int yPolynomialDegree = 0;
            BigInteger[] yPolynomial = new BigInteger[yPolynomialDegree + 1];
            yPolynomial[0] = BigInteger.ONE;
            boolean loopHalt = false;
            while (!loopHalt) {
                List polynomialDivisionOverFiniteFieldResult = UnivariateFactorizationOverZ.polynomialDivisionOverFiniteField(polynomialOne, polynomialTwo, degreeOne, degreeTwo, qValue);
                int quotientDegree = (Integer)polynomialDivisionOverFiniteFieldResult.get(1);
                BigInteger[] quotient = new BigInteger[quotientDegree + 1];
                index = 0;
                while (index <= quotientDegree) {
                    quotient[index] = ((BigInteger[])polynomialDivisionOverFiniteFieldResult.get(3))[index];
                    ++index;
                }
                int tempPolynomialDegree = xPolynomialDegree;
                BigInteger[] tempPolynomial = new BigInteger[tempPolynomialDegree + 1];
                index = 0;
                while (index <= tempPolynomialDegree) {
                    tempPolynomial[index] = xPolynomial[index];
                    ++index;
                }
                List polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(quotient, xPolynomial, quotientDegree, xPolynomialDegree, qValue, '*');
                int productDegree = (Integer)polynomialArithmeticModularResult.get(0);
                BigInteger[] product = new BigInteger[productDegree + 1];
                index = 0;
                while (index <= productDegree) {
                    product[index] = ((BigInteger[])polynomialArithmeticModularResult.get(1))[index];
                    ++index;
                }
                polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(bezoutX, product, bezoutXdegree, productDegree, qValue, '-');
                xPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
                xPolynomial = new BigInteger[xPolynomialDegree + 1];
                index = 0;
                while (index <= xPolynomialDegree) {
                    xPolynomial[index] = ((BigInteger[])polynomialArithmeticModularResult.get(1))[index];
                    ++index;
                }
                bezoutXdegree = tempPolynomialDegree;
                bezoutX = new BigInteger[bezoutXdegree + 1];
                index = 0;
                while (index <= bezoutXdegree) {
                    bezoutX[index] = tempPolynomial[index];
                    ++index;
                }
                tempPolynomialDegree = yPolynomialDegree;
                tempPolynomial = new BigInteger[tempPolynomialDegree + 1];
                index = 0;
                while (index <= tempPolynomialDegree) {
                    tempPolynomial[index] = yPolynomial[index];
                    ++index;
                }
                polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(quotient, yPolynomial, quotientDegree, yPolynomialDegree, qValue, '*');
                productDegree = (Integer)polynomialArithmeticModularResult.get(0);
                product = new BigInteger[productDegree + 1];
                index = 0;
                while (index <= productDegree) {
                    product[index] = ((BigInteger[])polynomialArithmeticModularResult.get(1))[index];
                    ++index;
                }
                polynomialArithmeticModularResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(bezoutY, product, bezoutYdegree, productDegree, qValue, '-');
                yPolynomialDegree = (Integer)polynomialArithmeticModularResult.get(0);
                yPolynomial = new BigInteger[yPolynomialDegree + 1];
                index = 0;
                while (index <= yPolynomialDegree) {
                    yPolynomial[index] = ((BigInteger[])polynomialArithmeticModularResult.get(1))[index];
                    ++index;
                }
                bezoutYdegree = tempPolynomialDegree;
                bezoutY = new BigInteger[bezoutYdegree + 1];
                index = 0;
                while (index <= bezoutYdegree) {
                    bezoutY[index] = tempPolynomial[index];
                    ++index;
                }
                if ((Integer)polynomialDivisionOverFiniteFieldResult.get(2) == 0 && ((BigInteger[])polynomialDivisionOverFiniteFieldResult.get(4))[0].compareTo(BigInteger.ZERO) == 0) {
                    loopHalt = true;
                    gcdDegree = degreeTwo;
                    gcd = new BigInteger[gcdDegree + 1];
                    index = 0;
                    while (index <= gcdDegree) {
                        gcd[index] = polynomialTwo[index];
                        ++index;
                    }
                    continue;
                }
                degreeOne = degreeTwo;
                polynomialOne = new BigInteger[degreeOne + 1];
                index = 0;
                while (index <= degreeTwo) {
                    polynomialOne[index] = polynomialTwo[index];
                    ++index;
                }
                degreeTwo = (Integer)polynomialDivisionOverFiniteFieldResult.get(2);
                polynomialTwo = new BigInteger[degreeTwo + 1];
                index = 0;
                while (index <= degreeTwo) {
                    polynomialTwo[index] = ((BigInteger[])polynomialDivisionOverFiniteFieldResult.get(4))[index];
                    ++index;
                }
            }
            if (interchange) {
                dummy = new BigInteger[bezoutXdegree + 1];
                index = 0;
                while (index <= bezoutXdegree) {
                    dummy[index] = bezoutX[index];
                    ++index;
                }
                bezoutX = new BigInteger[bezoutYdegree + 1];
                index = 0;
                while (index <= bezoutYdegree) {
                    bezoutX[index] = bezoutY[index];
                    ++index;
                }
                bezoutY = new BigInteger[bezoutXdegree + 1];
                index = 0;
                while (index <= bezoutXdegree) {
                    bezoutY[index] = dummy[index];
                    ++index;
                }
                dummyDegree = bezoutXdegree;
                bezoutXdegree = bezoutYdegree;
                bezoutYdegree = dummyDegree;
            }
            List inverseElementResult = UnivariateFactorizationOverZ.multiplicativeInverse(gcd[gcdDegree], qValue);
            BigInteger inverseElement = (BigInteger)inverseElementResult.get(1);
            index = 0;
            while (index <= gcdDegree) {
                gcd[index] = inverseElement.multiply(gcd[index]);
                if (gcd[index].abs().compareTo(qValue) != -1) {
                    gcd[index] = gcd[index].divideAndRemainder(qValue)[1];
                }
                if (gcd[index].compareTo(BigInteger.ZERO) == -1) {
                    gcd[index] = gcd[index].add(qValue);
                }
                ++index;
            }
            index = 0;
            while (index <= bezoutXdegree) {
                bezoutX[index] = inverseElement.multiply(bezoutX[index]);
                if (bezoutX[index].abs().compareTo(qValue) != -1) {
                    bezoutX[index] = bezoutX[index].divideAndRemainder(qValue)[1];
                }
                if (bezoutX[index].compareTo(BigInteger.ZERO) == -1) {
                    bezoutX[index] = bezoutX[index].add(qValue);
                }
                ++index;
            }
            index = 0;
            while (index <= bezoutYdegree) {
                bezoutY[index] = inverseElement.multiply(bezoutY[index]);
                if (bezoutY[index].abs().compareTo(qValue) != -1) {
                    bezoutY[index] = bezoutY[index].divideAndRemainder(qValue)[1];
                }
                if (bezoutY[index].compareTo(BigInteger.ZERO) == -1) {
                    bezoutY[index] = bezoutY[index].add(qValue);
                }
                ++index;
            }
        } else {
            error = true;
        }
        result.add(error);
        result.add(gcdDegree);
        result.add(gcd);
        result.add(bezoutXdegree);
        result.add(bezoutX);
        result.add(bezoutYdegree);
        result.add(bezoutY);
        return result;
    }

    public static List univariatePolynomialGCD(BigInteger[][][] polynomialOne, BigInteger[][][] polynomialTwo, int degreeOne, int degreeTwo, int workingDecimalPlaceNumber) {
        List complexGCDResult;
        int index;
        BigInteger[][][] polynomialGCD = new BigInteger[][][]{};
        BigInteger[][] dummyValue = new BigInteger[3][3];
        BigInteger[] complexContent = new BigInteger[3];
        BigInteger[] complexMultiplier = new BigInteger[3];
        BigInteger[] complexContentPolynomialOne = new BigInteger[3];
        BigInteger[] complexContentPolynomialTwo = new BigInteger[3];
        BigInteger[] numberOne = new BigInteger[3];
        BigInteger[] numberTwo = new BigInteger[3];
        BigDecimal[] divisionResult = new BigDecimal[3];
        BigInteger realContent = BigInteger.ONE;
        BigInteger realContentPolynomialOne = BigInteger.ONE;
        BigInteger realContentPolynomialTwo = BigInteger.ONE;
        BigInteger realMultiplier = BigInteger.ONE;
        int GCDdegree = 0;
        boolean isOverZi = false;
        ArrayList<Object> result = new ArrayList<Object>(2);
        if (degreeOne < degreeTwo) {
            BigInteger[][][] dummy = new BigInteger[degreeOne + 1][3][3];
            index = 0;
            while (index <= degreeOne) {
                dummy[index][1][1] = polynomialOne[index][1][1];
                dummy[index][1][2] = polynomialOne[index][1][2];
                dummy[index][2][1] = polynomialOne[index][2][1];
                dummy[index][2][2] = polynomialOne[index][2][2];
                ++index;
            }
            polynomialOne = new BigInteger[degreeTwo + 1][3][3];
            index = 0;
            while (index <= degreeTwo) {
                polynomialOne[index][1][1] = polynomialTwo[index][1][1];
                polynomialOne[index][1][2] = polynomialTwo[index][1][2];
                polynomialOne[index][2][1] = polynomialTwo[index][2][1];
                polynomialOne[index][2][2] = polynomialTwo[index][2][2];
                ++index;
            }
            polynomialTwo = new BigInteger[degreeOne + 1][3][3];
            index = 0;
            while (index <= degreeOne) {
                polynomialTwo[index][1][1] = dummy[index][1][1];
                polynomialTwo[index][1][2] = dummy[index][1][2];
                polynomialTwo[index][2][1] = dummy[index][2][1];
                polynomialTwo[index][2][2] = dummy[index][2][2];
                ++index;
            }
            int dummyDegree = degreeOne;
            degreeOne = degreeTwo;
            degreeTwo = dummyDegree;
        }
        BigInteger[] denominatorArray = new BigInteger[2 * (degreeOne + 1)];
        int runIndex = 0;
        index = 0;
        while (index <= degreeOne) {
            denominatorArray[runIndex] = polynomialOne[index][1][2];
            denominatorArray[++runIndex] = polynomialOne[index][2][2];
            ++runIndex;
            ++index;
        }
        List lcmResult = UnivariateFactorizationOverZ.lcm(denominatorArray[0], denominatorArray[1]);
        BigInteger realLCM = (BigInteger)lcmResult.get(1);
        index = 2;
        while (index <= runIndex - 1) {
            lcmResult = UnivariateFactorizationOverZ.lcm(realLCM, denominatorArray[index]);
            realLCM = (BigInteger)lcmResult.get(1);
            ++index;
        }
        BigInteger polynomialOneConstant = realLCM;
        index = 0;
        while (index <= degreeOne) {
            polynomialOne[index][1][1] = polynomialOne[index][1][1].multiply(realLCM);
            realContent = polynomialOne[index][1][1].gcd(polynomialOne[index][1][2]);
            polynomialOne[index][1][1] = polynomialOne[index][1][1].divide(realContent);
            polynomialOne[index][1][2] = polynomialOne[index][1][2].divide(realContent);
            polynomialOne[index][2][1] = polynomialOne[index][2][1].multiply(realLCM);
            realContent = polynomialOne[index][2][1].gcd(polynomialOne[index][2][2]);
            polynomialOne[index][2][1] = polynomialOne[index][2][1].divide(realContent);
            polynomialOne[index][2][2] = polynomialOne[index][2][2].divide(realContent);
            ++index;
        }
        denominatorArray = new BigInteger[2 * (degreeTwo + 1)];
        runIndex = 0;
        index = 0;
        while (index <= degreeTwo) {
            denominatorArray[runIndex] = polynomialTwo[index][1][2];
            denominatorArray[++runIndex] = polynomialTwo[index][2][2];
            ++runIndex;
            ++index;
        }
        lcmResult = UnivariateFactorizationOverZ.lcm(denominatorArray[0], denominatorArray[1]);
        realLCM = (BigInteger)lcmResult.get(1);
        index = 2;
        while (index <= runIndex - 1) {
            lcmResult = UnivariateFactorizationOverZ.lcm(realLCM, denominatorArray[index]);
            realLCM = (BigInteger)lcmResult.get(1);
            ++index;
        }
        BigInteger polynomialTwoConstant = realLCM;
        BigInteger divisorConstant = polynomialOneConstant.gcd(polynomialTwoConstant);
        index = 0;
        while (index <= degreeTwo) {
            polynomialTwo[index][1][1] = polynomialTwo[index][1][1].multiply(realLCM);
            realContent = polynomialTwo[index][1][1].gcd(polynomialTwo[index][1][2]);
            polynomialTwo[index][1][1] = polynomialTwo[index][1][1].divide(realContent);
            polynomialTwo[index][1][2] = polynomialTwo[index][1][2].divide(realContent);
            polynomialTwo[index][2][1] = polynomialTwo[index][2][1].multiply(realLCM);
            realContent = polynomialTwo[index][2][1].gcd(polynomialTwo[index][2][2]);
            polynomialTwo[index][2][1] = polynomialTwo[index][2][1].divide(realContent);
            polynomialTwo[index][2][2] = polynomialTwo[index][2][2].divide(realContent);
            ++index;
        }
        index = 0;
        boolean polynomialOneComplex = false;
        while (!polynomialOneComplex & index <= degreeOne) {
            if (polynomialOne[index][2][1].compareTo(BigInteger.ZERO) == 0) {
                ++index;
                continue;
            }
            polynomialOneComplex = true;
        }
        index = 0;
        boolean polynomialTwoComplex = false;
        while (!polynomialTwoComplex & index <= degreeTwo) {
            if (polynomialTwo[index][2][1].compareTo(BigInteger.ZERO) == 0) {
                ++index;
                continue;
            }
            polynomialTwoComplex = true;
        }
        isOverZi = polynomialOneComplex | polynomialTwoComplex;
        if (polynomialOneComplex) {
            if (degreeOne > 0) {
                numberOne[1] = polynomialOne[degreeOne][1][1];
                numberOne[2] = polynomialOne[degreeOne][2][1];
                numberTwo[1] = polynomialOne[degreeOne - 1][1][1];
                numberTwo[2] = polynomialOne[degreeOne - 1][2][1];
                complexGCDResult = UnivariateFactorizationOverZ.complexExtendedEuclideanAlgorithm(numberOne, numberTwo, workingDecimalPlaceNumber);
                complexContentPolynomialOne[1] = ((BigInteger[])complexGCDResult.get(0))[1];
                complexContentPolynomialOne[2] = ((BigInteger[])complexGCDResult.get(0))[2];
                index = degreeOne - 2;
                while (index >= 0) {
                    numberOne[1] = complexContentPolynomialOne[1];
                    numberOne[2] = complexContentPolynomialOne[2];
                    numberTwo[1] = polynomialOne[index][1][1];
                    numberTwo[2] = polynomialOne[index][2][1];
                    complexGCDResult = UnivariateFactorizationOverZ.complexExtendedEuclideanAlgorithm(numberOne, numberTwo, workingDecimalPlaceNumber);
                    complexContentPolynomialOne[1] = ((BigInteger[])complexGCDResult.get(0))[1];
                    complexContentPolynomialOne[2] = ((BigInteger[])complexGCDResult.get(0))[2];
                    --index;
                }
            } else {
                complexContentPolynomialOne[1] = polynomialTwo[degreeOne][1][1];
                complexContentPolynomialOne[2] = polynomialTwo[degreeOne][2][1];
            }
            index = degreeOne;
            while (index >= 0) {
                divisionResult = UnivariateFactorizationOverZ.complexArithmetic(new BigDecimal(polynomialOne[index][1][1]), new BigDecimal(polynomialOne[index][2][1]), new BigDecimal(complexContentPolynomialOne[1]), new BigDecimal(complexContentPolynomialOne[2]), '/', workingDecimalPlaceNumber);
                polynomialOne[index][1][1] = divisionResult[1].toBigInteger();
                polynomialOne[index][2][1] = divisionResult[2].toBigInteger();
                --index;
            }
        } else {
            if (degreeOne > 0) {
                realContentPolynomialOne = polynomialOne[degreeOne][1][1].gcd(polynomialOne[degreeOne - 1][1][1]);
                index = degreeOne - 2;
                while (index >= 0) {
                    realContentPolynomialOne = realContentPolynomialOne.gcd(polynomialOne[index][1][1]);
                    --index;
                }
                if (polynomialOne[degreeOne][1][1].compareTo(BigInteger.ZERO) == -1) {
                    realContentPolynomialOne = realContentPolynomialOne.negate();
                }
            } else {
                realContentPolynomialOne = polynomialOne[degreeOne][1][1];
            }
            index = degreeOne;
            while (index >= 0) {
                polynomialOne[index][1][1] = polynomialOne[index][1][1].divide(realContentPolynomialOne);
                --index;
            }
        }
        if (polynomialTwoComplex) {
            if (degreeTwo > 0) {
                numberOne[1] = polynomialTwo[degreeTwo][1][1];
                numberOne[2] = polynomialTwo[degreeTwo][2][1];
                numberTwo[1] = polynomialTwo[degreeTwo - 1][1][1];
                numberTwo[2] = polynomialTwo[degreeTwo - 1][2][1];
                complexGCDResult = UnivariateFactorizationOverZ.complexExtendedEuclideanAlgorithm(numberOne, numberTwo, workingDecimalPlaceNumber);
                complexContentPolynomialTwo[1] = ((BigInteger[])complexGCDResult.get(0))[1];
                complexContentPolynomialTwo[2] = ((BigInteger[])complexGCDResult.get(0))[2];
                index = degreeTwo - 2;
                while (index >= 0) {
                    numberOne[1] = complexContentPolynomialTwo[1];
                    numberOne[2] = complexContentPolynomialTwo[2];
                    numberTwo[1] = polynomialTwo[index][1][1];
                    numberTwo[2] = polynomialTwo[index][2][1];
                    complexGCDResult = UnivariateFactorizationOverZ.complexExtendedEuclideanAlgorithm(numberOne, numberTwo, workingDecimalPlaceNumber);
                    complexContentPolynomialTwo[1] = ((BigInteger[])complexGCDResult.get(0))[1];
                    complexContentPolynomialTwo[2] = ((BigInteger[])complexGCDResult.get(0))[2];
                    --index;
                }
            } else {
                complexContentPolynomialTwo[1] = polynomialTwo[degreeTwo][1][1];
                complexContentPolynomialTwo[2] = polynomialTwo[degreeTwo][2][1];
            }
            index = degreeTwo;
            while (index >= 0) {
                divisionResult = UnivariateFactorizationOverZ.complexArithmetic(new BigDecimal(polynomialTwo[index][1][1]), new BigDecimal(polynomialTwo[index][2][1]), new BigDecimal(complexContentPolynomialTwo[1]), new BigDecimal(complexContentPolynomialTwo[2]), '/', workingDecimalPlaceNumber);
                polynomialTwo[index][1][1] = divisionResult[1].toBigInteger();
                polynomialTwo[index][2][1] = divisionResult[2].toBigInteger();
                --index;
            }
        } else {
            if (degreeTwo > 0) {
                realContentPolynomialTwo = polynomialTwo[degreeTwo][1][1].gcd(polynomialTwo[degreeTwo - 1][1][1]);
                index = degreeTwo - 2;
                while (index >= 0) {
                    realContentPolynomialTwo = realContentPolynomialTwo.gcd(polynomialTwo[index][1][1]);
                    --index;
                }
                if (polynomialTwo[degreeTwo][1][1].compareTo(BigInteger.ZERO) == -1) {
                    realContentPolynomialTwo = realContentPolynomialTwo.negate();
                }
            } else {
                realContentPolynomialTwo = polynomialTwo[degreeTwo][1][1];
            }
            index = degreeTwo;
            while (index >= 0) {
                polynomialTwo[index][1][1] = polynomialTwo[index][1][1].divide(realContentPolynomialTwo);
                --index;
            }
        }
        if (!polynomialTwoComplex & !polynomialTwoComplex) {
            realMultiplier = realContentPolynomialOne.gcd(realContentPolynomialTwo);
        } else {
            numberOne[1] = complexContentPolynomialOne[1];
            numberOne[2] = complexContentPolynomialOne[2];
            numberTwo[1] = complexContentPolynomialTwo[1];
            numberTwo[2] = complexContentPolynomialTwo[2];
            complexGCDResult = UnivariateFactorizationOverZ.complexExtendedEuclideanAlgorithm(numberOne, numberTwo, workingDecimalPlaceNumber);
            complexMultiplier[1] = ((BigInteger[])complexGCDResult.get(0))[1];
            complexMultiplier[2] = ((BigInteger[])complexGCDResult.get(0))[2];
        }
        boolean halt = false;
        while (!halt) {
            List polynomialDivisionResult = UnivariateFactorizationOverZ.polynomialDivision(polynomialOne, polynomialTwo, degreeOne, degreeTwo);
            if ((Integer)polynomialDivisionResult.get(1) == 0 && ((BigInteger[][][])polynomialDivisionResult.get(3))[0][1][1].compareTo(BigInteger.ZERO) == 0 && ((BigInteger[][][])polynomialDivisionResult.get(3))[0][2][1].compareTo(BigInteger.ZERO) == 0) {
                halt = true;
                GCDdegree = degreeTwo;
                polynomialGCD = new BigInteger[GCDdegree + 1][3][3];
                index = 0;
                while (index <= GCDdegree) {
                    polynomialGCD[index][1][1] = polynomialTwo[index][1][1];
                    polynomialGCD[index][1][2] = polynomialTwo[index][1][2];
                    polynomialGCD[index][2][1] = polynomialTwo[index][2][1];
                    polynomialGCD[index][2][2] = polynomialTwo[index][2][2];
                    ++index;
                }
                continue;
            }
            degreeOne = degreeTwo;
            polynomialOne = new BigInteger[degreeOne + 1][3][3];
            index = 0;
            while (index <= degreeTwo) {
                polynomialOne[index][1][1] = polynomialTwo[index][1][1];
                polynomialOne[index][1][2] = polynomialTwo[index][1][2];
                polynomialOne[index][2][1] = polynomialTwo[index][2][1];
                polynomialOne[index][2][2] = polynomialTwo[index][2][2];
                ++index;
            }
            degreeTwo = (Integer)polynomialDivisionResult.get(1);
            polynomialTwo = new BigInteger[degreeTwo + 1][3][3];
            index = 0;
            while (index <= degreeTwo) {
                polynomialTwo[index][1][1] = ((BigInteger[][][])polynomialDivisionResult.get(6))[index][1][1];
                polynomialTwo[index][1][2] = ((BigInteger[][][])polynomialDivisionResult.get(6))[index][1][2];
                polynomialTwo[index][2][1] = ((BigInteger[][][])polynomialDivisionResult.get(6))[index][2][1];
                polynomialTwo[index][2][2] = ((BigInteger[][][])polynomialDivisionResult.get(6))[index][2][2];
                ++index;
            }
            if (isOverZi) {
                if (degreeTwo > 0) {
                    numberOne[1] = polynomialTwo[degreeTwo][1][1];
                    numberOne[2] = polynomialTwo[degreeTwo][2][1];
                    numberTwo[1] = polynomialTwo[degreeTwo - 1][1][1];
                    numberTwo[2] = polynomialTwo[degreeTwo - 1][2][1];
                    complexGCDResult = UnivariateFactorizationOverZ.complexExtendedEuclideanAlgorithm(numberOne, numberTwo, workingDecimalPlaceNumber);
                    complexContent[1] = ((BigInteger[])complexGCDResult.get(0))[1];
                    complexContent[2] = ((BigInteger[])complexGCDResult.get(0))[2];
                    index = degreeTwo - 2;
                    while (index >= 0) {
                        numberOne[1] = complexContent[1];
                        numberOne[2] = complexContent[2];
                        numberTwo[1] = polynomialTwo[index][1][1];
                        numberTwo[2] = polynomialTwo[index][2][1];
                        complexGCDResult = UnivariateFactorizationOverZ.complexExtendedEuclideanAlgorithm(numberOne, numberTwo, workingDecimalPlaceNumber);
                        complexContent[1] = ((BigInteger[])complexGCDResult.get(0))[1];
                        complexContent[2] = ((BigInteger[])complexGCDResult.get(0))[2];
                        --index;
                    }
                } else {
                    complexContent[1] = polynomialTwo[degreeTwo][1][1];
                    complexContent[2] = polynomialTwo[degreeTwo][2][1];
                }
                index = degreeTwo;
                while (index >= 0) {
                    divisionResult = UnivariateFactorizationOverZ.complexArithmetic(new BigDecimal(polynomialTwo[index][1][1]), new BigDecimal(polynomialTwo[index][2][1]), new BigDecimal(complexContent[1]), new BigDecimal(complexContent[2]), '/', workingDecimalPlaceNumber);
                    polynomialTwo[index][1][1] = divisionResult[1].toBigInteger();
                    polynomialTwo[index][2][1] = divisionResult[2].toBigInteger();
                    --index;
                }
                continue;
            }
            if (degreeTwo > 0) {
                realContent = polynomialTwo[degreeTwo][1][1].gcd(polynomialTwo[degreeTwo - 1][1][1]);
                index = degreeTwo - 2;
                while (index >= 0) {
                    realContent = realContent.gcd(polynomialTwo[index][1][1]);
                    --index;
                }
                if (polynomialTwo[degreeTwo][1][1].compareTo(BigInteger.ZERO) == -1) {
                    realContent = realContent.negate();
                }
            } else {
                realContent = polynomialTwo[degreeTwo][1][1];
            }
            index = degreeTwo;
            while (index >= 0) {
                polynomialTwo[index][1][1] = polynomialTwo[index][1][1].divide(realContent);
                --index;
            }
        }
        if (!polynomialTwoComplex & !polynomialTwoComplex) {
            index = GCDdegree;
            while (index >= 0) {
                polynomialGCD[index][1][1] = polynomialGCD[index][1][1].multiply(realMultiplier);
                --index;
            }
        } else {
            dummyValue[1][1] = complexMultiplier[1];
            dummyValue[1][2] = BigInteger.ONE;
            dummyValue[2][1] = complexMultiplier[2];
            dummyValue[2][2] = BigInteger.ONE;
            index = GCDdegree;
            while (index >= 0) {
                polynomialGCD[index] = UnivariateFactorizationOverZ.fractionalComplexArithmetic(dummyValue, polynomialGCD[index], '*');
                --index;
            }
        }
        index = 0;
        while (index <= GCDdegree) {
            int fieldIndex = 1;
            while (fieldIndex <= 2) {
                realContent = polynomialGCD[index][fieldIndex][1].gcd(divisorConstant);
                polynomialGCD[index][fieldIndex][1] = polynomialGCD[index][fieldIndex][1].divide(realContent);
                polynomialGCD[index][fieldIndex][2] = divisorConstant.divide(realContent);
                ++fieldIndex;
            }
            ++index;
        }
        result.add(GCDdegree);
        result.add(polynomialGCD);
        return result;
    }

    public static List complexExtendedEuclideanAlgorithm(BigInteger[] numberOne, BigInteger[] numberTwo, int workingDecimalPlaceNumber) {
        BigDecimal[] gcd = new BigDecimal[3];
        BigDecimal[] mValue = new BigDecimal[3];
        BigDecimal[] nValue = new BigDecimal[3];
        BigDecimal[] dividend = new BigDecimal[3];
        BigDecimal[] divisor = new BigDecimal[3];
        BigDecimal[] tempValue = new BigDecimal[3];
        BigDecimal[] xValue = new BigDecimal[3];
        BigDecimal[] yValue = new BigDecimal[3];
        BigDecimal[] lastxValue = new BigDecimal[3];
        BigDecimal[] lastyValue = new BigDecimal[3];
        BigInteger[] gcdResult = new BigInteger[3];
        BigInteger[] mValueResult = new BigInteger[3];
        BigInteger[] nValueResult = new BigInteger[3];
        ArrayList<BigInteger[]> result = new ArrayList<BigInteger[]>(3);
        BigDecimal magnitudeOne = UnivariateFactorizationOverZ.complexMagnitude(new BigDecimal(numberOne[1]), new BigDecimal(numberOne[2]), workingDecimalPlaceNumber);
        BigDecimal magnitudeTwo = UnivariateFactorizationOverZ.complexMagnitude(new BigDecimal(numberTwo[1]), new BigDecimal(numberTwo[2]), workingDecimalPlaceNumber);
        BigDecimal magnitude = BigDecimal.ONE;
        if (magnitudeOne.compareTo(BigDecimal.ZERO) != 0 && magnitudeTwo.compareTo(BigDecimal.ZERO) != 0) {
            if (magnitudeOne.compareTo(magnitudeTwo) == 1) {
                dividend[1] = new BigDecimal(numberOne[1]);
                dividend[2] = new BigDecimal(numberOne[2]);
                divisor[1] = new BigDecimal(numberTwo[1]);
                divisor[2] = new BigDecimal(numberTwo[2]);
            } else {
                dividend[1] = new BigDecimal(numberTwo[1]);
                dividend[2] = new BigDecimal(numberTwo[2]);
                divisor[1] = new BigDecimal(numberOne[1]);
                divisor[2] = new BigDecimal(numberOne[2]);
            }
            xValue[1] = BigDecimal.ZERO;
            xValue[2] = BigDecimal.ZERO;
            lastxValue[1] = BigDecimal.ONE;
            lastxValue[2] = BigDecimal.ZERO;
            yValue[1] = BigDecimal.ONE;
            yValue[2] = BigDecimal.ZERO;
            lastyValue[1] = BigDecimal.ZERO;
            lastyValue[2] = BigDecimal.ZERO;
            while (magnitude.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal[] quotient = UnivariateFactorizationOverZ.complexArithmetic(dividend[1], dividend[2], divisor[1], divisor[2], '/', workingDecimalPlaceNumber);
                quotient[1] = quotient[1].setScale(0, 4);
                quotient[2] = quotient[2].setScale(0, 4);
                BigDecimal[] product = UnivariateFactorizationOverZ.complexArithmetic(quotient[1], quotient[2], divisor[1], divisor[2], '*', workingDecimalPlaceNumber);
                BigDecimal[] remainder = UnivariateFactorizationOverZ.complexArithmetic(dividend[1], dividend[2], product[1], product[2], '-', workingDecimalPlaceNumber);
                dividend[1] = divisor[1];
                dividend[2] = divisor[2];
                divisor[1] = remainder[1];
                divisor[2] = remainder[2];
                tempValue[1] = xValue[1];
                tempValue[2] = xValue[2];
                xValue = UnivariateFactorizationOverZ.complexArithmetic(quotient[1], quotient[2], xValue[1], xValue[2], '*', workingDecimalPlaceNumber);
                xValue = UnivariateFactorizationOverZ.complexArithmetic(lastxValue[1], lastxValue[2], xValue[1], xValue[2], '-', workingDecimalPlaceNumber);
                lastxValue[1] = tempValue[1];
                lastxValue[2] = tempValue[2];
                tempValue[1] = yValue[1];
                tempValue[2] = yValue[2];
                yValue = UnivariateFactorizationOverZ.complexArithmetic(quotient[1], quotient[2], yValue[1], yValue[2], '*', workingDecimalPlaceNumber);
                yValue = UnivariateFactorizationOverZ.complexArithmetic(lastyValue[1], lastyValue[2], yValue[1], yValue[2], '-', workingDecimalPlaceNumber);
                lastyValue[1] = tempValue[1];
                lastyValue[2] = tempValue[2];
                magnitude = UnivariateFactorizationOverZ.complexMagnitude(remainder[1], remainder[2], workingDecimalPlaceNumber);
            }
            gcd[1] = dividend[1];
            gcd[2] = dividend[2];
            mValue[1] = lastxValue[1];
            mValue[2] = lastxValue[2];
            nValue[1] = lastyValue[1];
            nValue[2] = lastyValue[2];
        } else if (new BigDecimal(numberOne[1]).compareTo(BigDecimal.ZERO) == 0 && new BigDecimal(numberOne[2]).compareTo(BigDecimal.ZERO) == 0) {
            gcd[1] = new BigDecimal(numberTwo[1]);
            gcd[2] = new BigDecimal(numberTwo[2]);
            mValue[1] = BigDecimal.ONE;
            mValue[2] = BigDecimal.ZERO;
            nValue[1] = BigDecimal.ZERO;
            nValue[2] = BigDecimal.ZERO;
        } else {
            gcd[1] = new BigDecimal(numberOne[1]);
            gcd[2] = new BigDecimal(numberOne[2]);
            mValue[1] = BigDecimal.ZERO;
            mValue[2] = BigDecimal.ZERO;
            nValue[1] = BigDecimal.ONE;
            nValue[2] = BigDecimal.ZERO;
        }
        gcdResult[1] = gcd[1].toBigInteger();
        gcdResult[2] = gcd[2].toBigInteger();
        mValueResult[1] = mValue[1].toBigInteger();
        mValueResult[2] = mValue[2].toBigInteger();
        nValueResult[1] = nValue[1].toBigInteger();
        nValueResult[2] = nValue[2].toBigInteger();
        result.add(gcdResult);
        result.add(mValueResult);
        result.add(nValueResult);
        return result;
    }

    public static BigDecimal complexMagnitude(BigDecimal realPart, BigDecimal imaginaryPart, int workingDecimalPlaceNumber) {
        BigDecimal realPartSquared = realPart.multiply(realPart);
        realPartSquared = realPartSquared.setScale(workingDecimalPlaceNumber, 4);
        BigDecimal imaginaryPartSquared = imaginaryPart.multiply(imaginaryPart);
        imaginaryPartSquared = imaginaryPartSquared.setScale(workingDecimalPlaceNumber, 4);
        BigDecimal magnitudeSquared = realPartSquared.add(imaginaryPartSquared);
        magnitudeSquared = magnitudeSquared.setScale(workingDecimalPlaceNumber, 4);
        BigDecimal result = UnivariateFactorizationOverZ.bigRoot(magnitudeSquared, 2, workingDecimalPlaceNumber);
        return result;
    }

    public static BigDecimal[] complexArithmetic(BigDecimal realPartNumberOne, BigDecimal imaginaryPartNumberOne, BigDecimal realPartNumberTwo, BigDecimal imaginaryPartNumberTwo, char sign, int workingDecimalPlaceNumber) {
        BigDecimal[] result = new BigDecimal[3];
        switch (sign) {
            case '+': {
                result[1] = realPartNumberOne.add(realPartNumberTwo);
                result[1] = result[1].setScale(workingDecimalPlaceNumber, 4);
                result[2] = imaginaryPartNumberOne.add(imaginaryPartNumberTwo);
                result[2] = result[2].setScale(workingDecimalPlaceNumber, 4);
                break;
            }
            case '-': {
                result[1] = realPartNumberOne.subtract(realPartNumberTwo);
                result[1] = result[1].setScale(workingDecimalPlaceNumber, 4);
                result[2] = imaginaryPartNumberOne.subtract(imaginaryPartNumberTwo);
                result[2] = result[2].setScale(workingDecimalPlaceNumber, 4);
                break;
            }
            case '*': {
                result[1] = realPartNumberOne.multiply(realPartNumberTwo).subtract(imaginaryPartNumberOne.multiply(imaginaryPartNumberTwo));
                result[1] = result[1].setScale(workingDecimalPlaceNumber, 4);
                result[2] = realPartNumberOne.multiply(imaginaryPartNumberTwo).add(imaginaryPartNumberOne.multiply(realPartNumberTwo));
                result[2] = result[2].setScale(workingDecimalPlaceNumber, 4);
                break;
            }
            case '/': {
                result[1] = realPartNumberOne.multiply(realPartNumberTwo).add(imaginaryPartNumberOne.multiply(imaginaryPartNumberTwo)).divide(realPartNumberTwo.multiply(realPartNumberTwo).add(imaginaryPartNumberTwo.multiply(imaginaryPartNumberTwo)), workingDecimalPlaceNumber, 4);
                result[2] = imaginaryPartNumberOne.multiply(realPartNumberTwo).subtract(realPartNumberOne.multiply(imaginaryPartNumberTwo)).divide(realPartNumberTwo.multiply(realPartNumberTwo).add(imaginaryPartNumberTwo.multiply(imaginaryPartNumberTwo)), workingDecimalPlaceNumber, 4);
            }
        }
        return result;
    }

    public static BigDecimal bigRoot(BigDecimal argument, int root, int workingDecimalPlaceNumber) {
        BigDecimal result;
        int iterationNumber = 200;
        BigDecimal constant = new BigDecimal(root);
        if (argument.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal xn;
            BigDecimal oldxn = xn = argument;
            boolean halt = false;
            int runIndex = 1;
            while (!halt & runIndex <= iterationNumber) {
                BigDecimal numerator;
                oldxn = xn;
                BigDecimal denominator = numerator = xn;
                numerator = numerator.pow(root);
                denominator = denominator.pow(root - 1);
                denominator = constant.multiply(denominator);
                numerator = numerator.subtract(argument);
                if (denominator.compareTo(BigDecimal.ZERO) == 0) {
                    halt = true;
                } else {
                    BigDecimal quotient = numerator.divide(denominator, workingDecimalPlaceNumber, 4);
                    BigDecimal xnPlusOne = xn.subtract(quotient);
                    xn = xnPlusOne = xnPlusOne.setScale(workingDecimalPlaceNumber, 4);
                    if (xnPlusOne.compareTo(oldxn) == 0) {
                        halt = true;
                    }
                }
                ++runIndex;
            }
            result = xn;
        } else {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    public static List lcm(BigInteger numberOne, BigInteger numberTwo) {
        BigInteger lcm = BigInteger.ONE;
        boolean error = false;
        ArrayList<Comparable<Boolean>> result = new ArrayList<Comparable<Boolean>>(2);
        if (numberOne.compareTo(BigInteger.ZERO) != 0 && numberTwo.compareTo(BigInteger.ZERO) != 0) {
            BigInteger gcd = numberOne.gcd(numberTwo);
            lcm = numberOne.multiply(numberTwo).divide(gcd);
        } else {
            error = true;
        }
        result.add(Boolean.valueOf(error));
        result.add(lcm);
        return result;
    }

    public static List polynomialDivision(BigInteger[][][] polynomialCoefficientsOne, BigInteger[][][] polynomialCoefficientsTwo, int degreeOne, int degreeTwo) {
        BigInteger[][][] Qcoefficients;
        int Qdegree;
        BigInteger[][][] Rcoefficients;
        int Rdegree;
        BigInteger[][] dummyValue = new BigInteger[3][3];
        BigInteger[][] bValue = new BigInteger[3][3];
        int newRdegree = 0;
        int zeroDegreeCount = 0;
        ArrayList<Object> result = new ArrayList<Object>(7);
        int delta = degreeOne - degreeTwo + 1 > 0 ? degreeOne - degreeTwo + 1 : 0;
        bValue[1][1] = BigInteger.ONE;
        bValue[1][2] = BigInteger.ONE;
        bValue[2][1] = BigInteger.ZERO;
        bValue[2][2] = BigInteger.ONE;
        int index = 1;
        while (index <= delta) {
            bValue = UnivariateFactorizationOverZ.fractionalComplexArithmetic(bValue, polynomialCoefficientsTwo[degreeTwo], '*');
            ++index;
        }
        if (degreeOne >= degreeTwo) {
            Rdegree = degreeOne;
            Rcoefficients = new BigInteger[Rdegree + 1][3][3];
            index = 0;
            while (index <= Rdegree) {
                Rcoefficients[index][1][1] = polynomialCoefficientsOne[index][1][1];
                Rcoefficients[index][1][2] = polynomialCoefficientsOne[index][1][2];
                Rcoefficients[index][2][1] = polynomialCoefficientsOne[index][2][1];
                Rcoefficients[index][2][2] = polynomialCoefficientsOne[index][2][2];
                ++index;
            }
            Qdegree = 0;
            Qcoefficients = new BigInteger[Qdegree + 1][3][3];
            Qcoefficients[0][1][1] = BigInteger.ZERO;
            Qcoefficients[0][1][2] = BigInteger.ONE;
            Qcoefficients[0][2][1] = BigInteger.ZERO;
            Qcoefficients[0][2][2] = BigInteger.ONE;
            boolean terminate = false;
            while (Rdegree >= degreeTwo & !terminate) {
                int indexTwo;
                int Gdegree = Rdegree - degreeTwo;
                BigInteger[][][] Gcoefficients = new BigInteger[Gdegree + 1][3][3];
                index = 0;
                while (index <= Gdegree) {
                    if (index < Gdegree) {
                        Gcoefficients[index][1][1] = BigInteger.ZERO;
                        Gcoefficients[index][1][2] = BigInteger.ONE;
                        Gcoefficients[index][2][1] = BigInteger.ZERO;
                        Gcoefficients[index][2][2] = BigInteger.ONE;
                    } else {
                        Gcoefficients[index] = UnivariateFactorizationOverZ.fractionalComplexArithmetic(Rcoefficients[Rdegree], polynomialCoefficientsTwo[degreeTwo], '/');
                    }
                    ++index;
                }
                int newQdegree = Qdegree <= Gdegree ? Gdegree : Qdegree;
                BigInteger[][][] polynomialOneAugmented = new BigInteger[newQdegree + 1][3][3];
                index = 0;
                while (index <= newQdegree) {
                    if (index > Qdegree) {
                        polynomialOneAugmented[index][1][1] = BigInteger.ZERO;
                        polynomialOneAugmented[index][1][2] = BigInteger.ONE;
                        polynomialOneAugmented[index][2][1] = BigInteger.ZERO;
                        polynomialOneAugmented[index][2][2] = BigInteger.ONE;
                    } else {
                        polynomialOneAugmented[index][1][1] = Qcoefficients[index][1][1];
                        polynomialOneAugmented[index][1][2] = Qcoefficients[index][1][2];
                        polynomialOneAugmented[index][2][1] = Qcoefficients[index][2][1];
                        polynomialOneAugmented[index][2][2] = Qcoefficients[index][2][2];
                    }
                    ++index;
                }
                BigInteger[][][] polynomialTwoAugmented = new BigInteger[newQdegree + 1][3][3];
                index = 0;
                while (index <= newQdegree) {
                    if (index > Gdegree) {
                        polynomialTwoAugmented[index][1][1] = BigInteger.ZERO;
                        polynomialTwoAugmented[index][1][2] = BigInteger.ONE;
                        polynomialTwoAugmented[index][2][1] = BigInteger.ZERO;
                        polynomialTwoAugmented[index][2][2] = BigInteger.ONE;
                    } else {
                        polynomialTwoAugmented[index][1][1] = Gcoefficients[index][1][1];
                        polynomialTwoAugmented[index][1][2] = Gcoefficients[index][1][2];
                        polynomialTwoAugmented[index][2][1] = Gcoefficients[index][2][1];
                        polynomialTwoAugmented[index][2][2] = Gcoefficients[index][2][2];
                    }
                    ++index;
                }
                BigInteger[][][] newQcoefficients = new BigInteger[newQdegree + 1][3][3];
                index = 0;
                while (index <= newQdegree) {
                    newQcoefficients[index] = UnivariateFactorizationOverZ.fractionalComplexArithmetic(polynomialOneAugmented[index], polynomialTwoAugmented[index], '+');
                    ++index;
                }
                index = newQdegree;
                boolean halt = false;
                while (index >= 0 & !halt) {
                    if (newQcoefficients[index][1][1].compareTo(BigInteger.ZERO) == 0 && newQcoefficients[index][2][1].compareTo(BigInteger.ZERO) == 0) {
                        --index;
                        continue;
                    }
                    halt = true;
                }
                newQdegree = halt ? index : 0;
                Qdegree = newQdegree;
                Qcoefficients = new BigInteger[Qdegree + 1][3][3];
                index = 0;
                while (index <= Qdegree) {
                    Qcoefficients[index][1][1] = newQcoefficients[index][1][1];
                    Qcoefficients[index][1][2] = newQcoefficients[index][1][2];
                    Qcoefficients[index][2][1] = newQcoefficients[index][2][1];
                    Qcoefficients[index][2][2] = newQcoefficients[index][2][2];
                    ++index;
                }
                BigInteger[][][] dummyCoefficients = new BigInteger[(Gdegree + 1) * (degreeTwo + 1) + 1][3][3];
                int[] dummyExponents = new int[(Gdegree + 1) * (degreeTwo + 1) + 1];
                index = 1;
                int indexOne = 0;
                while (indexOne <= Gdegree) {
                    indexTwo = 0;
                    while (indexTwo <= degreeTwo) {
                        dummyCoefficients[index] = UnivariateFactorizationOverZ.fractionalComplexArithmetic(Gcoefficients[indexOne], polynomialCoefficientsTwo[indexTwo], '*');
                        dummyExponents[index] = indexOne + indexTwo;
                        ++index;
                        ++indexTwo;
                    }
                    ++indexOne;
                }
                int dummyLength = index - 1;
                int exchangeNumber = 1;
                while (exchangeNumber > 0) {
                    exchangeNumber = 0;
                    index = 1;
                    while (index <= dummyLength - 1) {
                        if (dummyExponents[index] > dummyExponents[index + 1]) {
                            dummyValue[1][1] = dummyCoefficients[index][1][1];
                            dummyValue[1][2] = dummyCoefficients[index][1][2];
                            dummyValue[2][1] = dummyCoefficients[index][2][1];
                            dummyValue[2][2] = dummyCoefficients[index][2][2];
                            dummyCoefficients[index][1][1] = dummyCoefficients[index + 1][1][1];
                            dummyCoefficients[index][1][2] = dummyCoefficients[index + 1][1][2];
                            dummyCoefficients[index][2][1] = dummyCoefficients[index + 1][2][1];
                            dummyCoefficients[index][2][2] = dummyCoefficients[index + 1][2][2];
                            dummyCoefficients[index + 1][1][1] = dummyValue[1][1];
                            dummyCoefficients[index + 1][1][2] = dummyValue[1][2];
                            dummyCoefficients[index + 1][2][1] = dummyValue[2][1];
                            dummyCoefficients[index + 1][2][2] = dummyValue[2][2];
                            int dummyValueInteger = dummyExponents[index];
                            dummyExponents[index] = dummyExponents[index + 1];
                            dummyExponents[index + 1] = dummyValueInteger;
                            ++exchangeNumber;
                        }
                        ++index;
                    }
                }
                exchangeNumber = 1;
                while (exchangeNumber > 0) {
                    exchangeNumber = 0;
                    index = 1;
                    while (index <= dummyLength - 1) {
                        if (dummyExponents[index] == dummyExponents[index + 1] && (dummyCoefficients[index + 1][1][1].compareTo(BigInteger.ZERO) != 0 || dummyCoefficients[index + 1][2][1].compareTo(BigInteger.ZERO) != 0)) {
                            dummyCoefficients[index] = UnivariateFactorizationOverZ.fractionalComplexArithmetic(dummyCoefficients[index], dummyCoefficients[index + 1], '+');
                            dummyCoefficients[index + 1][1][1] = BigInteger.ZERO;
                            dummyCoefficients[index + 1][1][2] = BigInteger.ONE;
                            dummyCoefficients[index + 1][2][1] = BigInteger.ZERO;
                            dummyCoefficients[index + 1][2][2] = BigInteger.ONE;
                            ++exchangeNumber;
                        }
                        ++index;
                    }
                }
                int productDegree = Gdegree + degreeTwo;
                BigInteger[][][] product = new BigInteger[productDegree + 1][3][3];
                indexTwo = 0;
                indexOne = 0;
                while (indexOne <= productDegree) {
                    product[indexOne][1][1] = BigInteger.ZERO;
                    product[indexOne][1][2] = BigInteger.ONE;
                    product[indexOne][2][1] = BigInteger.ZERO;
                    product[indexOne][2][2] = BigInteger.ONE;
                    indexTwo = 1;
                    while (indexTwo <= dummyLength) {
                        if (indexOne == dummyExponents[indexTwo]) {
                            product[indexOne] = UnivariateFactorizationOverZ.fractionalComplexArithmetic(product[indexOne], dummyCoefficients[indexTwo], '+');
                        }
                        ++indexTwo;
                    }
                    ++indexOne;
                }
                newRdegree = Rdegree <= productDegree ? productDegree : Rdegree;
                polynomialOneAugmented = new BigInteger[newRdegree + 1][3][3];
                index = 0;
                while (index <= newRdegree) {
                    if (index > Rdegree) {
                        polynomialOneAugmented[index][1][1] = BigInteger.ZERO;
                        polynomialOneAugmented[index][1][2] = BigInteger.ONE;
                        polynomialOneAugmented[index][2][1] = BigInteger.ZERO;
                        polynomialOneAugmented[index][2][2] = BigInteger.ONE;
                    } else {
                        polynomialOneAugmented[index][1][1] = Rcoefficients[index][1][1];
                        polynomialOneAugmented[index][1][2] = Rcoefficients[index][1][2];
                        polynomialOneAugmented[index][2][1] = Rcoefficients[index][2][1];
                        polynomialOneAugmented[index][2][2] = Rcoefficients[index][2][2];
                    }
                    ++index;
                }
                polynomialTwoAugmented = new BigInteger[newRdegree + 1][3][3];
                index = 0;
                while (index <= newRdegree) {
                    if (index > productDegree) {
                        polynomialTwoAugmented[index][1][1] = BigInteger.ZERO;
                        polynomialTwoAugmented[index][1][2] = BigInteger.ONE;
                        polynomialTwoAugmented[index][2][1] = BigInteger.ZERO;
                        polynomialTwoAugmented[index][2][2] = BigInteger.ONE;
                    } else {
                        polynomialTwoAugmented[index][1][1] = product[index][1][1];
                        polynomialTwoAugmented[index][1][2] = product[index][1][2];
                        polynomialTwoAugmented[index][2][1] = product[index][2][1];
                        polynomialTwoAugmented[index][2][2] = product[index][2][2];
                    }
                    ++index;
                }
                BigInteger[][][] newRcoefficients = new BigInteger[newRdegree + 1][3][3];
                index = 0;
                while (index <= newRdegree) {
                    newRcoefficients[index] = UnivariateFactorizationOverZ.fractionalComplexArithmetic(polynomialOneAugmented[index], polynomialTwoAugmented[index], '-');
                    ++index;
                }
                index = newRdegree;
                halt = false;
                while (index >= 0 & !halt) {
                    if (newRcoefficients[index][1][1].compareTo(BigInteger.ZERO) == 0 && newRcoefficients[index][2][1].compareTo(BigInteger.ZERO) == 0) {
                        --index;
                        continue;
                    }
                    halt = true;
                }
                newRdegree = halt ? index : 0;
                Rdegree = newRdegree;
                Rcoefficients = new BigInteger[Rdegree + 1][3][3];
                index = 0;
                while (index <= Rdegree) {
                    Rcoefficients[index][1][1] = newRcoefficients[index][1][1];
                    Rcoefficients[index][1][2] = newRcoefficients[index][1][2];
                    Rcoefficients[index][2][1] = newRcoefficients[index][2][1];
                    Rcoefficients[index][2][2] = newRcoefficients[index][2][2];
                    ++index;
                }
                if (!(Rdegree == 0 & degreeTwo == 0)) continue;
                if (zeroDegreeCount > 0) {
                    terminate = true;
                }
                ++zeroDegreeCount;
            }
        } else {
            Rdegree = degreeOne;
            Rcoefficients = new BigInteger[Rdegree + 1][3][3];
            index = 0;
            while (index <= Rdegree) {
                Rcoefficients[index][1][1] = polynomialCoefficientsOne[index][1][1];
                Rcoefficients[index][1][2] = polynomialCoefficientsOne[index][1][2];
                Rcoefficients[index][2][1] = polynomialCoefficientsOne[index][2][1];
                Rcoefficients[index][2][2] = polynomialCoefficientsOne[index][2][2];
                ++index;
            }
            Qdegree = 0;
            Qcoefficients = new BigInteger[Qdegree + 1][3][3];
            Qcoefficients[0][1][1] = BigInteger.ZERO;
            Qcoefficients[0][1][2] = BigInteger.ONE;
            Qcoefficients[0][2][1] = BigInteger.ZERO;
            Qcoefficients[0][2][2] = BigInteger.ONE;
        }
        BigInteger[][][] QcoefficientsPseudo = new BigInteger[Qdegree + 1][3][3];
        index = Qdegree;
        while (index >= 0) {
            QcoefficientsPseudo[index] = UnivariateFactorizationOverZ.fractionalComplexArithmetic(bValue, Qcoefficients[index], '*');
            --index;
        }
        BigInteger[][][] RcoefficientsPseudo = new BigInteger[Rdegree + 1][3][3];
        index = Rdegree;
        while (index >= 0) {
            RcoefficientsPseudo[index] = UnivariateFactorizationOverZ.fractionalComplexArithmetic(bValue, Rcoefficients[index], '*');
            --index;
        }
        result.add(Qdegree);
        result.add(Rdegree);
        result.add(Qcoefficients);
        result.add(Rcoefficients);
        result.add(bValue);
        result.add(QcoefficientsPseudo);
        result.add(RcoefficientsPseudo);
        return result;
    }

    public static BigInteger[][] fractionalComplexArithmetic(BigInteger[][] numberOne, BigInteger[][] numberTwo, char sign) {
        BigInteger[][] result = new BigInteger[3][3];
        BigInteger[][] numberTwoConjugate = new BigInteger[3][3];
        numberTwoConjugate[1][1] = numberTwo[1][1];
        numberTwoConjugate[1][2] = numberTwo[1][2];
        numberTwoConjugate[2][1] = numberTwo[2][1].negate();
        numberTwoConjugate[2][2] = numberTwo[2][2];
        switch (sign) {
            case '+': {
                result[1] = UnivariateFactorizationOverZ.fractionalArithmetic(numberOne[1], numberTwo[1], '+');
                result[2] = UnivariateFactorizationOverZ.fractionalArithmetic(numberOne[2], numberTwo[2], '+');
                break;
            }
            case '-': {
                result[1] = UnivariateFactorizationOverZ.fractionalArithmetic(numberOne[1], numberTwo[1], '-');
                result[2] = UnivariateFactorizationOverZ.fractionalArithmetic(numberOne[2], numberTwo[2], '-');
                break;
            }
            case '*': {
                result[1] = UnivariateFactorizationOverZ.fractionalArithmetic(UnivariateFactorizationOverZ.fractionalArithmetic(numberOne[1], numberTwo[1], '*'), UnivariateFactorizationOverZ.fractionalArithmetic(numberOne[2], numberTwo[2], '*'), '-');
                result[2] = UnivariateFactorizationOverZ.fractionalArithmetic(UnivariateFactorizationOverZ.fractionalArithmetic(numberOne[1], numberTwo[2], '*'), UnivariateFactorizationOverZ.fractionalArithmetic(numberOne[2], numberTwo[1], '*'), '+');
                break;
            }
            case '/': {
                BigInteger[] divisor = UnivariateFactorizationOverZ.fractionalArithmetic(UnivariateFactorizationOverZ.fractionalArithmetic(numberTwo[1], numberTwo[1], '*'), UnivariateFactorizationOverZ.fractionalArithmetic(numberTwo[2], numberTwo[2], '*'), '+');
                result[1] = UnivariateFactorizationOverZ.fractionalArithmetic(UnivariateFactorizationOverZ.fractionalArithmetic(numberOne[1], numberTwoConjugate[1], '*'), UnivariateFactorizationOverZ.fractionalArithmetic(numberOne[2], numberTwoConjugate[2], '*'), '-');
                result[2] = UnivariateFactorizationOverZ.fractionalArithmetic(UnivariateFactorizationOverZ.fractionalArithmetic(numberOne[1], numberTwoConjugate[2], '*'), UnivariateFactorizationOverZ.fractionalArithmetic(numberOne[2], numberTwoConjugate[1], '*'), '+');
                result[1] = UnivariateFactorizationOverZ.fractionalArithmetic(result[1], divisor, '/');
                result[2] = UnivariateFactorizationOverZ.fractionalArithmetic(result[2], divisor, '/');
            }
        }
        return result;
    }

    public static BigInteger[] fractionalArithmetic(BigInteger[] fractionOne, BigInteger[] fractionTwo, char sign) {
        BigInteger[] result = new BigInteger[3];
        switch (sign) {
            case '+': {
                BigInteger lcm = fractionOne[2].multiply(fractionTwo[2]).divide(fractionOne[2].gcd(fractionTwo[2]));
                result[1] = lcm.divide(fractionOne[2]).multiply(fractionOne[1]).add(lcm.divide(fractionTwo[2]).multiply(fractionTwo[1]));
                result[2] = lcm;
                break;
            }
            case '-': {
                BigInteger lcm = fractionOne[2].multiply(fractionTwo[2]).divide(fractionOne[2].gcd(fractionTwo[2]));
                result[1] = lcm.divide(fractionOne[2]).multiply(fractionOne[1]).subtract(lcm.divide(fractionTwo[2]).multiply(fractionTwo[1]));
                result[2] = lcm;
                break;
            }
            case '*': {
                result[1] = fractionOne[1].multiply(fractionTwo[1]);
                result[2] = fractionOne[2].multiply(fractionTwo[2]);
                break;
            }
            case '/': {
                result[1] = fractionOne[1].multiply(fractionTwo[2]);
                result[2] = fractionOne[2].multiply(fractionTwo[1]);
            }
        }
        BigInteger hcf = result[1].abs().gcd(result[2]);
        result[1] = result[1].divide(hcf);
        result[2] = result[2].divide(hcf);
        if (result[2].compareTo(BigInteger.ZERO) == -1) {
            result[1] = result[1].negate();
            result[2] = result[2].negate();
        }
        return result;
    }

    public static List polynomialDivisionOverFiniteField(BigInteger[] polynomialA, BigInteger[] polynomialB, int degreeA, int degreeB, BigInteger qValue) {
        boolean error;
        BigInteger[] Qpolynomial = new BigInteger[]{};
        BigInteger[] Rpolynomial = new BigInteger[]{};
        int degreeOne = degreeA;
        int degreeTwo = degreeB;
        int Rdegree = 0;
        int Qdegree = 0;
        int zeroDegreeCount = 0;
        ArrayList<Object> result = new ArrayList<Object>(4);
        BigInteger[] polynomialOne = new BigInteger[degreeOne + 1];
        int index = 0;
        while (index <= degreeOne) {
            polynomialOne[index] = polynomialA[index];
            ++index;
        }
        BigInteger[] polynomialTwo = new BigInteger[degreeTwo + 1];
        index = 0;
        while (index <= degreeTwo) {
            polynomialTwo[index] = polynomialB[index];
            ++index;
        }
        index = 0;
        while (index <= degreeOne) {
            if (polynomialOne[index].abs().compareTo(qValue) != -1) {
                polynomialOne[index] = polynomialOne[index].divideAndRemainder(qValue)[1];
            }
            if (polynomialOne[index].compareTo(BigInteger.ZERO) == -1) {
                polynomialOne[index] = polynomialOne[index].add(qValue);
            }
            ++index;
        }
        index = 0;
        while (index <= degreeTwo) {
            if (polynomialTwo[index].abs().compareTo(qValue) != -1) {
                polynomialTwo[index] = polynomialTwo[index].divideAndRemainder(qValue)[1];
            }
            if (polynomialTwo[index].compareTo(BigInteger.ZERO) == -1) {
                polynomialTwo[index] = polynomialTwo[index].add(qValue);
            }
            ++index;
        }
        boolean halt = false;
        while (!halt & degreeOne > 0) {
            if (polynomialOne[degreeOne].compareTo(BigInteger.ZERO) != 0) {
                halt = true;
                continue;
            }
            --degreeOne;
        }
        halt = false;
        while (!halt & degreeTwo > 0) {
            if (polynomialTwo[degreeTwo].compareTo(BigInteger.ZERO) != 0) {
                halt = true;
                continue;
            }
            --degreeTwo;
        }
        if (degreeTwo != 0 || polynomialTwo[degreeTwo].compareTo(BigInteger.ZERO) != 0) {
            error = false;
            if (degreeOne >= degreeTwo) {
                Rdegree = degreeOne;
                Rpolynomial = new BigInteger[Rdegree + 1];
                index = 0;
                while (index <= Rdegree) {
                    Rpolynomial[index] = polynomialOne[index];
                    ++index;
                }
                Qdegree = 0;
                Qpolynomial = new BigInteger[Qdegree + 1];
                Qpolynomial[0] = BigInteger.ZERO;
                boolean terminate = false;
                while (Rdegree >= degreeTwo & !terminate) {
                    int Gdegree = Rdegree - degreeTwo;
                    BigInteger[] Gpolynomial = new BigInteger[Gdegree + 1];
                    index = 0;
                    while (index <= Gdegree) {
                        if (index < Gdegree) {
                            Gpolynomial[index] = BigInteger.ZERO;
                        } else {
                            List inverseElementResult = UnivariateFactorizationOverZ.multiplicativeInverse(polynomialTwo[degreeTwo], qValue);
                            BigInteger inverseElement = (BigInteger)inverseElementResult.get(1);
                            Gpolynomial[index] = Rpolynomial[Rdegree].multiply(inverseElement);
                            if (Gpolynomial[index].abs().compareTo(qValue) != -1) {
                                Gpolynomial[index] = Gpolynomial[index].divideAndRemainder(qValue)[1];
                            }
                            if (Gpolynomial[index].compareTo(BigInteger.ZERO) == -1) {
                                Gpolynomial[index] = Gpolynomial[index].add(qValue);
                            }
                        }
                        ++index;
                    }
                    int newQdegree = Qdegree <= Gdegree ? Gdegree : Qdegree;
                    BigInteger[] newQpolynomial = new BigInteger[newQdegree + 1];
                    index = 0;
                    while (index <= newQdegree) {
                        if (index <= Qdegree & index <= Gdegree) {
                            newQpolynomial[index] = Qpolynomial[index].add(Gpolynomial[index]);
                            if (newQpolynomial[index].abs().compareTo(qValue) != -1) {
                                newQpolynomial[index] = newQpolynomial[index].divideAndRemainder(qValue)[1];
                            }
                            if (newQpolynomial[index].compareTo(BigInteger.ZERO) == -1) {
                                newQpolynomial[index] = newQpolynomial[index].add(qValue);
                            }
                        } else {
                            newQpolynomial[index] = index > Qdegree ? Gpolynomial[index] : Qpolynomial[index];
                        }
                        ++index;
                    }
                    Qpolynomial = new BigInteger[newQdegree + 1];
                    index = 0;
                    while (index <= newQdegree) {
                        Qpolynomial[index] = newQpolynomial[index];
                        ++index;
                    }
                    index = newQdegree;
                    halt = false;
                    while (index >= 0 & !halt) {
                        if (Qpolynomial[index].compareTo(BigInteger.ZERO) == 0) {
                            --index;
                            continue;
                        }
                        halt = true;
                    }
                    Qdegree = halt ? index : 0;
                    List multiplicationResult = UnivariateFactorizationOverZ.polynomialArithmeticModular(Gpolynomial, polynomialTwo, Gdegree, degreeTwo, qValue, '*');
                    int productDegree = (Integer)multiplicationResult.get(0);
                    BigInteger[] product = (BigInteger[])multiplicationResult.get(1);
                    int newRdegree = Rdegree <= productDegree ? productDegree : Rdegree;
                    BigInteger[] newRpolynomial = new BigInteger[newRdegree + 1];
                    index = 0;
                    while (index <= newRdegree) {
                        if (index <= Rdegree & index <= productDegree) {
                            newRpolynomial[index] = Rpolynomial[index].subtract(product[index]);
                            if (newRpolynomial[index].abs().compareTo(qValue) != -1) {
                                newRpolynomial[index] = newRpolynomial[index].divideAndRemainder(qValue)[1];
                            }
                            if (newRpolynomial[index].compareTo(BigInteger.ZERO) == -1) {
                                newRpolynomial[index] = newRpolynomial[index].add(qValue);
                            }
                        } else {
                            newRpolynomial[index] = index > Rdegree ? product[index] : Rpolynomial[index];
                        }
                        ++index;
                    }
                    Rpolynomial = new BigInteger[newRdegree + 1];
                    index = 0;
                    while (index <= newRdegree) {
                        Rpolynomial[index] = newRpolynomial[index];
                        ++index;
                    }
                    index = newRdegree;
                    halt = false;
                    while (index >= 0 & !halt) {
                        if (Rpolynomial[index].compareTo(BigInteger.ZERO) == 0) {
                            --index;
                            continue;
                        }
                        halt = true;
                    }
                    Rdegree = halt ? index : 0;
                    if (!(Rdegree == 0 & degreeTwo == 0)) continue;
                    if (zeroDegreeCount > 0) {
                        terminate = true;
                    }
                    ++zeroDegreeCount;
                }
            } else {
                Rdegree = degreeOne;
                Rpolynomial = new BigInteger[Rdegree + 1];
                index = 0;
                while (index <= Rdegree) {
                    Rpolynomial[index] = polynomialOne[index];
                    ++index;
                }
                Qdegree = 0;
                Qpolynomial = new BigInteger[Qdegree + 1];
                Qpolynomial[0] = BigInteger.ZERO;
            }
            halt = false;
            while (!halt & Qdegree > 0) {
                if (Qpolynomial[Qdegree].compareTo(BigInteger.ZERO) != 0) {
                    halt = true;
                    continue;
                }
                --Qdegree;
            }
            halt = false;
            while (!halt & Rdegree > 0) {
                if (Rpolynomial[Rdegree].compareTo(BigInteger.ZERO) != 0) {
                    halt = true;
                    continue;
                }
                --Rdegree;
            }
        } else {
            error = true;
        }
        result.add(error);
        result.add(Qdegree);
        result.add(Rdegree);
        result.add(Qpolynomial);
        result.add(Rpolynomial);
        return result;
    }

    public static List polynomialArithmeticModular(BigInteger[] polynomialA, BigInteger[] polynomialB, int degreeA, int degreeB, BigInteger qValue, char sign) {
        BigInteger[] resultPolynomial = new BigInteger[]{};
        BigInteger[] dummyPolynomial = new BigInteger[(degreeA + 1) * (degreeB + 1) + 1];
        int[] dummyExponents = new int[(degreeA + 1) * (degreeB + 1) + 1];
        int degreeOne = degreeA;
        int degreeTwo = degreeB;
        int resultDegree = 0;
        ArrayList<Object> result = new ArrayList<Object>(4);
        BigInteger[] polynomialOne = new BigInteger[degreeOne + 1];
        int index = 0;
        while (index <= degreeOne) {
            polynomialOne[index] = polynomialA[index];
            ++index;
        }
        BigInteger[] polynomialTwo = new BigInteger[degreeTwo + 1];
        index = 0;
        while (index <= degreeTwo) {
            polynomialTwo[index] = polynomialB[index];
            ++index;
        }
        index = 0;
        while (index <= degreeOne) {
            if (polynomialOne[index].abs().compareTo(qValue) != -1) {
                polynomialOne[index] = polynomialOne[index].divideAndRemainder(qValue)[1];
            }
            if (polynomialOne[index].compareTo(BigInteger.ZERO) == -1) {
                polynomialOne[index] = polynomialOne[index].add(qValue);
            }
            ++index;
        }
        index = 0;
        while (index <= degreeTwo) {
            if (polynomialTwo[index].abs().compareTo(qValue) != -1) {
                polynomialTwo[index] = polynomialTwo[index].divideAndRemainder(qValue)[1];
            }
            if (polynomialTwo[index].compareTo(BigInteger.ZERO) == -1) {
                polynomialTwo[index] = polynomialTwo[index].add(qValue);
            }
            ++index;
        }
        boolean halt = false;
        while (!halt & degreeOne > 0) {
            if (polynomialOne[degreeOne].compareTo(BigInteger.ZERO) != 0) {
                halt = true;
                continue;
            }
            --degreeOne;
        }
        halt = false;
        while (!halt & degreeTwo > 0) {
            if (polynomialTwo[degreeTwo].compareTo(BigInteger.ZERO) != 0) {
                halt = true;
                continue;
            }
            --degreeTwo;
        }
        switch (sign) {
            case '+': {
                resultDegree = degreeOne > degreeTwo ? degreeOne : degreeTwo;
                BigInteger[] dummyOne = new BigInteger[resultDegree + 1];
                index = 0;
                while (index <= resultDegree) {
                    dummyOne[index] = index <= degreeOne ? polynomialOne[index] : BigInteger.ZERO;
                    ++index;
                }
                BigInteger[] dummyTwo = new BigInteger[resultDegree + 1];
                index = 0;
                while (index <= resultDegree) {
                    dummyTwo[index] = index <= degreeTwo ? polynomialTwo[index] : BigInteger.ZERO;
                    ++index;
                }
                resultPolynomial = new BigInteger[resultDegree + 1];
                index = 0;
                while (index <= resultDegree) {
                    resultPolynomial[index] = dummyOne[index].add(dummyTwo[index]);
                    if (resultPolynomial[index].abs().compareTo(qValue) != -1) {
                        resultPolynomial[index] = resultPolynomial[index].divideAndRemainder(qValue)[1];
                    }
                    if (resultPolynomial[index].compareTo(BigInteger.ZERO) == -1) {
                        resultPolynomial[index] = resultPolynomial[index].add(qValue);
                    }
                    ++index;
                }
                break;
            }
            case '-': {
                resultDegree = degreeOne > degreeTwo ? degreeOne : degreeTwo;
                BigInteger[] dummyOne = new BigInteger[resultDegree + 1];
                index = 0;
                while (index <= resultDegree) {
                    dummyOne[index] = index <= degreeOne ? polynomialOne[index] : BigInteger.ZERO;
                    ++index;
                }
                BigInteger[] dummyTwo = new BigInteger[resultDegree + 1];
                index = 0;
                while (index <= resultDegree) {
                    dummyTwo[index] = index <= degreeTwo ? polynomialTwo[index] : BigInteger.ZERO;
                    ++index;
                }
                resultPolynomial = new BigInteger[resultDegree + 1];
                index = 0;
                while (index <= resultDegree) {
                    resultPolynomial[index] = dummyOne[index].subtract(dummyTwo[index]);
                    if (resultPolynomial[index].abs().compareTo(qValue) != -1) {
                        resultPolynomial[index] = resultPolynomial[index].divideAndRemainder(qValue)[1];
                    }
                    if (resultPolynomial[index].compareTo(BigInteger.ZERO) == -1) {
                        resultPolynomial[index] = resultPolynomial[index].add(qValue);
                    }
                    ++index;
                }
                break;
            }
            case '*': {
                int indexTwo;
                index = 1;
                int indexOne = 0;
                while (indexOne <= degreeOne) {
                    indexTwo = 0;
                    while (indexTwo <= degreeTwo) {
                        dummyPolynomial[index] = polynomialOne[indexOne].multiply(polynomialTwo[indexTwo]);
                        if (dummyPolynomial[index].abs().compareTo(qValue) != -1) {
                            dummyPolynomial[index] = dummyPolynomial[index].divideAndRemainder(qValue)[1];
                        }
                        if (dummyPolynomial[index].compareTo(BigInteger.ZERO) == -1) {
                            dummyPolynomial[index] = dummyPolynomial[index].add(qValue);
                        }
                        dummyExponents[index] = indexOne + indexTwo;
                        ++index;
                        ++indexTwo;
                    }
                    ++indexOne;
                }
                int dummyLength = index - 1;
                int exchangeNumber = 1;
                while (exchangeNumber > 0) {
                    exchangeNumber = 0;
                    index = 1;
                    while (index <= dummyLength - 1) {
                        if (dummyExponents[index] > dummyExponents[index + 1]) {
                            BigInteger bigDummyValue = dummyPolynomial[index];
                            dummyPolynomial[index] = dummyPolynomial[index + 1];
                            dummyPolynomial[index + 1] = bigDummyValue;
                            int dummyValue = dummyExponents[index];
                            dummyExponents[index] = dummyExponents[index + 1];
                            dummyExponents[index + 1] = dummyValue;
                            ++exchangeNumber;
                        }
                        ++index;
                    }
                }
                exchangeNumber = 1;
                while (exchangeNumber > 0) {
                    exchangeNumber = 0;
                    index = 1;
                    while (index <= dummyLength - 1) {
                        if (dummyExponents[index] == dummyExponents[index + 1] && dummyPolynomial[index + 1].compareTo(BigInteger.ZERO) != 0) {
                            dummyPolynomial[index] = dummyPolynomial[index].add(dummyPolynomial[index + 1]);
                            if (dummyPolynomial[index].abs().compareTo(qValue) != -1) {
                                dummyPolynomial[index] = dummyPolynomial[index].divideAndRemainder(qValue)[1];
                            }
                            if (dummyPolynomial[index].compareTo(BigInteger.ZERO) == -1) {
                                dummyPolynomial[index] = dummyPolynomial[index].add(qValue);
                            }
                            dummyPolynomial[index + 1] = BigInteger.ZERO;
                            ++exchangeNumber;
                        }
                        ++index;
                    }
                }
                resultDegree = degreeOne + degreeTwo;
                resultPolynomial = new BigInteger[resultDegree + 1];
                indexTwo = 0;
                indexOne = 0;
                while (indexOne <= resultDegree) {
                    resultPolynomial[indexOne] = BigInteger.ZERO;
                    indexTwo = 1;
                    while (indexTwo <= dummyLength) {
                        if (indexOne == dummyExponents[indexTwo]) {
                            resultPolynomial[indexOne] = resultPolynomial[indexOne].add(dummyPolynomial[indexTwo]);
                            if (resultPolynomial[indexOne].abs().compareTo(qValue) != -1) {
                                resultPolynomial[indexOne] = resultPolynomial[indexOne].divideAndRemainder(qValue)[1];
                            }
                            if (resultPolynomial[indexOne].compareTo(BigInteger.ZERO) == -1) {
                                resultPolynomial[indexOne] = resultPolynomial[indexOne].add(qValue);
                            }
                        }
                        ++indexTwo;
                    }
                    ++indexOne;
                }
                break;
            }
        }
        halt = false;
        while (!halt & resultDegree > 0) {
            if (resultPolynomial[resultDegree].compareTo(BigInteger.ZERO) != 0) {
                halt = true;
                continue;
            }
            --resultDegree;
        }
        result.add(resultDegree);
        result.add(resultPolynomial);
        return result;
    }

    public static List multiplicativeInverse(BigInteger number, BigInteger modulo) {
        boolean error;
        List extendedEuclideanAlgorithmResult;
        BigInteger multiplicativeInverse = BigInteger.ONE;
        ArrayList<Comparable<Boolean>> result = new ArrayList<Comparable<Boolean>>(4);
        if (number.abs().compareTo(modulo) != -1) {
            number = number.divideAndRemainder(modulo)[1];
        }
        if (number.compareTo(BigInteger.ZERO) == -1) {
            number = number.add(modulo);
        }
        if (((BigInteger)(extendedEuclideanAlgorithmResult = UnivariateFactorizationOverZ.extendedEuclideanAlgorithm(number, modulo)).get(0)).compareTo(BigInteger.ONE) == 0) {
            error = false;
            multiplicativeInverse = (BigInteger)extendedEuclideanAlgorithmResult.get(2);
            if (multiplicativeInverse.abs().compareTo(modulo) != -1) {
                multiplicativeInverse = multiplicativeInverse.divideAndRemainder(modulo)[1];
            }
            if (multiplicativeInverse.compareTo(BigInteger.ZERO) == -1) {
                multiplicativeInverse = multiplicativeInverse.add(modulo);
            }
        } else {
            error = true;
        }
        result.add(Boolean.valueOf(error));
        result.add(multiplicativeInverse);
        return result;
    }

    public static List extendedEuclideanAlgorithm(BigInteger numberOne, BigInteger numberTwo) {
        BigInteger gcd = BigInteger.ONE;
        BigInteger mValue = BigInteger.ONE;
        BigInteger nValue = BigInteger.ONE;
        boolean error = false;
        ArrayList<BigInteger> result = new ArrayList<BigInteger>(4);
        BigInteger remainder = BigInteger.ONE;
        BigInteger xValue = BigInteger.ZERO;
        BigInteger lastxValue = BigInteger.ONE;
        BigInteger yValue = BigInteger.ONE;
        BigInteger lastyValue = BigInteger.ZERO;
        if (numberOne.compareTo(BigInteger.ZERO) != 0 && numberTwo.compareTo(BigInteger.ZERO) != 0 && numberOne.compareTo(BigInteger.ZERO) == 1 && numberTwo.compareTo(BigInteger.ZERO) == 1) {
            BigInteger divisor;
            BigInteger dividend;
            if (numberOne.compareTo(numberTwo) == 1) {
                dividend = numberOne;
                divisor = numberTwo;
            } else {
                dividend = numberTwo;
                divisor = numberOne;
            }
            while (remainder.compareTo(BigInteger.ZERO) != 0) {
                BigInteger[] divisionResult = dividend.divideAndRemainder(divisor);
                BigInteger quotient = divisionResult[0];
                remainder = divisionResult[1];
                dividend = divisor;
                divisor = remainder;
                BigInteger tempValue = xValue;
                xValue = lastxValue.subtract(quotient.multiply(xValue));
                lastxValue = tempValue;
                tempValue = yValue;
                yValue = lastyValue.subtract(quotient.multiply(yValue));
                lastyValue = tempValue;
            }
            gcd = dividend;
            mValue = lastxValue;
            nValue = lastyValue;
        } else {
            error = true;
        }
        result.add(gcd);
        result.add(mValue);
        result.add(nValue);
        return result;
    }
}

