/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.EvalUtilities;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.form.output.StringBufferWriter;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.parser.client.SyntaxError;

public class Console {
    private EvalUtilities util;
    private File fFile;
    private String fDefaultSystemRulesFilename;
    private static int COUNTER = 1;

    public static void main(String[] args) {
        Console console;
        Console.printUsage();
        try {
            console = new Console();
        }
        catch (SyntaxError e1) {
            e1.printStackTrace();
            return;
        }
        String inputExpression = null;
        String outputExpression = null;
        console.setArgs(args);
        F.initSymbols(console.getDefaultSystemRulesFilename(), null, false);
        File file = console.getFile();
        if (file != null) {
            try {
                String line;
                BufferedReader f = new BufferedReader(new FileReader(file));
                StringBuffer buff = new StringBuffer(1024);
                while ((line = f.readLine()) != null) {
                    buff.append(line);
                    buff.append("\n");
                }
                f.close();
                inputExpression = buff.toString();
                outputExpression = console.interpreter(inputExpression);
                System.out.println("In [" + COUNTER + "]: " + inputExpression);
                System.out.println("Out[" + COUNTER + "]: " + outputExpression);
                ++COUNTER;
            }
            catch (IOException ioe) {
                String msg = "Cannot read from the specified file. Make sure the path exists and you have read permission.";
                System.out.println("Cannot read from the specified file. Make sure the path exists and you have read permission.");
                return;
            }
        }
        while (true) {
            try {
                while (true) {
                    if ((inputExpression = console.readString(System.out, ">>> ")) == null) {
                        continue;
                    }
                    if (inputExpression.length() >= 4 && inputExpression.toLowerCase().substring(0, 4).equals("exit")) {
                        System.out.println("Closing MathEclipse console... bye.");
                        System.exit(0);
                    }
                    outputExpression = console.interpreter(inputExpression);
                    System.out.println("In [" + COUNTER + "]: " + inputExpression);
                    System.out.println("Out[" + COUNTER + "]: " + outputExpression);
                    ++COUNTER;
                }
            }
            catch (MathRuntimeException mre) {
                Throwable me = mre.getCause();
                System.out.println(me.getMessage());
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    private static void printUsage() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("org.matheclipse.core.eval.Console [options]" + lineSeparator);
        msg.append(lineSeparator);
        msg.append("Program arguments: " + lineSeparator);
        msg.append("  -h or -help                print this message" + lineSeparator);
        msg.append("  -f or -file <filename>     use given file as input script" + lineSeparator);
        msg.append("  -d or -default <filename>  use given textfile for system rules" + lineSeparator);
        msg.append("To stop the program type: exit<RETURN>" + lineSeparator);
        msg.append("To continue an input line type: \\<RETURN>" + lineSeparator);
        msg.append("at the end of the line." + lineSeparator);
        msg.append("****+****+****+****+****+****+****+****+****+****+****+****+");
        System.out.println(msg.toString());
    }

    public Console() {
        EvalEngine engine = new EvalEngine();
        this.util = new EvalUtilities(engine, false);
    }

    private void setArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("-help") || arg.equals("-h")) {
                Console.printUsage();
                return;
            }
            if (arg.equals("-file") || arg.equals("-f")) {
                try {
                    this.fFile = new File(args[i + 1]);
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    String msg = "You must specify a file when using the -file argument";
                    System.out.println("You must specify a file when using the -file argument");
                    return;
                }
            } else if (arg.equals("-default") || arg.equals("-d")) {
                try {
                    this.fDefaultSystemRulesFilename = args[i + 1];
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    String msg = "You must specify a file when using the -file argument";
                    System.out.println("You must specify a file when using the -file argument");
                    return;
                }
            } else if (arg.charAt(0) == '-') {
                String msg = "Unknown arg: " + arg;
                System.out.println(msg);
                Console.printUsage();
                return;
            }
            ++i;
        }
    }

    public String interpreter(String strEval) {
        StringBufferWriter buf = new StringBufferWriter();
        try {
            IExpr result = this.util.evaluate(strEval);
            OutputFormFactory.get().convert(buf, result);
            return buf.toString();
        }
        catch (RuntimeException re) {
            Throwable me = re.getCause();
            if (me instanceof MathException) {
                this.printException(buf, me);
            } else {
                this.printException(buf, re);
            }
        }
        catch (Exception e) {
            this.printException(buf, e);
        }
        return buf.toString();
    }

    private void printException(StringBufferWriter buf, Throwable e) {
        String msg = e.getMessage();
        if (msg != null) {
            buf.write("\nError: " + msg);
        } else {
            buf.write("\nError: " + e.getClass().getSimpleName());
        }
    }

    public void printPrompt(PrintStream out, String prompt) {
        out.print(prompt);
        out.flush();
    }

    public String readString(PrintStream out) {
        StringBuffer input = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        boolean done = false;
        try {
            while (!done) {
                String s = in.readLine();
                if (s == null) continue;
                if (s.length() > 0 && s.charAt(s.length() - 1) != '\\') {
                    input.append(s);
                    done = true;
                    continue;
                }
                if (s.length() > 1) {
                    input.append(s.substring(0, s.length() - 1));
                    continue;
                }
                input.append(" ");
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return input.toString();
    }

    public String readString(PrintStream out, String prompt) {
        this.printPrompt(out, prompt);
        return this.readString(out);
    }

    public void setFile(File file) {
        this.fFile = file;
    }

    public File getFile() {
        return this.fFile;
    }

    public String getDefaultSystemRulesFilename() {
        return this.fDefaultSystemRulesFilename;
    }
}

