/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import org.matheclipse.basic.Alloc;
import org.matheclipse.core.eval.interfaces.INumericComplex;
import org.matheclipse.core.eval.interfaces.INumericComplexConstant;
import org.matheclipse.core.eval.interfaces.INumericConstant;
import org.matheclipse.core.eval.util.DoubleStack;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class EvalComplex {
    public static double[] eval(DoubleStack stack, int top, IExpr expr) {
        if (expr instanceof IAST) {
            return EvalComplex.evalAST(stack, top, (IAST)expr);
        }
        Alloc alloc = Alloc.get();
        if (expr instanceof ISignedNumber) {
            double[] result = alloc.vector(2);
            result[0] = ((ISignedNumber)expr).doubleValue();
            result[1] = 0.0;
            return result;
        }
        if (expr instanceof ComplexNum) {
            double[] res = alloc.vector(2);
            res[0] = ((ComplexNum)expr).getRealPart();
            res[1] = ((ComplexNum)expr).getImaginaryPart();
            return res;
        }
        if (expr instanceof ISymbol) {
            return EvalComplex.evalSymbol((ISymbol)expr);
        }
        throw new UnsupportedOperationException();
    }

    public static double[] evalAST(DoubleStack stack, int top, IAST ast) {
        int newTop = top;
        ISymbol symbol = (ISymbol)ast.get(0);
        IEvaluator module = symbol.getEvaluator();
        if (module instanceof INumericComplex) {
            stack.ensureCapacity(top + ast.size() * 2);
            int i = 1;
            while (i < ast.size()) {
                double[] result = EvalComplex.eval(stack, newTop, (IExpr)ast.get(i));
                stack.push(result[0]);
                stack.push(result[1]);
                ++i;
            }
            return ((INumericComplex)((Object)module)).evalComplex(stack, ast.size() - 1);
        }
        IExpr result = F.evaln(ast);
        Alloc alloc = Alloc.get();
        if (result instanceof ComplexNum) {
            double[] res = alloc.vector(2);
            res[0] = ((ComplexNum)result).getRealPart();
            res[1] = ((ComplexNum)result).getImaginaryPart();
            return res;
        }
        if (result instanceof Num) {
            double[] res = alloc.vector(2);
            res[0] = ((Num)result).doubleValue();
            res[1] = 0.0;
            return res;
        }
        throw new UnsupportedOperationException();
    }

    public static double[] evalSymbol(ISymbol symbol) {
        IEvaluator module;
        Alloc alloc = Alloc.get();
        if (symbol.hasLocalVariableStack()) {
            IExpr expr = symbol.get();
            if (expr instanceof ISignedNumber) {
                double[] result = alloc.vector(2);
                result[0] = ((ISignedNumber)expr).doubleValue();
                result[1] = 0.0;
                return result;
            }
            if (expr instanceof ComplexNum) {
                double[] result = alloc.vector(2);
                result[0] = ((ComplexNum)expr).getRealPart();
                result[1] = ((ComplexNum)expr).getImaginaryPart();
                return result;
            }
        }
        if ((module = symbol.getEvaluator()) instanceof INumericConstant) {
            double[] result = alloc.vector(2);
            result[0] = ((INumericConstant)((Object)module)).evalReal();
            result[1] = 0.0;
            return result;
        }
        if (module instanceof INumericComplexConstant) {
            return ((INumericComplexConstant)((Object)module)).evalComplex();
        }
        IExpr result = F.evaln(symbol);
        if (result instanceof ComplexNum) {
            double[] res = alloc.vector(2);
            res[0] = ((ComplexNum)result).getRealPart();
            res[1] = ((ComplexNum)result).getImaginaryPart();
            return res;
        }
        if (result instanceof Num) {
            double[] res = alloc.vector(2);
            res[0] = ((Num)result).doubleValue();
            res[1] = 0.0;
            return res;
        }
        throw new UnsupportedOperationException();
    }
}

