/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import org.matheclipse.basic.Alloc;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.eval.interfaces.INumericConstant;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class EvalDouble {
    public static double eval(double[] stack, int top, IExpr expr) {
        if (expr instanceof IAST) {
            return EvalDouble.evalAST(stack, top, (IAST)expr);
        }
        if (expr instanceof ISignedNumber) {
            return ((ISignedNumber)expr).doubleValue();
        }
        if (expr instanceof ISymbol) {
            return EvalDouble.evalSymbol((ISymbol)expr);
        }
        throw new UnsupportedOperationException("EvalDouble#eval()");
    }

    public static double evalAST(double[] stack, int top, IAST ast) {
        ISymbol symbol = (ISymbol)ast.get(0);
        IEvaluator module = symbol.getEvaluator();
        if (module instanceof INumeric) {
            int newTop = top;
            if (top + ast.size() >= stack.length) {
                Alloc alloc = Alloc.get();
                stack = alloc.vector(ast.size() + 50);
            }
            int i = 1;
            while (i < ast.size()) {
                stack[++newTop] = EvalDouble.eval(stack, newTop, (IExpr)ast.get(i));
                ++i;
            }
            return ((INumeric)((Object)module)).evalReal(stack, newTop, ast.size() - 1);
        }
        IExpr result = F.evaln(ast);
        if (result instanceof Num) {
            return ((Num)result).doubleValue();
        }
        throw new UnsupportedOperationException("EvalDouble#evalAST(): " + ast);
    }

    public static double evalSymbol(ISymbol symbol) {
        if (symbol.hasLocalVariableStack()) {
            return ((ISignedNumber)symbol.get()).doubleValue();
        }
        IEvaluator module = symbol.getEvaluator();
        if (module instanceof INumericConstant) {
            return ((INumericConstant)((Object)module)).evalReal();
        }
        IExpr result = F.evaln(symbol);
        if (result instanceof Num) {
            return ((Num)result).doubleValue();
        }
        throw new UnsupportedOperationException("EvalDouble#evalSymbol() - no value assigned for symbol: " + symbol);
    }
}

