/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import apache.harmony.math.BigInteger;
import apache.harmony.math.Rational;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.matheclipse.basic.Util;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.SystemNamespace;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.ISymbolEvaluator;
import org.matheclipse.core.expression.ComplexSym;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.MethodSymbol;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IEvaluationEngine;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.list.algorithms.EvaluationSupport;
import org.matheclipse.core.sql.SerializeVariables2DB;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.ast.ASTNode;

public class EvalEngine
implements Serializable,
IEvaluationEngine {
    private static final long serialVersionUID = 407328682800652434L;
    private HashMap<String, ISymbol> fVariableMap;
    private transient HashMap<String, Stack<IExpr>> fLocalVariableStackMap = null;
    volatile transient boolean fStopRequested;
    transient int fRecursionCounter;
    transient boolean fNumericMode;
    transient String fSessionID;
    transient boolean fTraceMode;
    transient boolean fStopAfterEvaluationMode;
    transient Stack<IAST> fTraceStack;
    transient PrintStream fOutPrintStream = null;
    protected int fRecursionLimit;
    protected int fIterationLimit;
    static int fAnonymousCounter = 0;
    protected boolean fPackageMode = false;
    transient int fModuleCounter = 0;
    protected Set<ISymbol> fModifiedVariablesList;
    protected transient List<IExpr> fOutList = new ArrayList<IExpr>(10);
    public static final boolean DEBUG = false;
    private static final transient ThreadLocal<EvalEngine> instance = new ThreadLocal<EvalEngine>(){
        private int fID = 1;

        @Override
        public EvalEngine initialValue() {
            return new EvalEngine("ThreadLocal" + this.fID++, 0, System.out);
        }
    };

    public int incModuleCounter() {
        return ++this.fModuleCounter;
    }

    public static synchronized int getNextAnonymousCounter() {
        return ++fAnonymousCounter;
    }

    public static synchronized String getNextCounter() {
        return Integer.toString(++fAnonymousCounter);
    }

    public boolean isPackageMode() {
        return this.fPackageMode;
    }

    public void setPackageMode(boolean packageMode) {
        this.fPackageMode = packageMode;
    }

    public static void remove() {
        instance.remove();
    }

    public static EvalEngine get() {
        return instance.get();
    }

    public static void set(EvalEngine engine) {
        instance.set(engine);
    }

    public EvalEngine() {
        this("", 0, System.out);
    }

    public void reset() {
        this.fNumericMode = false;
        this.fRecursionCounter = 0;
    }

    public EvalEngine(F f, PrintStream out) {
        this("", -1, -1, out);
    }

    public EvalEngine(String sessionID, PrintStream out) {
        this(sessionID, -1, -1, out);
    }

    public EvalEngine(String sessionID, int recursionLimit, PrintStream out) {
        this(sessionID, recursionLimit, -1, out);
    }

    public EvalEngine(String sessionID, int recursionLimit, int iterationLimit, PrintStream out) {
        this.fSessionID = sessionID;
        this.fRecursionLimit = recursionLimit;
        this.fIterationLimit = iterationLimit;
        this.fOutPrintStream = out;
        this.init();
        EvalEngine.set(this);
    }

    @Override
    public final void init() {
        this.fRecursionCounter = 0;
        this.fNumericMode = false;
        this.fTraceMode = false;
        this.fStopAfterEvaluationMode = false;
        this.fTraceStack = new Stack();
        this.fStopRequested = false;
        this.fModifiedVariablesList = new HashSet<ISymbol>();
    }

    @Override
    public final IExpr evalWithoutNumericReset(IExpr expr) {
        IExpr temp = this.evalLoop(expr);
        return temp == null ? expr : temp;
    }

    public final IExpr evaluate(IExpr expr) {
        boolean numericMode = this.fNumericMode;
        try {
            IExpr iExpr = this.evalWithoutNumericReset(expr);
            return iExpr;
        }
        finally {
            this.fNumericMode = numericMode;
        }
    }

    public static final IExpr eval(IExpr expr) {
        return instance.get().evaluate(expr);
    }

    public final IExpr evaluateNull(IExpr expr) {
        return this.evalLoop(expr);
    }

    public static final IExpr evalNull(IExpr expr) {
        return instance.get().evaluateNull(expr);
    }

    public final IExpr evalStepByStep(IExpr expr) {
        IExpr result = null;
        boolean numericMode = this.fNumericMode;
        try {
            this.setTraceMode(true);
            this.setStopAfterEvaluationMode(true);
            result = this.evalLoop(expr);
        }
        finally {
            this.setStopAfterEvaluationMode(false);
            this.setTraceMode(false);
            this.setNumericMode(numericMode);
        }
        return result;
    }

    protected IExpr evalComplex(IComplex obj) {
        if (this.fNumericMode) {
            Rational r = obj.getRealPart();
            Rational i = obj.getImaginaryPart();
            double nr = 0.0;
            double dr = 1.0;
            double ni = 0.0;
            double di = 1.0;
            nr = r.getNumerator().doubleValue();
            dr = r.getDenominator().doubleValue();
            ni = i.getNumerator().doubleValue();
            di = i.getDenominator().doubleValue();
            return F.complexNum(nr / dr, ni / di);
        }
        if (obj instanceof ComplexSym) {
            INumber cTemp = ((ComplexSym)obj).normalize();
            if (cTemp == obj) {
                return null;
            }
            return cTemp;
        }
        return null;
    }

    protected IExpr evalDouble(INum dbl) {
        if (!this.fNumericMode) {
            this.fNumericMode = true;
            return dbl;
        }
        return null;
    }

    protected IExpr evalDoubleComplex(IComplexNum obj) {
        if (!this.fNumericMode) {
            this.fNumericMode = true;
            return obj;
        }
        return null;
    }

    protected IExpr evalFraction(IFraction obj) {
        if (this.fNumericMode) {
            double n = obj.getBigNumerator().doubleValue();
            double d = obj.getBigDenominator().doubleValue();
            return F.num(n / d);
        }
        if (obj.getBigDenominator().equals(BigInteger.ONE)) {
            return F.integer(obj.getBigNumerator());
        }
        return null;
    }

    public IExpr evalAST(IAST ast) {
        IExpr result = this.evalLoop(ast.head());
        if (result != null) {
            IAST resultList = ast.clone();
            resultList.setHeader(result);
            return resultList;
        }
        ISymbol symbol = ast.topHead();
        if (ast.size() != 1) {
            int attr = symbol.getAttributes();
            if (ast.size() == 2 && (1 & attr) == 1) {
                return (IExpr)ast.get(1);
            }
            if ((8 & attr) == 8 && (result = EvaluationSupport.flatten(ast)) != null) {
                return result;
            }
            IAST resultList = this.evalArgs(ast, attr);
            if (resultList != null) {
                return resultList;
            }
            if ((0x80 & attr) == 128) {
                int listLength = 0;
                int i = 0;
                while (i < ast.size()) {
                    if (ast.get(i) instanceof IAST && ((IAST)ast.get(i)).head().equals(F.List)) {
                        if (listLength == 0) {
                            listLength = ((IAST)ast.get(i)).size() - 1;
                        } else if (listLength != ((IAST)ast.get(i)).size() - 1) {
                            listLength = 0;
                            break;
                        }
                    }
                    ++i;
                }
                if (listLength != 0 && (result = EvaluationSupport.threadList(ast, listLength, 1)) != null) {
                    return result;
                }
            }
            if (ast.size() > 2 && (4 & attr) == 4) {
                EvaluationSupport.sort(ast);
            }
        }
        if ((result = symbol.evalDownRule(this, ast)) != null) {
            return result;
        }
        if (symbol instanceof MethodSymbol) {
            return ((MethodSymbol)symbol).invoke(ast);
        }
        IEvaluator module = symbol.getEvaluator();
        if (module instanceof IFunctionEvaluator) {
            if (this.fNumericMode) {
                return ((IFunctionEvaluator)module).numericEval(ast);
            }
            return ((IFunctionEvaluator)module).evaluate(ast);
        }
        return null;
    }

    private IAST evalArgs(IAST ast, int attr) {
        if (ast.size() > 1) {
            IExpr evaledExpr;
            IAST resultList = null;
            if ((0x20 & attr) == 0 && (evaledExpr = this.evalLoop((IExpr)ast.get(1))) != null) {
                if (resultList == null) {
                    resultList = ast.clone();
                }
                resultList.set(1, evaledExpr);
            }
            if ((0x40 & attr) == 0) {
                int i = 2;
                while (i < ast.size()) {
                    evaledExpr = this.evalLoop((IExpr)ast.get(i));
                    if (evaledExpr != null) {
                        if (resultList == null) {
                            resultList = ast.clone();
                        }
                        resultList.set(i, evaledExpr);
                    }
                    ++i;
                }
            }
            if (resultList != null) {
                return resultList;
            }
        }
        return null;
    }

    public IAST evalSetAttributes(IAST ast) {
        IAST result;
        if ((ast.getEvalFlags() & 0x300) != 0) {
            return ast;
        }
        ISymbol symbol = ast.topHead();
        int attr = symbol.getAttributes();
        IAST resultList = ast;
        if ((8 & attr) == 8 && (result = EvaluationSupport.flatten(ast)) != null) {
            resultList = result;
        }
        if ((0x60 & attr) != 96) {
            resultList = ast.clone();
            if ((0x20 & attr) == 0 && ast.size() > 1 && ast.get(1) instanceof IAST) {
                resultList.set(1, this.evalSetAttributes((IAST)ast.get(1)));
            }
            if ((0x40 & attr) == 0) {
                int i = 2;
                while (i < ast.size()) {
                    if (ast.get(i) instanceof IAST) {
                        resultList.set(i, this.evalSetAttributes((IAST)ast.get(i)));
                    }
                    ++i;
                }
            }
        }
        if (resultList.size() > 2 && (4 & attr) == 4) {
            EvaluationSupport.sort(resultList);
        }
        return resultList;
    }

    protected IExpr evalInteger(IInteger obj) {
        if (this.fNumericMode) {
            return F.num(obj.getBigNumerator().doubleValue());
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public IExpr evalLoop(IExpr expr) {
        block14: {
            block11: {
                block12: {
                    block13: {
                        if (this.fRecursionLimit > 0 && this.fRecursionCounter > this.fRecursionLimit) {
                            RecursionLimitExceeded.throwIt(this.fRecursionLimit, expr);
                        }
                        result = expr;
                        temp = expr;
                        evaled = false;
                        iterationCounter = 1;
                        traceList = null;
                        ++this.fRecursionCounter;
                        temp = this.evalObject(result);
                        if (temp == null) break block11;
                        if (!this.fTraceMode) ** GOTO lbl33
                        if (!this.fStopAfterEvaluationMode) break block12;
                        var8_7 = temp;
                        if (!evaled || traceList == null) break block13;
                        this.fTraceStack.pop();
                        topStack = this.fTraceStack.peek();
                        topStack.add(traceList);
                    }
                    --this.fRecursionCounter;
                    return var8_7;
                }
                try {
                    traceList = F.List();
                    traceList.add(expr);
                    traceList.add(temp);
                    this.fTraceStack.push(traceList);
lbl33:
                    // 2 sources

                    evaled = true;
                    result = temp;
                    if (true) ** GOTO lbl53
                }
                catch (Throwable var7_14) {
                    if (evaled && traceList != null) {
                        this.fTraceStack.pop();
                        topStack = this.fTraceStack.peek();
                        topStack.add(traceList);
                    }
                    --this.fRecursionCounter;
                    throw var7_14;
                }
            }
            if (evaled && traceList != null) {
                this.fTraceStack.pop();
                topStack = this.fTraceStack.peek();
                topStack.add(traceList);
            }
            --this.fRecursionCounter;
            return null;
            {
                do {
                    if ((temp = this.evalObject(result)) == null) continue;
                    if (this.fTraceMode) {
                        traceList.add(temp);
                    }
                    result = temp;
                    if (this.fIterationLimit < 0 || this.fIterationLimit > ++iterationCounter) continue;
                    IterationLimitExceeded.throwIt(iterationCounter, result);
lbl53:
                    // 4 sources

                } while (temp != null);
                if (!evaled) break block14;
                var8_8 = result;
            }
            if (evaled && traceList != null) {
                this.fTraceStack.pop();
                topStack = this.fTraceStack.peek();
                topStack.add(traceList);
            }
            --this.fRecursionCounter;
            return var8_8;
        }
        if (evaled && traceList != null) {
            this.fTraceStack.pop();
            topStack = this.fTraceStack.peek();
            topStack.add(traceList);
        }
        --this.fRecursionCounter;
        return null;
    }

    protected IExpr evalObject(IExpr obj) {
        Util.checkCanceled();
        if (obj instanceof IAST) {
            return this.evalAST((IAST)obj);
        }
        if (obj instanceof INumber) {
            if (obj instanceof ISignedNumber) {
                return this.evalSignedNumber((ISignedNumber)obj);
            }
            if (obj instanceof IComplexNum) {
                return this.evalDoubleComplex((IComplexNum)obj);
            }
            if (obj instanceof IComplex) {
                return this.evalComplex((IComplex)obj);
            }
        }
        if (obj instanceof ISymbol) {
            return this.evalSymbol((ISymbol)obj);
        }
        if (obj instanceof IStringX) {
            return null;
        }
        if (obj instanceof IPattern) {
            return this.evalPattern((IPattern)obj);
        }
        return null;
    }

    protected IExpr evalSignedNumber(ISignedNumber obj) {
        if (obj instanceof INum) {
            return this.evalDouble((INum)obj);
        }
        if (obj instanceof IInteger) {
            return this.evalInteger((IInteger)obj);
        }
        if (obj instanceof IFraction) {
            return this.evalFraction((IFraction)obj);
        }
        return null;
    }

    protected IExpr evalPattern(IPattern obj) {
        return null;
    }

    public IExpr evalSymbol(ISymbol symbol) {
        if (symbol.hasLocalVariableStack()) {
            return symbol.get();
        }
        IExpr result = symbol.evalDownRule(this, symbol);
        if (result != null) {
            return result;
        }
        IEvaluator module = symbol.getEvaluator();
        if (module instanceof ISymbolEvaluator) {
            if (this.fNumericMode) {
                return ((ISymbolEvaluator)module).numericEval(symbol);
            }
            return ((ISymbolEvaluator)module).evaluate(symbol);
        }
        return null;
    }

    public int getRecursionLimit() {
        return this.fRecursionLimit;
    }

    public int getIterationLimit() {
        return this.fIterationLimit;
    }

    public String getSessionID() {
        return this.fSessionID;
    }

    public IAST getTraceList() {
        return this.fTraceStack.pop();
    }

    public boolean isNumericMode() {
        return this.fNumericMode;
    }

    public boolean isStopAfterEvaluationMode() {
        return this.fStopAfterEvaluationMode;
    }

    public boolean isTraceMode() {
        return this.fTraceMode;
    }

    public void setNumericMode(boolean b) {
        this.fNumericMode = b;
    }

    public void setRecursionLimit(int i) {
        this.fRecursionLimit = i;
    }

    public void setIterationLimit(int i) {
        this.fIterationLimit = i;
    }

    public void setSessionID(String string) {
        this.fSessionID = string;
    }

    public void setStopAfterEvaluationMode(boolean b) {
        this.fStopAfterEvaluationMode = b;
    }

    public void setTraceList(IAST list) {
        this.fTraceStack.push(list);
    }

    public void setTraceMode(boolean b) {
        this.fTraceMode = b;
    }

    public boolean isStopRequested() {
        return this.fStopRequested;
    }

    public void setStopRequested(boolean stopRequested) {
        this.fStopRequested = stopRequested;
    }

    public void stopRequest() {
        this.fStopRequested = true;
    }

    public PrintStream getOutPrintStream() {
        return this.fOutPrintStream;
    }

    public void setOutPrintStream(PrintStream outPrintStream) {
        this.fOutPrintStream = outPrintStream;
    }

    public List<IExpr> getOutList() {
        return this.fOutList;
    }

    public boolean addOut(IExpr arg0) {
        if (arg0 == null) {
            this.fOutList.add(F.Null);
        }
        return this.fOutList.add(arg0);
    }

    public IExpr getOut(int index) {
        return this.fOutList.get(index);
    }

    public int sizeOut() {
        return this.fOutList.size();
    }

    public boolean addModifiedVariable(ISymbol arg0) {
        return this.fModifiedVariablesList.add(arg0);
    }

    public Set<ISymbol> getModifiedVariables() {
        return this.fModifiedVariablesList;
    }

    public void serializeVariables2DB(Connection con) throws SQLException, IOException {
        SerializeVariables2DB.write(con, this.fSessionID, this.fModifiedVariablesList);
    }

    public final IExpr parse(String expression) {
        Parser parser = new Parser();
        ASTNode node = parser.parse(expression);
        return AST2Expr.CONST.convert(node);
    }

    public final IExpr evaluate(String expression) {
        return this.evaluate(this.parse(expression));
    }

    public final Map<String, Stack<IExpr>> getLocalVariableStackMap() {
        if (this.fLocalVariableStackMap == null) {
            this.fLocalVariableStackMap = new HashMap();
        }
        return this.fLocalVariableStackMap;
    }

    public static final Stack<IExpr> localStack(String symbolName) {
        return EvalEngine.get().getLocalVariableStackMap().get(symbolName);
    }

    public static Stack<IExpr> localStackCreate(String symbolName) {
        Map<String, Stack<IExpr>> localVariableStackMap = EvalEngine.get().getLocalVariableStackMap();
        Stack<IExpr> temp = localVariableStackMap.get(symbolName);
        if (temp != null) {
            return temp;
        }
        temp = new Stack();
        localVariableStackMap.put(symbolName, temp);
        return temp;
    }

    public final Map<String, ISymbol> getVariableMap() {
        if (this.fVariableMap == null) {
            this.fVariableMap = new HashMap();
        }
        return this.fVariableMap;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.fVariableMap != null) {
            buf.append(this.fVariableMap.toString());
        }
        if (this.fLocalVariableStackMap != null) {
            buf.append(this.fLocalVariableStackMap.toString());
        }
        if (SystemNamespace.DEFAULT != null) {
            buf.append(SystemNamespace.DEFAULT.toString());
        }
        return buf.toString();
    }
}

