/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.Writer;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.MathMLUtilities;
import org.matheclipse.core.interfaces.IExpr;

public class EvalUtilities
extends MathMLUtilities {
    public EvalUtilities() {
        super(new EvalEngine(), false);
    }

    public EvalUtilities(boolean msie) {
        super(new EvalEngine(), msie);
    }

    public EvalUtilities(EvalEngine evalEngine, boolean msie) {
        super(evalEngine, msie);
    }

    public IExpr evaluate(String inputExpression) throws Exception {
        IExpr parsedExpression = null;
        if (inputExpression != null) {
            this.startRequest();
            this.fEvalEngine.reset();
            parsedExpression = this.fEvalEngine.parse(inputExpression);
            if (parsedExpression != null) {
                this.fEvalEngine.reset();
                IExpr temp = this.fEvalEngine.evaluate(parsedExpression);
                this.fEvalEngine.addOut(temp);
                return temp;
            }
        }
        return null;
    }

    public IExpr evaluate(IExpr parsedExpression) throws RuntimeException {
        if (parsedExpression != null) {
            this.startRequest();
            this.fEvalEngine.reset();
            IExpr temp = this.fEvalEngine.evaluate(parsedExpression);
            this.fEvalEngine.addOut(temp);
            return temp;
        }
        return null;
    }

    @Override
    public synchronized void toMathML(String inputExpression, Writer out) {
        try {
            IExpr result = this.evaluate(inputExpression);
            if (result != null) {
                this.toMathML(result, out);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

