/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.File;
import java.net.URL;
import org.matheclipse.core.eval.interfaces.AbstractArg2;
import org.matheclipse.core.eval.interfaces.AbstractArgMultiple;
import org.matheclipse.core.eval.interfaces.AbstractNonOrderlessArgMultiple;
import org.matheclipse.core.eval.interfaces.AbstractSymbolEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;

public class SourceGenerator {
    public static final String DS0 = "public static ISymbol ";
    public static final String CS0 = " = F.predefinedSymbol(\"";
    public static final String S0 = "\n  public static IAST ";
    public static final String UNA0 = "(IExpr a0) {\n    return unary(F.";
    public static final String UNA1 = ", a0);\n  }";
    public static final String BIN0 = "(IExpr a0, IExpr a1) {\n    return binary(F.";
    public static final String BIN1 = ", a0, a1);\n  }";
    public static final String TER0 = "(IExpr a0, IExpr a1, IExpr a2) {\n    return ternary(F.";
    public static final String TER1 = ", a0, a1, a2);\n  }";
    public static final String EVS0 = "\n  public static IAST EV";
    public static final String EVUNA0 = "(IExpr a0) {\n    return eval(F.";
    public static final String EVBIN0 = "(IExpr a0, IExpr a1) {\n    return eval(F.";
    public static final String EVTER0 = "(IExpr a0, IExpr a1, IExpr a2) {\n    return eval(F.";

    public static String createUnary(String oper) {
        return S0 + oper + UNA0 + oper + UNA1;
    }

    public static String createBinary(String oper) {
        return S0 + oper + BIN0 + oper + BIN1;
    }

    public static String createTernary(String oper) {
        return S0 + oper + TER0 + oper + TER1;
    }

    public static String createEvalUnary(String oper) {
        return EVS0 + oper + EVUNA0 + oper + UNA1;
    }

    public static String createEvalBinary(String oper) {
        return EVS0 + oper + EVBIN0 + oper + BIN1;
    }

    public static String createEvalTernary(String oper) {
        return EVS0 + oper + EVTER0 + oper + TER1;
    }

    public static void generateDeclareSymbols(String pckgname) {
        URL url;
        File directory;
        String name = pckgname;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((directory = new File((url = SourceGenerator.class.getResource(name = name.replace('.', '/'))).getFile())).exists()) {
            String[] files = directory.list();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".class")) {
                    String classname = files[i].substring(0, files[i].length() - 6);
                    try {
                        IFunctionEvaluator ev = (IFunctionEvaluator)Class.forName(String.valueOf(pckgname) + "." + classname).newInstance();
                        System.out.println(DS0 + classname + ";");
                    }
                    catch (ClassCastException ev) {
                    }
                    catch (ClassNotFoundException cnfex) {
                        System.err.println(cnfex);
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public static void generateCreateSymbols(String pckgname) {
        URL url;
        File directory;
        String name = pckgname;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((directory = new File((url = SourceGenerator.class.getResource(name = name.replace('.', '/'))).getFile())).exists()) {
            String[] files = directory.list();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".class")) {
                    String classname = files[i].substring(0, files[i].length() - 6);
                    try {
                        IFunctionEvaluator ev = (IFunctionEvaluator)Class.forName(String.valueOf(pckgname) + "." + classname).newInstance();
                        System.out.println(String.valueOf(classname) + CS0 + classname + "\");");
                    }
                    catch (ClassCastException ev) {
                    }
                    catch (ClassNotFoundException cnfex) {
                        System.err.println(cnfex);
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public static void generateFunctions(String pckgname) {
        URL url;
        File directory;
        String name = pckgname;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((directory = new File((url = SourceGenerator.class.getResource(name = name.replace('.', '/'))).getFile())).exists()) {
            String[] files = directory.list();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".class")) {
                    String classname = files[i].substring(0, files[i].length() - 6);
                    try {
                        IFunctionEvaluator ev = (IFunctionEvaluator)Class.forName(String.valueOf(pckgname) + "." + classname).newInstance();
                        if (ev instanceof AbstractArgMultiple || ev instanceof AbstractNonOrderlessArgMultiple) {
                            System.out.println(SourceGenerator.createBinary(classname));
                            System.out.println(SourceGenerator.createTernary(classname));
                        } else if (ev instanceof AbstractArg2) {
                            System.out.println(SourceGenerator.createBinary(classname));
                        } else {
                            System.out.println(SourceGenerator.createUnary(classname));
                        }
                    }
                    catch (ClassCastException ev) {
                    }
                    catch (ClassNotFoundException cnfex) {
                        System.err.println(cnfex);
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public static void generateEvalFunctions(String pckgname) {
        URL url;
        File directory;
        String name = pckgname;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((directory = new File((url = SourceGenerator.class.getResource(name = name.replace('.', '/'))).getFile())).exists()) {
            String[] files = directory.list();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".class")) {
                    String classname = files[i].substring(0, files[i].length() - 6);
                    try {
                        IFunctionEvaluator ev = (IFunctionEvaluator)Class.forName(String.valueOf(pckgname) + "." + classname).newInstance();
                        if (ev instanceof AbstractArgMultiple || ev instanceof AbstractNonOrderlessArgMultiple) {
                            System.out.println(SourceGenerator.createEvalBinary(classname));
                            System.out.println(SourceGenerator.createEvalTernary(classname));
                        } else if (ev instanceof AbstractArg2) {
                            System.out.println(SourceGenerator.createEvalBinary(classname));
                        } else {
                            System.out.println(SourceGenerator.createEvalUnary(classname));
                        }
                    }
                    catch (ClassCastException ev) {
                    }
                    catch (ClassNotFoundException cnfex) {
                        System.err.println(cnfex);
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public static void generateCoreRules(String pckgname) {
        URL url;
        File directory;
        String name = pckgname;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((directory = new File((url = SourceGenerator.class.getResource(name = name.replace('.', '/'))).getFile())).exists()) {
            String[] files = directory.list();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".class")) {
                    String classname = files[i].substring(0, files[i].length() - 6);
                    try {
                        Class.forName(String.valueOf(pckgname) + "." + classname).newInstance();
                        System.out.println("  f.createSymbol(\"" + classname + "\");");
                        F.symbol(classname);
                    }
                    catch (ClassNotFoundException cnfex) {
                        System.err.println(cnfex);
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public static void generateJavaScript(String pckgname) {
        URL url;
        File directory;
        String name = pckgname;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((directory = new File((url = SourceGenerator.class.getResource(name = name.replace('.', '/'))).getFile())).exists()) {
            System.out.println("\"True\",");
            System.out.println("\"False\",");
            String[] files = directory.list();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".class")) {
                    String classname = files[i].substring(0, files[i].length() - 6);
                    try {
                        Object o = Class.forName(String.valueOf(pckgname) + "." + classname).newInstance();
                        if (o instanceof AbstractSymbolEvaluator) {
                            System.out.print("\"" + classname + "\"");
                        } else {
                            System.out.print("\"" + classname + "[]\"");
                        }
                        if (i < files.length - 1) {
                            System.out.println(",");
                        }
                    }
                    catch (ClassNotFoundException cnfex) {
                        System.err.println(cnfex);
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public static void generateTemplates(String pckgname) {
        URL url;
        File directory;
        String name = pckgname;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((directory = new File((url = SourceGenerator.class.getResource(name = name.replace('.', '/'))).getFile())).exists()) {
            System.out.print("\n<template id=\"true\" name=\"True\" description=\"True\" context=\"org.matheclipse.templates\" enabled=\"true\">True</template>");
            System.out.print("\n<template id=\"false\" name=\"False\" description=\"False\" context=\"org.matheclipse.templates\" enabled=\"true\">False</template>");
            System.out.print("\n<template id=\"infinity\" name=\"Infinity\" description=\"Infinity\" context=\"org.matheclipse.templates\" enabled=\"true\">Infinity</template>");
            String[] files = directory.list();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".class")) {
                    String classname = files[i].substring(0, files[i].length() - 6);
                    try {
                        Object o = Class.forName(String.valueOf(pckgname) + "." + classname).newInstance();
                        if (o instanceof AbstractSymbolEvaluator) {
                            System.out.print("\n<template id=\"" + classname.toLowerCase() + "\" name=\"" + classname + "\" description=\"" + classname + "\" context=\"org.matheclipse.templates\"" + " enabled=\"true\">" + classname + "</template>");
                        } else {
                            System.out.print("\n<template id=\"" + classname.toLowerCase() + "\" name=\"" + classname + "\" description=\"" + classname + "[]\" context=\"org.matheclipse.templates\"" + " enabled=\"true\">" + classname + "[${cursor}]</template>");
                        }
                    }
                    catch (ClassNotFoundException cnfex) {
                        System.err.println(cnfex);
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("private final String[] COMPLETIONS = { ");
        SourceGenerator.generateJavaScript("org.matheclipse.core.reflection.system");
        System.out.println("};");
        System.out.println("\n--------------------\n");
        SourceGenerator.generateDeclareSymbols("org.matheclipse.core.reflection.system");
        System.out.println("\n--------------------\n");
        SourceGenerator.generateCreateSymbols("org.matheclipse.core.reflection.system");
        System.out.println("\n--------------------\n");
        SourceGenerator.generateFunctions("org.matheclipse.core.reflection.system");
        System.out.println("\n--------------------\n");
        SourceGenerator.generateEvalFunctions("org.matheclipse.core.reflection.system");
    }
}

