/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.Writer;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.form.tex.TeXFormFactory;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.ast.ASTNode;

public class TeXUtilities {
    protected EvalEngine fEvalEngine;
    protected TeXFormFactory fTeXFactory;
    Parser fParser;

    public TeXUtilities(EvalEngine evalEngine) {
        this.fEvalEngine = evalEngine;
        EvalEngine.set(evalEngine);
        this.fTeXFactory = new TeXFormFactory();
        this.fParser = new Parser();
    }

    public synchronized void toTeX(String inputExpression, Writer out) {
        IExpr parsedExpression = null;
        if (inputExpression != null) {
            try {
                ASTNode node = this.fParser.parse(inputExpression);
                parsedExpression = AST2Expr.CONST.convert(node);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.toTeX(parsedExpression, out);
    }

    public synchronized void toTeX(Object objectExpression, Writer out) {
        StringBuffer buf = new StringBuffer();
        if (objectExpression != null) {
            this.fTeXFactory.convert(buf, objectExpression, 0);
            try {
                out.write(buf.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void stopRequest() {
        this.fEvalEngine.stopRequest();
    }
}

