/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.exception;

import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public final class Validate {
    public static int checkIntType(IAST ast, int pos) {
        return Validate.checkIntType(ast, pos, 0);
    }

    public static int checkIntType(IAST ast, int pos, int startValue) {
        if (((IExpr)ast.get(pos)).isInteger()) {
            try {
                int result = ((IInteger)ast.get(pos)).toInt();
                if (startValue > result) {
                    throw new WrongArgumentType(ast, (IExpr)ast.get(pos), pos, "Trying to convert the argument into the integer range: " + startValue + " - " + Integer.MAX_VALUE);
                }
                return result;
            }
            catch (ArithmeticException ae) {
                throw new WrongArgumentType(ast, (IExpr)ast.get(pos), pos, "Trying to convert the argument into the integer range: " + startValue + " - " + Integer.MAX_VALUE);
            }
        }
        throw new WrongArgumentType(ast, (IExpr)ast.get(pos), pos, "Trying to convert the argument into the integer range: " + startValue + " - " + Integer.MAX_VALUE);
    }

    public static IAST checkRange(IAST ast, int from) {
        return Validate.checkRange(ast, from, Integer.MAX_VALUE);
    }

    public static IAST checkRange(IAST ast, int from, int to) {
        if (ast.size() < from) {
            throw new WrongNumberOfArguments(ast, from, ast.size() - 1);
        }
        if (ast.size() > to) {
            throw new WrongNumberOfArguments(ast, to, ast.size() - 1);
        }
        return ast;
    }

    public static IAST checkSize(IAST ast, int size) {
        if (ast.size() != size) {
            throw new WrongNumberOfArguments(ast, size - 1, ast.size() - 1);
        }
        return ast;
    }

    public static IAST checkSymbolOrSymbolList(IAST ast, int position) {
        IAST vars = null;
        if (((IExpr)ast.get(position)).isList()) {
            vars = (IAST)ast.get(position);
            int i = 1;
            while (i < vars.size()) {
                Validate.checkSymbolType(vars, i);
                ++i;
            }
        } else {
            vars = F.List((IExpr)Validate.checkSymbolType(ast, position));
        }
        return vars;
    }

    public static ISymbol checkSymbolType(IAST ast, int position) {
        if (((IExpr)ast.get(position)).isSymbol()) {
            return (ISymbol)ast.get(position);
        }
        throw new WrongArgumentType(ast, (IExpr)ast.get(position), position, "Symbol expected!");
    }

    public static IAST checkASTType(IAST ast, int position) {
        if (((IExpr)ast.get(position)).isAST()) {
            return (IAST)ast.get(position);
        }
        throw new WrongArgumentType(ast, (IExpr)ast.get(position), position, "Function(AST) expected!");
    }

    private Validate() {
    }
}

