/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.interfaces;

import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcherAndInvoker;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;

public abstract class AbstractFunctionEvaluator
implements IFunctionEvaluator {
    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    public String[] getRules() {
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        String[] rules = this.getRules();
        if (rules != null) {
            Parser parser = new Parser();
            EvalEngine engine = EvalEngine.get();
            boolean oldPackageMode = engine.isPackageMode();
            try {
                engine.setPackageMode(true);
                this.setUpRules(rules, parser, engine);
            }
            finally {
                engine.setPackageMode(oldPackageMode);
            }
        }
        F.SYMBOL_OBSERVER.createPredefinedSymbol(symbol.toString());
    }

    private void setUpRules(String[] rules, Parser parser, EvalEngine engine) {
        int i = 0;
        while (i < rules.length) {
            ASTNode parsedAST = parser.parse(rules[i]);
            IExpr obj = AST2Expr.CONST.convert(parsedAST);
            engine.evaluate(obj);
            ++i;
        }
    }

    @Override
    public abstract IExpr evaluate(IAST var1);

    public void createRuleFromMethod(ISymbol symbol, String patternString, String methodName) {
        PatternMatcherAndInvoker pm = new PatternMatcherAndInvoker(patternString, (IFunctionEvaluator)this, methodName);
        symbol.putDownRule(pm);
    }
}

