/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.interfaces;

import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.RealMatrix;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ExprFieldElement;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public abstract class AbstractMatrix1Expr
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST function) {
        try {
            Validate.checkSize(function, 2);
            int[] dim = ((IExpr)function.get(1)).isMatrix();
            if (dim != null) {
                IAST list = (IAST)function.get(1);
                FieldMatrix<ExprFieldElement> matrix = Convert.list2Matrix(list);
                return this.matrixEval(matrix).getExpr();
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST function) {
        try {
            if (function.size() == 2) {
                IAST list = (IAST)function.get(1);
                RealMatrix matrix = Convert.list2RealMatrix(list);
                return this.realMatrixEval(matrix);
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return null;
    }

    public abstract ExprFieldElement matrixEval(FieldMatrix<ExprFieldElement> var1);

    public abstract IExpr realMatrixEval(RealMatrix var1);
}

