/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.basic.Alloc;

public class DoubleStack {
    private double[] stack;
    int top;

    public DoubleStack(int initialCapacity) {
        Alloc alloc = Alloc.get();
        this.stack = alloc.vector(initialCapacity);
        this.top = -1;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.stack.length;
        if (minCapacity > oldCapacity) {
            double[] oldData = this.stack;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            Alloc alloc = Alloc.get();
            this.stack = alloc.vector(newCapacity);
            System.arraycopy(oldData, 0, this.stack, 0, oldCapacity);
        }
    }

    public final boolean isEmpty() {
        return this.top < 0;
    }

    public final double peek() {
        return this.stack[this.top];
    }

    public final double push(double item) {
        this.stack[++this.top] = item;
        return item;
    }

    public final double pop() {
        return this.stack[this.top--];
    }
}

