/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Symbol;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.generic.interfaces.IIterator;

public class Iterator
implements IIterator<IExpr> {
    IExpr count;
    final boolean fNumericMode;
    EvalEngine evalEngine;
    final IExpr maxCount;
    IExpr start;
    final IExpr step;
    final Symbol variable;

    public Iterator(IAST lst, EvalEngine sess) {
        this.evalEngine = sess;
        this.fNumericMode = this.evalEngine.isNumericMode();
        switch (lst.size()) {
            case 2: {
                this.start = F.C1;
                this.maxCount = this.evalEngine.evalWithoutNumericReset((IExpr)lst.get(1));
                this.step = F.C1;
                this.variable = null;
                break;
            }
            case 3: {
                this.start = F.C1;
                this.maxCount = this.evalEngine.evalWithoutNumericReset((IExpr)lst.get(2));
                this.step = F.C1;
                if (lst.get(1) instanceof Symbol) {
                    this.variable = (Symbol)lst.get(1);
                    break;
                }
                this.variable = null;
                break;
            }
            case 4: {
                this.start = this.evalEngine.evalWithoutNumericReset((IExpr)lst.get(2));
                this.maxCount = this.evalEngine.evalWithoutNumericReset((IExpr)lst.get(3));
                this.step = F.C1;
                if (lst.get(1) instanceof Symbol) {
                    this.variable = (Symbol)lst.get(1);
                    break;
                }
                this.variable = null;
                break;
            }
            case 5: {
                this.start = this.evalEngine.evalWithoutNumericReset((IExpr)lst.get(2));
                this.maxCount = this.evalEngine.evalWithoutNumericReset((IExpr)lst.get(3));
                this.step = this.evalEngine.evalWithoutNumericReset((IExpr)lst.get(4));
                if (lst.get(1) instanceof Symbol) {
                    this.variable = (Symbol)lst.get(1);
                    break;
                }
                this.variable = null;
                break;
            }
            default: {
                this.maxCount = null;
                this.step = null;
                this.variable = null;
            }
        }
    }

    public Iterator(IAST lst, Symbol symbol, EvalEngine sess) {
        this.evalEngine = sess;
        this.fNumericMode = this.evalEngine.isNumericMode();
        switch (lst.size()) {
            case 2: {
                this.start = F.C1;
                this.maxCount = this.evalEngine.evalWithoutNumericReset((IExpr)lst.get(1));
                this.step = F.C1;
                this.variable = symbol;
                break;
            }
            case 3: {
                this.start = this.evalEngine.evalWithoutNumericReset((IExpr)lst.get(1));
                this.maxCount = this.evalEngine.evalWithoutNumericReset((IExpr)lst.get(2));
                this.step = F.C1;
                this.variable = symbol;
                break;
            }
            case 4: {
                this.start = this.evalEngine.evalWithoutNumericReset((IExpr)lst.get(1));
                this.maxCount = this.evalEngine.evalWithoutNumericReset((IExpr)lst.get(2));
                this.step = this.evalEngine.evalWithoutNumericReset((IExpr)lst.get(3));
                this.variable = symbol;
                break;
            }
            default: {
                this.maxCount = null;
                this.step = null;
                this.variable = null;
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.maxCount == null) {
            return false;
        }
        if (!(this.step instanceof ISignedNumber)) {
            return false;
        }
        return ((ISignedNumber)this.step).isNegative() ? this.evalEngine.evaluate(F.LessEqual(this.maxCount, this.count)) == F.True : this.evalEngine.evaluate(F.LessEqual(this.count, this.maxCount)) == F.True;
    }

    @Override
    public IExpr next() {
        if (this.variable != null) {
            this.variable.set(this.count);
        }
        IExpr temp = this.count;
        this.count = this.evalEngine.evaluate(F.Plus(this.count, this.step));
        return temp;
    }

    @Override
    public boolean setUp() {
        if (!(this.step instanceof ISignedNumber)) {
            return false;
        }
        if (((ISignedNumber)this.step).isNegative() ? this.evalEngine.evaluate(F.Less(this.start, this.maxCount)) == F.True : this.evalEngine.evaluate(F.Less(this.maxCount, this.start)) == F.True) {
            return false;
        }
        this.count = this.start;
        if (this.variable != null) {
            this.variable.pushLocalVariable(this.count);
        }
        return true;
    }

    @Override
    public void tearDown() {
        if (this.variable != null) {
            this.variable.popLocalVariable();
        }
        EvalEngine.get().setNumericMode(this.fNumericMode);
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

