/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Options {
    private IAST fDefaultOptionsList;
    private IAST fCurrentOptionsList;

    public Options(ISymbol symbol, IAST currentOptionsList, int startIndex) {
        IExpr temp = F.eval(F.Options(symbol));
        this.fDefaultOptionsList = temp != null && temp instanceof IAST && temp.isList() ? (IAST)temp : null;
        this.fCurrentOptionsList = null;
        if (currentOptionsList != null && startIndex < currentOptionsList.size()) {
            this.fCurrentOptionsList = F.List();
            int i = startIndex;
            while (i < currentOptionsList.size()) {
                this.fCurrentOptionsList.add(1, (IExpr)currentOptionsList.get(i));
                ++i;
            }
        }
    }

    public IExpr getOption(String optionString) {
        IAST rule = null;
        if (this.fCurrentOptionsList != null) {
            try {
                int i = 1;
                while (i < this.fCurrentOptionsList.size()) {
                    rule = (IAST)this.fCurrentOptionsList.get(i);
                    if (rule.isRuleAST() && ((IExpr)rule.get(1)).toString().equals(optionString)) {
                        return (IExpr)rule.get(2);
                    }
                    ++i;
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        if (this.fDefaultOptionsList != null) {
            try {
                int i = 1;
                while (i < this.fDefaultOptionsList.size()) {
                    rule = (IAST)this.fDefaultOptionsList.get(i);
                    if (rule.isRuleAST() && ((IExpr)rule.get(1)).toString().equals(optionString)) {
                        return (IExpr)rule.get(2);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public IAST replaceAll(IAST options) {
        IAST result = options.clone();
        if (this.fCurrentOptionsList != null) {
            result = (IAST)F.eval(F.ReplaceAll(result, this.fCurrentOptionsList));
        }
        if (this.fDefaultOptionsList != null) {
            result = (IAST)F.eval(F.ReplaceAll(result, this.fDefaultOptionsList));
        }
        return result;
    }
}

