/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import edu.jas.structure.ElemFactory;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.expression.ASTCopy;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.StringX;
import org.matheclipse.core.expression.Symbol;
import org.matheclipse.core.generic.IsUnaryVariableOrPattern;
import org.matheclipse.core.generic.UnaryVariable2Slot;
import org.matheclipse.core.generic.util.NestedFastTable;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;
import org.matheclipse.core.visit.VisitorReplaceAll;
import org.matheclipse.generic.interfaces.BiFunction;

public class AST
extends NestedFastTable<IExpr>
implements IAST {
    private static final IAST AST_DUMMY_INSTANCE = new AST();
    public static final ASTCopy COPY = new ASTCopy(AST_DUMMY_INSTANCE.getClass());
    private static final long serialVersionUID = 4295200630292148027L;
    private transient int fEvalFlags = 0;
    protected transient int fPatternMatchingHashValue = 0;

    public static AST parse(String inputString) {
        StringTokenizer tokenizer = new StringTokenizer(inputString, "[],", true);
        AST list = AST.newInstance(null);
        String token = tokenizer.nextToken();
        list.setHeader(StringX.valueOf(token));
        token = tokenizer.nextToken();
        if (token.equals("[")) {
            AST.parseList(tokenizer, list);
            return list;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseList(StringTokenizer tokenizer, AST list) {
        String token = tokenizer.nextToken();
        do {
            block8: {
                AST argList;
                String arg;
                if (token.equals("]")) {
                    return;
                }
                if (token.equals(",")) {
                    arg = tokenizer.nextToken();
                    token = tokenizer.nextToken();
                    if (token.equals("[")) {
                        argList = AST.newInstance(null);
                        argList.setHeader(StringX.valueOf(arg));
                        AST.parseList(tokenizer, argList);
                        list.add(argList);
                        break block8;
                    } else {
                        list.add(StringX.valueOf(arg));
                        continue;
                    }
                }
                if (!token.equals(" ")) {
                    arg = token;
                    token = tokenizer.nextToken();
                    if (token.equals("[")) {
                        argList = AST.newInstance(null);
                        argList.setHeader(StringX.valueOf(arg));
                        AST.parseList(tokenizer, argList);
                        list.add(argList);
                    } else {
                        list.add(StringX.valueOf(arg));
                        continue;
                    }
                }
            }
            token = tokenizer.nextToken();
        } while (tokenizer.hasMoreTokens());
    }

    private AST(int initialCapacity, boolean setLength) {
        super(initialCapacity + 1, setLength ? initialCapacity + 1 : 0);
    }

    public AST() {
        super(0);
    }

    @Override
    public IAST clone() {
        AST ast = (AST)super.clone();
        ast.fEvalFlags = 0;
        ast.fPatternMatchingHashValue = 0;
        return ast;
    }

    public boolean equalsFromPosition(int from0, AST f1, int from1) {
        if (this.size() - from0 != f1.size() - from1) {
            return false;
        }
        int j = from1;
        int i = from0;
        while (i < this.size() - 1) {
            if (!((IExpr)this.get(i + 1)).equals(f1.get(1 + j++))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public ISymbol topHead() {
        if (this.head() instanceof ISymbol) {
            return (ISymbol)this.head();
        }
        if (this.head() instanceof IAST) {
            return ((IAST)this.head()).topHead();
        }
        if (this.head() instanceof ISignedNumber) {
            if (this.head() instanceof INum) {
                return F.RealHead;
            }
            if (this.head() instanceof IInteger) {
                return F.IntegerHead;
            }
            if (this.head() instanceof IFraction) {
                return F.RationalHead;
            }
        }
        if (this.head() instanceof IComplex) {
            return F.ComplexHead;
        }
        if (this.head() instanceof IComplexNum) {
            return F.ComplexHead;
        }
        if (this.head() instanceof IPattern) {
            return F.PatternHead;
        }
        if (this.head() instanceof IStringX) {
            return F.StringHead;
        }
        return null;
    }

    @Override
    public int hierarchy() {
        return 256;
    }

    @Override
    public boolean isLTOrdered(IExpr obj) {
        return this.compareTo(obj) < 0;
    }

    @Override
    public boolean isLEOrdered(IExpr obj) {
        return this.compareTo(obj) <= 0;
    }

    @Override
    public boolean isGTOrdered(IExpr obj) {
        return this.compareTo(obj) > 0;
    }

    @Override
    public boolean isGEOrdered(IExpr obj) {
        return this.compareTo(obj) >= 0;
    }

    @Override
    public int getEvalFlags() {
        return this.fEvalFlags;
    }

    @Override
    public void setEvalFlags(int i) {
        this.fEvalFlags = i;
    }

    @Override
    public void addEvalFlags(int i) {
        this.fEvalFlags |= i;
    }

    @Override
    public boolean isEvalFlagOn(int i) {
        return (this.fEvalFlags & i) == i;
    }

    @Override
    public boolean isEvalFlagOff(int i) {
        return (this.fEvalFlags & i) == 0;
    }

    public IExpr opposite() {
        return F.function(F.Times, (IExpr)F.CN1, (IExpr)this);
    }

    @Override
    public IExpr plus(IExpr that) {
        return F.function(F.Plus, (IExpr)this, that);
    }

    @Override
    public IExpr inverse() {
        return F.function(F.Power, (IExpr)this, (IExpr)F.CN1);
    }

    @Override
    public IExpr times(IExpr that) {
        return F.function(F.Times, (IExpr)this, that);
    }

    @Override
    public boolean isList() {
        return ((IExpr)this.head()).equals(F.List);
    }

    @Override
    public boolean isListOfLists() {
        if (((IExpr)this.head()).equals(F.List)) {
            int i = 2;
            while (i < this.size()) {
                if (!((IExpr)this.get(i)).isList()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isPlus() {
        return this.size() >= 3 && ((IExpr)this.head()).equals(F.Plus);
    }

    @Override
    public boolean isPower() {
        return this.size() == 3 && ((IExpr)this.head()).equals(F.Power);
    }

    @Override
    public boolean isTimes() {
        return this.size() >= 3 && ((IExpr)this.head()).equals(F.Times);
    }

    @Override
    public boolean isSin() {
        return this.size() == 2 && ((IExpr)this.head()).equals(F.Sin);
    }

    @Override
    public boolean isCos() {
        return this.size() == 2 && ((IExpr)this.head()).equals(F.Cos);
    }

    @Override
    public boolean isTan() {
        return this.size() == 2 && ((IExpr)this.head()).equals(F.Tan);
    }

    @Override
    public boolean isArcSin() {
        return this.size() == 2 && ((IExpr)this.head()).equals(F.ArcSin);
    }

    @Override
    public boolean isArcCos() {
        return this.size() == 2 && ((IExpr)this.head()).equals(F.ArcCos);
    }

    @Override
    public boolean isArcTan() {
        return this.size() == 2 && ((IExpr)this.head()).equals(F.ArcTan);
    }

    @Override
    public boolean isSinh() {
        return this.size() == 2 && ((IExpr)this.head()).equals(F.Sinh);
    }

    @Override
    public boolean isCosh() {
        return this.size() == 2 && ((IExpr)this.head()).equals(F.Cosh);
    }

    @Override
    public boolean isTanh() {
        return this.size() == 2 && ((IExpr)this.head()).equals(F.Tanh);
    }

    @Override
    public boolean isArcSinh() {
        return this.size() == 2 && ((IExpr)this.head()).equals(F.ArcSinh);
    }

    @Override
    public boolean isArcCosh() {
        return this.size() == 2 && ((IExpr)this.head()).equals(F.ArcCosh);
    }

    @Override
    public boolean isArcTanh() {
        return this.size() == 2 && ((IExpr)this.head()).equals(F.ArcTanh);
    }

    @Override
    public boolean isLog() {
        return this.size() == 2 && ((IExpr)this.head()).equals(F.Log);
    }

    @Override
    public boolean isOne() {
        return false;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean isTrue() {
        return false;
    }

    @Override
    public boolean isFalse() {
        return false;
    }

    @Override
    public boolean isSame(IExpr expression) {
        return this.equals(expression);
    }

    @Override
    public boolean isSame(IExpr expression, double epsilon) {
        return this.equals(expression);
    }

    @Override
    public int[] isMatrix() {
        if (this.isEvalFlagOn(32)) {
            int[] dim = new int[]{this.size() - 1, ((IAST)this.get(1)).size() - 1};
            return dim;
        }
        if (((IExpr)this.head()).equals(F.List)) {
            int[] dim = new int[]{this.size() - 1, 0};
            if (dim[0] > 0) {
                if (((IExpr)this.get(1)).isList()) {
                    dim[1] = ((IAST)this.get(1)).size() - 1;
                    int i = 2;
                    while (i < this.size()) {
                        if (!((IExpr)this.get(i)).isList()) {
                            return null;
                        }
                        if (dim[1] != ((IAST)this.get(i)).size() - 1) {
                            return null;
                        }
                        ++i;
                    }
                } else {
                    return null;
                }
            }
            this.addEvalFlags(32);
            return dim;
        }
        return null;
    }

    @Override
    public int isVector() {
        if (this.isEvalFlagOn(64)) {
            return this.size() - 1;
        }
        if (((IExpr)this.head()).equals(F.List)) {
            int dim = this.size() - 1;
            if (dim > 0) {
                if (((IExpr)this.get(1)).isList()) {
                    return -1;
                }
                int i = 2;
                while (i < this.size()) {
                    if (((IExpr)this.get(i)).isList()) {
                        return -1;
                    }
                    ++i;
                }
            }
            this.addEvalFlags(64);
            return dim;
        }
        return -1;
    }

    @Override
    public boolean isFraction() {
        return false;
    }

    @Override
    public boolean isSymbol() {
        return false;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isSignedNumber() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public IAST apply(IExpr head) {
        IAST ast = this.clone();
        ast.setHeader(head);
        return ast;
    }

    @Override
    public IAST apply(IExpr head, int start) {
        return this.apply(head, start, this.size());
    }

    @Override
    public IAST apply(IExpr head, int start, int end) {
        IAST ast = F.ast(head);
        int i = start;
        while (i < end) {
            ast.add((IExpr)this.get(i));
            ++i;
        }
        return ast;
    }

    @Override
    public IExpr apply(List<? extends IExpr> leaves) {
        IAST ast = F.ast((IExpr)this.head());
        int i = 0;
        while (i < leaves.size()) {
            ast.add(leaves.get(i));
            ++i;
        }
        return ast;
    }

    @Override
    public IExpr apply(IExpr ... leaves) {
        IAST ast = F.ast((IExpr)this.head());
        int i = 0;
        while (i < leaves.length) {
            ast.add(leaves[i]);
            ++i;
        }
        return ast;
    }

    @Override
    public IAST map(Function<IExpr, IExpr> function) {
        IAST f = this.clone();
        int i = 1;
        while (i < this.size()) {
            IExpr temp = (IExpr)function.apply((Object)((IExpr)this.get(i)));
            if (temp != null) {
                f.set(i, temp);
            }
            ++i;
        }
        return f;
    }

    @Override
    public IAST map(IAST resultAST, IAST secondAST, BiFunction<IExpr, IExpr, IExpr> function) {
        int i = 1;
        while (i < this.size()) {
            resultAST.add(function.apply((IExpr)this.get(i), (IExpr)secondAST.get(i)));
            ++i;
        }
        return resultAST;
    }

    @Override
    public IExpr replaceAll(IAST astRules) {
        return this.accept(new VisitorReplaceAll(astRules));
    }

    @Override
    public IExpr replaceAll(Function<IExpr, IExpr> function) {
        return this.accept(new VisitorReplaceAll(function));
    }

    @Override
    public IExpr replaceRepeated(IAST astRules) {
        return ExprImpl.replaceRepeated(this, new VisitorReplaceAll(astRules));
    }

    @Override
    public IExpr replaceRepeated(Function<IExpr, IExpr> function) {
        return ExprImpl.replaceRepeated(this, new VisitorReplaceAll(function));
    }

    @Override
    public boolean isAST() {
        return true;
    }

    @Override
    public boolean isAST(IExpr header) {
        return ((IExpr)this.get(0)).equals(header);
    }

    @Override
    public boolean isAST(IExpr header, int size) {
        return this.size() == size && ((IExpr)this.get(0)).equals(header);
    }

    @Override
    public boolean isASTSizeGE(IExpr header, int size) {
        return this.size() >= size && ((IExpr)this.get(0)).equals(header);
    }

    @Override
    public boolean isAST(String symbol) {
        return ((IExpr)this.get(0)).toString().equals(symbol);
    }

    @Override
    public boolean isAST(String symbol, int size) {
        return this.size() == size && ((IExpr)this.get(0)).toString().equals(symbol);
    }

    @Override
    public boolean isRuleAST() {
        return this.size() == 3 && (((IExpr)this.head()).equals(F.Rule) || ((IExpr)this.head()).equals(F.RuleDelayed));
    }

    @Override
    public boolean isFree(IExpr pattern) {
        PatternMatcher matcher = new PatternMatcher(pattern);
        return !COPY.some(this, matcher, 1);
    }

    @Override
    public boolean isFree(Predicate<IExpr> predicate) {
        return !COPY.some(this, predicate, 1);
    }

    private int compareToTimes(AST ast) {
        IExpr astHeader = (IExpr)ast.head();
        if (astHeader == F.Power) {
            IExpr lastTimes = (IExpr)this.get(this.size() - 1);
            if (!(lastTimes instanceof IAST)) {
                int cp = lastTimes.compareTo((IExpr)ast.get(1));
                if (cp != 0) {
                    return cp;
                }
                return F.C1.compareTo((IExpr)ast.get(2));
            }
            IExpr lastTimesHeader = ((IAST)lastTimes).head();
            if (lastTimesHeader == F.Power && ((IAST)lastTimes).size() == 3) {
                int cp = ((IExpr)((IAST)lastTimes).get(1)).compareTo((IExpr)ast.get(1));
                if (cp != 0) {
                    return cp;
                }
                cp = ((IExpr)((IAST)lastTimes).get(2)).compareTo((IExpr)ast.get(2));
                if (cp != 0) {
                    return cp;
                }
                return 1;
            }
            int cp = lastTimes.compareTo((IExpr)ast.get(1));
            if (cp != 0) {
                return cp;
            }
            return F.C1.compareTo((IExpr)ast.get(2));
        }
        if (astHeader == F.Times) {
            int i1;
            int i0 = this.size();
            int commonArgCounter = i0 > (i1 = ast.size()) ? i1 : i0;
            while (--commonArgCounter > 0) {
                int cp;
                if ((cp = ((IExpr)this.get(--i0)).compareTo((IExpr)ast.get(--i1))) == 0) continue;
                return cp;
            }
            return this.size() - ast.size();
        }
        return this.compareToAST(ast);
    }

    @Override
    public int compareTo(IExpr expr) {
        if (expr instanceof AST) {
            AST ast = (AST)expr;
            if (this.size() > 2 && ast.size() > 2) {
                if (this.head() == F.Times) {
                    return this.compareToTimes((AST)expr);
                }
                if (ast.head() == F.Times) {
                    return -1 * ast.compareToTimes(this);
                }
            }
            return this.compareToAST(ast);
        }
        if (expr instanceof Symbol) {
            return -1 * ((Symbol)expr).compareTo(this);
        }
        return this.hierarchy() - expr.hierarchy();
    }

    private int compareToAST(AST ast) {
        int cp = ((IExpr)this.head()).compareTo((IExpr)ast.head());
        if (cp != 0) {
            return cp;
        }
        int commonArgSize = this.size() > ast.size() ? ast.size() : this.size();
        int i = 1;
        while (i < commonArgSize) {
            cp = ((IExpr)this.get(i)).compareTo((IExpr)ast.get(i));
            if (cp != 0) {
                return cp;
            }
            ++i;
        }
        return this.size() - ast.size();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AST) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.fHash == 0) {
            this.fHash = this.size() > 1 ? 31 * ((IExpr)this.get(0)).hashCode() + ((IExpr)this.get(1)).hashCode() + this.size() : (this.size() == 1 ? 17 * ((IExpr)this.get(0)).hashCode() : 41);
        }
        return this.fHash;
    }

    @Override
    public final int patternHashCode() {
        if (this.fPatternMatchingHashValue == 0) {
            int attr;
            this.fPatternMatchingHashValue = this.size() > 1 ? ((attr = this.topHead().getAttributes() & 0xC) != 0 ? (attr == 12 ? 17 * ((IExpr)this.get(0)).hashCode() : (attr == 8 ? (this.get(1) instanceof IAST ? 31 * ((IExpr)this.get(0)).hashCode() + ((IExpr)((IAST)this.get(1)).get(0)).hashCode() : 37 * ((IExpr)this.get(0)).hashCode() + ((IExpr)this.get(1)).hashCode()) : 17 * ((IExpr)this.get(0)).hashCode() + this.size())) : (this.get(1) instanceof IAST ? 31 * ((IExpr)this.get(0)).hashCode() + ((IExpr)((IAST)this.get(1)).get(0)).hashCode() + this.size() : 37 * ((IExpr)this.get(0)).hashCode() + ((IExpr)this.get(1)).hashCode() + this.size())) : (this.size() == 1 ? 17 * ((IExpr)this.get(0)).hashCode() : 41);
        }
        return this.fPatternMatchingHashValue;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public IAST copyHead() {
        return AST.newInstance((IExpr)this.get(0));
    }

    @Override
    public IAST copyUntil(int index) {
        return AST.newInstance(this, index);
    }

    @Override
    public IExpr variables2Slots(Map<IExpr, IExpr> map, List<IExpr> variableList) {
        return COPY.replaceAll(this, new IsUnaryVariableOrPattern(), new UnaryVariable2Slot(map, variableList));
    }

    @Override
    public String fullFormString() {
        String sep = ", ";
        IExpr temp = (IExpr)this.head();
        StringBuffer text = new StringBuffer();
        text.append(temp.fullFormString());
        text.append('[');
        int i = 1;
        while (i < this.size()) {
            text.append(((IExpr)this.get(i)).fullFormString());
            if (i < this.size() - 1) {
                text.append(", ");
            }
            ++i;
        }
        text.append(']');
        return text.toString();
    }

    @Override
    public String internalFormString(boolean callSymbolFactory) {
        ISymbol sym;
        String sep = ",";
        IExpr temp = (IExpr)this.head();
        StringBuffer text = new StringBuffer(this.size() * 10);
        if (temp instanceof ISymbol && !Character.isUpperCase((sym = (ISymbol)temp).toString().charAt(0))) {
            text.append("$(");
            int i = 0;
            while (i < this.size()) {
                text.append(((IExpr)this.get(i)).internalFormString(callSymbolFactory));
                if (i < this.size() - 1) {
                    text.append(",");
                }
                ++i;
            }
            text.append(')');
            return text.toString();
        }
        text.append(temp.internalFormString(false));
        text.append('(');
        int i = 1;
        while (i < this.size()) {
            text.append(((IExpr)this.get(i)).internalFormString(callSymbolFactory));
            if (i < this.size() - 1) {
                text.append(",");
            }
            ++i;
        }
        text.append(')');
        return text.toString();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.size() > 0 && this.isAST(F.List)) {
            buf.append('{');
            int i = 1;
            while (i < this.size()) {
                buf.append(this.get(i) == this ? "(this AST)" : String.valueOf(this.get(i)));
                if (i < this.size() - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append('}');
            return buf.toString();
        }
        if (this.isAST(F.Slot, 2) && this.get(1) instanceof IInteger) {
            int slot;
            block8: {
                try {
                    slot = ((IInteger)this.get(1)).toInt();
                    if (slot <= 0) {
                        return super.toString();
                    }
                    if (slot != 1) break block8;
                    return "#";
                }
                catch (ArithmeticException arithmeticException) {
                    return super.toString();
                }
            }
            return "#" + slot;
        }
        return super.toString();
    }

    @Override
    public ASTRange args() {
        return new ASTRange(this, 1);
    }

    @Override
    public ASTRange range() {
        return new ASTRange(this, 0, this.size());
    }

    @Override
    public ASTRange range(int start) {
        return new ASTRange(this, start, this.size());
    }

    @Override
    public ASTRange range(int start, int end) {
        return new ASTRange(this, start, end);
    }

    public static AST newInstance(int intialCapacity, IExpr head) {
        AST ast = new AST(intialCapacity + 1, false);
        ast.add(head);
        return ast;
    }

    public static AST newInstance(IExpr head) {
        AST ast = new AST(5, false);
        ast.add(head);
        return ast;
    }

    public static AST newInstance(IAST ast, int index) {
        AST result = new AST(5, false);
        int i = 0;
        while (i < index) {
            ast.add((IExpr)ast.get(i));
            ++i;
        }
        return result;
    }

    public static AST newInstance(ISymbol symbol, int[] arr) {
        AST ast = new AST(5, false);
        ast.add(symbol);
        int i = 1;
        while (i <= arr.length) {
            ast.add(i, IntegerSym.valueOf(arr[i - 1]));
            ++i;
        }
        return ast;
    }

    public static AST newInstance(ISymbol symbol, double[] arr) {
        AST ast = new AST(5, false);
        ast.add(symbol);
        int i = 1;
        while (i <= arr.length) {
            ast.add(i, Num.valueOf(arr[i - 1]));
            ++i;
        }
        return ast;
    }

    public static AST newInstance(ISymbol symbol, double[][] matrix) {
        AST ast = new AST(5, false);
        ast.add(symbol);
        int i = 1;
        while (i <= matrix.length) {
            AST row = AST.newInstance(F.List, matrix[i - 1]);
            ast.add(i, row);
            ++i;
        }
        return ast;
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public final IExpr negative() {
        return this.opposite();
    }

    @Override
    public IExpr minus(IExpr that) {
        return F.function(F.Plus, (IExpr)this, (IExpr)F.function(F.Times, (IExpr)F.CN1, that));
    }

    @Override
    public final IExpr multiply(IExpr that) {
        return this.times(that);
    }

    @Override
    public final IExpr power(Integer n) {
        return F.function(F.Power, (IExpr)this, (IExpr)F.integer(n.intValue()));
    }

    @Override
    public final IExpr power(IExpr that) {
        return F.function(F.Power, (IExpr)this, that);
    }

    @Override
    public IExpr div(IExpr that) {
        return F.eval(F.function(F.Times, (IExpr)this, (IExpr)F.function(F.Power, that, (IExpr)F.CN1)));
    }

    @Override
    public IExpr mod(IExpr that) {
        return F.function(F.Mod, (IExpr)this, that);
    }

    @Override
    public IExpr and(IExpr that) {
        return F.function(F.And, (IExpr)this, that);
    }

    @Override
    public IExpr or(IExpr that) {
        return F.function(F.Or, (IExpr)this, that);
    }

    @Override
    public IExpr getAt(int index) {
        return (IExpr)this.get(index);
    }

    @Override
    public Object asType(Class clazz) {
        if (clazz.equals(Boolean.class)) {
            IExpr temp = F.eval(this);
            if (temp.equals(F.True)) {
                return Boolean.TRUE;
            }
            if (temp.equals(F.False)) {
                return Boolean.FALSE;
            }
        } else if (clazz.equals(Integer.class)) {
            IExpr temp = F.eval(this);
            if (temp instanceof IntegerSym) {
                return ((IInteger)((Object)this)).toInt();
            }
        } else if (clazz.equals(BigInteger.class)) {
            IExpr temp = F.eval(this);
            if (temp instanceof IntegerSym) {
                return new apache.harmony.math.BigInteger(((IntegerSym)temp).toByteArray());
            }
        } else if (clazz.equals(String.class)) {
            return this.toString();
        }
        throw new UnsupportedOperationException("AST.asType() - cast not supported.");
    }

    @Override
    public IInteger getInt(int index) {
        if (this.get(index) instanceof IInteger) {
            return (IInteger)this.get(index);
        }
        throw new WrongArgumentType(this, (IExpr)this.get(index), index);
    }

    @Override
    public INumber getNumber(int index) {
        if (this.get(index) instanceof INumber) {
            return (INumber)this.get(index);
        }
        throw new WrongArgumentType(this, (IExpr)this.get(index), index);
    }

    @Override
    public IAST getAST(int index) {
        if (this.get(index) instanceof IAST) {
            return (IAST)this.get(index);
        }
        throw new WrongArgumentType(this, (IExpr)this.get(index), index);
    }

    @Override
    public IAST getList(int index) {
        if (((IExpr)this.get(index)).isList()) {
            return (IAST)this.get(index);
        }
        throw new WrongArgumentType(this, (IExpr)this.get(index), index);
    }

    @Override
    public List<IExpr> leaves() {
        int sz = this.size();
        if (sz < 2) {
            return Collections.EMPTY_LIST;
        }
        return this.subList(1, sz);
    }

    public IExpr[] egcd(IExpr b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IExpr gcd(IExpr b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IExpr abs() {
        if (this instanceof INumber) {
            return ((INumber)((Object)this)).eabs();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isZERO() {
        return this.isZero();
    }

    @Override
    public int signum() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IExpr subtract(IExpr that) {
        return this.plus((IExpr)that.negate());
    }

    @Override
    public IExpr sum(IExpr that) {
        return this.plus(that);
    }

    @Override
    public ElemFactory<IExpr> factory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toScript() {
        return this.toString();
    }

    @Override
    public String toScriptFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IExpr divide(IExpr that) {
        return this.div(that);
    }

    @Override
    public boolean isONE() {
        return this.isOne();
    }

    @Override
    public boolean isUnit() {
        return this.isOne();
    }

    @Override
    public IExpr remainder(IExpr S) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IExpr negate() {
        return this.opposite();
    }
}

