/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import apache.harmony.math.BigInteger;
import apache.harmony.math.Rational;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.FractionSym;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;

public class ComplexSym
extends ExprImpl
implements IComplex {
    private static final long serialVersionUID = 1489050560741527824L;
    private Rational _real;
    private Rational _imaginary;
    public static final ComplexSym ZERO = ComplexSym.valueOf(Rational.ZERO);

    private ComplexSym() {
    }

    public static ComplexSym valueOf(BigInteger real, BigInteger imaginary) {
        ComplexSym c = new ComplexSym();
        c._real = Rational.valueOf(real, BigInteger.ONE);
        c._imaginary = Rational.valueOf(imaginary, BigInteger.ONE);
        return c;
    }

    public static ComplexSym valueOf(BigInteger real) {
        ComplexSym c = new ComplexSym();
        c._real = Rational.valueOf(real, BigInteger.ONE);
        c._imaginary = Rational.ZERO;
        return c;
    }

    public static ComplexSym valueOf(IInteger real, IInteger imaginary) {
        ComplexSym c = new ComplexSym();
        c._real = Rational.valueOf(real.getBigNumerator(), BigInteger.ONE);
        c._imaginary = Rational.valueOf(imaginary.getBigNumerator(), BigInteger.ONE);
        return c;
    }

    public static ComplexSym valueOf(IInteger real) {
        ComplexSym c = new ComplexSym();
        c._real = Rational.valueOf(real.getBigNumerator(), BigInteger.ONE);
        c._imaginary = Rational.ZERO;
        return c;
    }

    public static ComplexSym valueOf(Rational real) {
        ComplexSym c = new ComplexSym();
        c._real = real;
        c._imaginary = Rational.ZERO;
        return c;
    }

    public static ComplexSym valueOf(Rational real, Rational imaginary) {
        ComplexSym c = new ComplexSym();
        c._real = real;
        c._imaginary = imaginary;
        return c;
    }

    public static ComplexSym valueOf(long real_numerator, long real_denominator, long imag_numerator, long imag_denominator) {
        ComplexSym c = new ComplexSym();
        c._real = Rational.valueOf(real_numerator, real_denominator);
        c._imaginary = Rational.valueOf(imag_numerator, imag_denominator);
        return c;
    }

    public static ComplexSym valueOf(IFraction real) {
        ComplexSym c = new ComplexSym();
        c._real = real.getRational();
        c._imaginary = Rational.ZERO;
        return c;
    }

    public static ComplexSym valueOf(IFraction real, IFraction imaginary) {
        ComplexSym c = new ComplexSym();
        c._real = real.getRational();
        c._imaginary = imaginary.getRational();
        return c;
    }

    @Override
    public IComplex conjugate() {
        return ComplexSym.valueOf(this._real, this._imaginary.opposite());
    }

    @Override
    public IExpr eabs() {
        return F.Sqrt(FractionSym.valueOf(this._real.times(this._real).plus(this._imaginary.times(this._imaginary))));
    }

    public ComplexSym add(ComplexSym parm1) throws ArithmeticException {
        return ComplexSym.valueOf(this._real.plus(parm1._real), this._imaginary.plus(parm1._imaginary));
    }

    @Override
    public IComplex add(IComplex parm1) {
        return ComplexSym.valueOf(this._real.plus(parm1.getRealPart()), this._imaginary.plus(parm1.getImaginaryPart()));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ComplexSym) {
            return this._real.equals(((ComplexSym)obj)._real) && this._imaginary.equals(((ComplexSym)obj)._imaginary);
        }
        return false;
    }

    @Override
    public Rational getImaginaryPart() {
        return this._imaginary;
    }

    @Override
    public IFraction getIm() {
        return FractionSym.valueOf(this._imaginary);
    }

    @Override
    public Rational getRealPart() {
        return this._real;
    }

    @Override
    public IFraction getRe() {
        return FractionSym.valueOf(this._real);
    }

    @Override
    public int hashCode() {
        return this._real.hashCode() ^ this._imaginary.hashCode();
    }

    @Override
    public int hierarchy() {
        return 32;
    }

    @Override
    public boolean isZero() {
        return NumberUtil.isZero(this._real) && NumberUtil.isZero(this._imaginary);
    }

    @Override
    public IComplex multiply(IComplex parm1) {
        return ComplexSym.valueOf(this._real.times(parm1.getRealPart()).minus(this._imaginary.times(parm1.getImaginaryPart())), this._real.times(parm1.getImaginaryPart()).plus(parm1.getRealPart().times(this._imaginary)));
    }

    @Override
    public IComplex pow(int parm1) {
        int temp = parm1;
        if (parm1 == 0 && this._real.equals(Rational.ZERO) && this._imaginary.equals(Rational.ZERO)) {
            throw new ArithmeticException();
        }
        if (parm1 == 1) {
            return this;
        }
        IComplex res = ComplexSym.valueOf(Rational.ONE, Rational.ZERO);
        if (parm1 < 0) {
            temp *= -1;
        }
        int i = 0;
        while (i < temp) {
            res = res.multiply(this);
            ++i;
        }
        if (parm1 < 0) {
            Rational d = res.getRealPart().times(res.getRealPart()).plus(res.getImaginaryPart().times(res.getImaginaryPart()));
            return ComplexSym.valueOf(res.getRealPart().divide(d), res.getImaginaryPart().opposite().divide(d));
        }
        return res;
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof ComplexSym) {
            return this.add((ComplexSym)that);
        }
        return super.plus(that);
    }

    @Override
    public IExpr opposite() {
        return ComplexSym.valueOf(this._real.opposite(), this._imaginary.opposite());
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof ComplexSym) {
            return this.multiply((ComplexSym)that);
        }
        return super.times(that);
    }

    @Override
    public IExpr reciprocal() {
        Rational tmp = this._real.times(this._real).plus(this._imaginary.times(this._imaginary));
        return ComplexSym.valueOf(this._real.divide(tmp), this._imaginary.opposite().divide(tmp));
    }

    public ComplexSym copyNew() {
        ComplexSym r = new ComplexSym();
        r._real = this._real.copyNew();
        r._imaginary = this._imaginary.copyNew();
        return r;
    }

    public String toString() {
        StringBuilder tb = new StringBuilder();
        tb.append('(');
        tb.append(this._real.toString());
        tb.append(")+I*(");
        tb.append(this._imaginary.toString());
        tb.append(')');
        return tb.toString();
    }

    @Override
    public String fullFormString() {
        StringBuffer buf = new StringBuffer("Complex[");
        if (this._real.getDenominator().equals(BigInteger.ONE)) {
            buf.append(this._real.getNumerator().toString());
        } else {
            buf.append("Rational[");
            buf.append(this._real.getNumerator().toString().toString());
            buf.append(',');
            buf.append(this._real.getDenominator().toString().toString());
            buf.append(']');
        }
        buf.append(',');
        if (this._imaginary.getDenominator().equals(BigInteger.ONE)) {
            buf.append(this._imaginary.getNumerator().toString());
        } else {
            buf.append("Rational[");
            buf.append(this._imaginary.getNumerator().toString().toString());
            buf.append(',');
            buf.append(this._imaginary.getDenominator().toString().toString());
            buf.append(']');
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public String internalFormString(boolean callSymbolFactory) {
        int real_numerator = this._real.getNumerator().toInt();
        int real_denominator = this._real.getDenominator().toInt();
        int imag_numerator = this._imaginary.getNumerator().toInt();
        int imag_denominator = this._imaginary.getDenominator().toInt();
        if (this._real.equals(Rational.ZERO)) {
            if (this._imaginary.equals(Rational.ONE)) {
                return "CI";
            }
            if (this._imaginary.equals(Rational.MINUS_ONE)) {
                return "CNI";
            }
        }
        return "complex(" + real_numerator + "L," + real_denominator + "L," + imag_numerator + "L," + imag_denominator + "L)";
    }

    @Override
    public INumber normalize() {
        if (this._imaginary.equals(Rational.ZERO)) {
            if (this._real.getDenominator().equals(BigInteger.ZERO)) {
                return IntegerSym.valueOf(this._real.getNumerator());
            }
            return FractionSym.newInstance(this._real);
        }
        return this;
    }

    @Override
    public int complexSign() {
        int i = this._real.getNumerator().signum();
        if (i == 0) {
            return this._imaginary.getNumerator().signum();
        }
        return i;
    }

    public static void main(String[] args) {
        ComplexSym c = ComplexSym.valueOf(BigInteger.ZERO, BigInteger.ONE);
        IExpr e = c.times(c);
        System.out.println(e);
    }

    @Override
    public int compareTo(IExpr obj) {
        if (obj instanceof ComplexSym) {
            int cp = this._real.compareTo(((ComplexSym)obj)._real);
            if (cp != 0) {
                return cp;
            }
            return this._imaginary.compareTo(((ComplexSym)obj)._imaginary);
        }
        return this.hierarchy() - obj.hierarchy();
    }

    @Override
    public ISymbol head() {
        return F.ComplexHead;
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsInt(int i) {
        return false;
    }
}

