/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.parser.client.math.MathUtils;

public class ComplexUtils {
    private ComplexUtils() {
    }

    public static ComplexNum acos(ComplexNum z) {
        if (z.isNaN()) {
            return ComplexNum.NaN;
        }
        return ComplexNum.I.negate().multiply(ComplexUtils.log(z.add(ComplexNum.I.multiply(ComplexUtils.sqrt1z(z)))));
    }

    public static ComplexNum asin(ComplexNum z) {
        if (z.isNaN()) {
            return ComplexNum.NaN;
        }
        return ComplexNum.I.negate().multiply(ComplexUtils.log(ComplexUtils.sqrt1z(z).add(ComplexNum.I.multiply(z))));
    }

    public static ComplexNum atan(ComplexNum z) {
        if (z.isNaN()) {
            return ComplexNum.NaN;
        }
        return ComplexNum.I.multiply(ComplexUtils.log(ComplexNum.I.add(z).divide(ComplexNum.I.subtract(z)))).divide(ComplexNum.valueOf(2.0, 0.0));
    }

    public static ComplexNum cos(ComplexNum z) {
        if (z.isNaN()) {
            return ComplexNum.NaN;
        }
        double a = z.getReal();
        double b = z.getImaginary();
        return ComplexNum.valueOf(Math.cos(a) * MathUtils.cosh(b), -Math.sin(a) * MathUtils.sinh(b));
    }

    public static ComplexNum cosh(ComplexNum z) {
        if (z.isNaN()) {
            return ComplexNum.NaN;
        }
        double a = z.getReal();
        double b = z.getImaginary();
        return ComplexNum.valueOf(MathUtils.cosh(a) * Math.cos(b), MathUtils.sinh(a) * Math.sin(b));
    }

    public static ComplexNum exp(ComplexNum z) {
        if (z.isNaN()) {
            return ComplexNum.NaN;
        }
        double b = z.getImaginary();
        double expA = Math.exp(z.getReal());
        return ComplexNum.valueOf(expA * Math.cos(b), expA * Math.sin(b));
    }

    public static ComplexNum log(ComplexNum z) {
        if (z.isNaN()) {
            return ComplexNum.NaN;
        }
        return ComplexNum.valueOf(Math.log(z.dabs()), Math.atan2(z.getImaginary(), z.getReal()));
    }

    public static ComplexNum polar2Complex(double r, double theta) {
        if (r < 0.0) {
            throw new IllegalArgumentException("DoubleComplexImpl modulus must not be negative");
        }
        return ComplexNum.valueOf(r * Math.cos(theta), r * Math.sin(theta));
    }

    public static ComplexNum pow(ComplexNum y, ComplexNum x) {
        return ComplexUtils.exp(x.multiply(ComplexUtils.log(y)));
    }

    public static ComplexNum sin(ComplexNum z) {
        if (z.isNaN()) {
            return ComplexNum.NaN;
        }
        double a = z.getReal();
        double b = z.getImaginary();
        return ComplexNum.valueOf(Math.sin(a) * MathUtils.cosh(b), Math.cos(a) * MathUtils.sinh(b));
    }

    public static ComplexNum sinh(ComplexNum z) {
        if (z.isNaN()) {
            return ComplexNum.NaN;
        }
        double a = z.getReal();
        double b = z.getImaginary();
        return ComplexNum.valueOf(MathUtils.sinh(a) * Math.cos(b), MathUtils.cosh(a) * Math.sin(b));
    }

    public static ComplexNum sqrt(ComplexNum z) {
        if (z.isNaN()) {
            return ComplexNum.NaN;
        }
        double a = z.getReal();
        double b = z.getImaginary();
        double t = Math.sqrt((Math.abs(a) + z.dabs()) / 2.0);
        if (a >= 0.0) {
            return ComplexNum.valueOf(t, b / (2.0 * t));
        }
        return ComplexNum.valueOf(Math.abs(b) / (2.0 * t), MathUtils.indicator(b) * t);
    }

    public static ComplexNum sqrt1z(ComplexNum z) {
        return ComplexUtils.sqrt(ComplexNum.ONE.subtract(z.multiply(z)));
    }

    public static ComplexNum tan(ComplexNum z) {
        if (z.isNaN()) {
            return ComplexNum.NaN;
        }
        double a2 = 2.0 * z.getReal();
        double b2 = 2.0 * z.getImaginary();
        double d = Math.cos(a2) + MathUtils.cosh(b2);
        return ComplexNum.valueOf(Math.sin(a2) / d, MathUtils.sinh(b2) / d);
    }

    public static ComplexNum tanh(ComplexNum z) {
        if (z.isNaN()) {
            return ComplexNum.NaN;
        }
        double a2 = 2.0 * z.getReal();
        double b2 = 2.0 * z.getImaginary();
        double d = MathUtils.cosh(a2) + Math.cos(b2);
        return ComplexNum.valueOf(MathUtils.sinh(a2) / d, Math.sin(b2) / d);
    }
}

