/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.matheclipse.core.expression.ExprField;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;

public class ExprFieldElement
implements FieldElement<ExprFieldElement>,
Comparable<ExprFieldElement> {
    private final IExpr val;

    public ExprFieldElement(IExpr v) {
        this.val = v;
    }

    public final IExpr getExpr() {
        return this.val;
    }

    @Override
    public ExprFieldElement divide(ExprFieldElement a) throws ArithmeticException {
        if (this.val.isAtom() && a.val.isAtom()) {
            return new ExprFieldElement(this.val.div(a.val));
        }
        return new ExprFieldElement(F.evalExpandAll(this.val.div(a.val)));
    }

    @Override
    public Field<ExprFieldElement> getField() {
        return ExprField.CONST;
    }

    @Override
    public ExprFieldElement subtract(ExprFieldElement a) {
        if (this.val.isAtom() && a.val.isAtom()) {
            return new ExprFieldElement(this.val.minus(a.val));
        }
        return new ExprFieldElement(F.evalExpandAll(this.val.minus(a.val)));
    }

    @Override
    public ExprFieldElement add(ExprFieldElement a) {
        if (this.val.isAtom() && a.val.isAtom()) {
            return new ExprFieldElement(this.val.plus(a.val));
        }
        return new ExprFieldElement(F.evalExpandAll(this.val.plus(a.val)));
    }

    @Override
    public ExprFieldElement multiply(ExprFieldElement a) {
        if (this.val.isAtom() && a.val.isAtom()) {
            return new ExprFieldElement(this.val.times(a.val));
        }
        return new ExprFieldElement(F.evalExpandAll(this.val.times(a.val)));
    }

    @Override
    public int compareTo(ExprFieldElement o) {
        return this.val.compareTo(o.val);
    }
}

