/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import apache.harmony.math.BigInteger;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import edu.jas.structure.ElemFactory;
import java.util.List;
import java.util.Map;
import org.matheclipse.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.visit.VisitorReplaceAll;

public abstract class ExprImpl
implements IExpr {
    public IExpr opposite() {
        return F.function(F.Times, (IExpr)F.CN1, (IExpr)this);
    }

    @Override
    public final IExpr negative() {
        return this.opposite();
    }

    @Override
    public IExpr minus(IExpr that) {
        return F.function(F.Plus, (IExpr)this, (IExpr)F.function(F.Times, (IExpr)F.CN1, that));
    }

    @Override
    public IExpr plus(IExpr that) {
        return F.function(F.Plus, (IExpr)this, that);
    }

    @Override
    public IExpr inverse() {
        return F.function(F.Power, (IExpr)this, (IExpr)F.CN1);
    }

    @Override
    public IExpr times(IExpr that) {
        return F.function(F.Times, (IExpr)this, that);
    }

    @Override
    public final IExpr multiply(IExpr that) {
        return this.times(that);
    }

    @Override
    public final IExpr power(Integer n) {
        return F.function(F.Power, (IExpr)this, (IExpr)F.integer(n.intValue()));
    }

    @Override
    public final IExpr power(IExpr that) {
        return F.function(F.Power, (IExpr)this, that);
    }

    @Override
    public IExpr div(IExpr that) {
        return F.eval(F.function(F.Times, (IExpr)this, (IExpr)F.function(F.Power, that, (IExpr)F.CN1)));
    }

    @Override
    public IExpr mod(IExpr that) {
        return F.function(F.Mod, (IExpr)this, that);
    }

    @Override
    public IExpr and(IExpr that) {
        return F.function(F.And, (IExpr)this, that);
    }

    @Override
    public IExpr or(IExpr that) {
        return F.function(F.Or, (IExpr)this, that);
    }

    @Override
    public IExpr getAt(int index) {
        return F.function(F.Part, (IExpr)this, (IExpr)F.integer(index));
    }

    @Override
    public Object asType(Class clazz) {
        if (clazz.equals(Boolean.class)) {
            if (this.equals(F.True)) {
                return Boolean.TRUE;
            }
            if (this.equals(F.False)) {
                return Boolean.FALSE;
            }
        } else if (clazz.equals(Integer.class)) {
            if (this instanceof IInteger) {
                return ((IInteger)((Object)this)).toInt();
            }
        } else if (clazz.equals(java.math.BigInteger.class)) {
            if (this instanceof IntegerSym) {
                return new BigInteger(((IntegerSym)this).toByteArray());
            }
        } else if (clazz.equals(String.class)) {
            return this.toString();
        }
        throw new UnsupportedOperationException("ExprImpl.asType() - cast not supported.");
    }

    @Override
    public abstract ISymbol head();

    @Override
    public ISymbol topHead() {
        return this.head();
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public boolean isListOfLists() {
        return false;
    }

    @Override
    public boolean isTrue() {
        return false;
    }

    @Override
    public boolean isFalse() {
        return false;
    }

    @Override
    public boolean isSame(IExpr expression) {
        return this.isSame(expression, Config.DOUBLE_EPSILON);
    }

    @Override
    public boolean isSame(IExpr expression, double epsilon) {
        return this.equals(expression);
    }

    @Override
    public int[] isMatrix() {
        return null;
    }

    @Override
    public int isVector() {
        return -1;
    }

    @Override
    public boolean isAST() {
        return false;
    }

    @Override
    public boolean isAST(IExpr header) {
        return false;
    }

    @Override
    public boolean isAST(IExpr header, int sz) {
        return false;
    }

    @Override
    public boolean isASTSizeGE(IExpr header, int size) {
        return false;
    }

    @Override
    public boolean isAST(String symbol) {
        return false;
    }

    @Override
    public boolean isAST(String symbol, int size) {
        return false;
    }

    @Override
    public boolean isPlus() {
        return false;
    }

    @Override
    public boolean isPower() {
        return false;
    }

    @Override
    public boolean isRuleAST() {
        return false;
    }

    @Override
    public boolean isTimes() {
        return false;
    }

    @Override
    public boolean isSin() {
        return false;
    }

    @Override
    public boolean isCos() {
        return false;
    }

    @Override
    public boolean isTan() {
        return false;
    }

    @Override
    public boolean isArcSin() {
        return false;
    }

    @Override
    public boolean isArcCos() {
        return false;
    }

    @Override
    public boolean isArcTan() {
        return false;
    }

    @Override
    public boolean isSinh() {
        return false;
    }

    @Override
    public boolean isCosh() {
        return false;
    }

    @Override
    public boolean isTanh() {
        return false;
    }

    @Override
    public boolean isArcSinh() {
        return false;
    }

    @Override
    public boolean isArcCosh() {
        return false;
    }

    @Override
    public boolean isArcTanh() {
        return false;
    }

    @Override
    public boolean isLog() {
        return false;
    }

    @Override
    public boolean isOne() {
        return false;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean isFree(IExpr pattern) {
        PatternMatcher matcher = new PatternMatcher(pattern);
        return !AST.COPY.some(this, matcher, 1);
    }

    @Override
    public boolean isFree(Predicate<IExpr> predicate) {
        return !AST.COPY.some(this, predicate, 1);
    }

    @Override
    public boolean isSymbol() {
        return this instanceof ISymbol;
    }

    @Override
    public boolean isComplex() {
        return this instanceof IComplex;
    }

    @Override
    public boolean isFraction() {
        return this instanceof IFraction;
    }

    @Override
    public boolean isInteger() {
        return this instanceof IInteger;
    }

    @Override
    public boolean isSignedNumber() {
        return this instanceof ISignedNumber;
    }

    @Override
    public boolean isNumber() {
        return this instanceof INumber;
    }

    @Override
    public boolean isLTOrdered(IExpr obj) {
        return this.compareTo(obj) < 0;
    }

    @Override
    public boolean isLEOrdered(IExpr obj) {
        return this.compareTo(obj) <= 0;
    }

    @Override
    public boolean isGTOrdered(IExpr obj) {
        return this.compareTo(obj) > 0;
    }

    @Override
    public boolean isGEOrdered(IExpr obj) {
        return this.compareTo(obj) >= 0;
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    @Override
    public IExpr variables2Slots(Map<IExpr, IExpr> map, List<IExpr> variableList) {
        return this;
    }

    @Override
    public String fullFormString() {
        return this.toString();
    }

    @Override
    public String internalFormString(boolean callSymbolFactory) {
        return this.toString();
    }

    @Override
    public List<IExpr> leaves() {
        return null;
    }

    @Override
    public IExpr apply(List<? extends IExpr> leaves) {
        IAST ast = F.ast(this.head());
        int i = 0;
        while (i < leaves.size()) {
            ast.add(leaves.get(i));
            ++i;
        }
        return ast;
    }

    @Override
    public IExpr apply(IExpr ... leaves) {
        IAST ast = F.ast(this.head());
        int i = 0;
        while (i < leaves.length) {
            ast.add(leaves[i]);
            ++i;
        }
        return ast;
    }

    @Override
    public IExpr replaceAll(IAST astRules) {
        return this.accept(new VisitorReplaceAll(astRules));
    }

    @Override
    public IExpr replaceAll(Function<IExpr, IExpr> function) {
        return this.accept(new VisitorReplaceAll(function));
    }

    @Override
    public IExpr replaceRepeated(IAST astRules) {
        return ExprImpl.replaceRepeated(this, new VisitorReplaceAll(astRules));
    }

    @Override
    public IExpr replaceRepeated(Function<IExpr, IExpr> function) {
        return ExprImpl.replaceRepeated(this, new VisitorReplaceAll(function));
    }

    public static IExpr replaceRepeated(IExpr expr, VisitorReplaceAll visitor) {
        IExpr result = expr;
        IExpr temp = expr.accept(visitor);
        int iterationLimit = EvalEngine.get().getIterationLimit();
        int iterationCounter = 1;
        while (temp != null) {
            result = temp;
            temp = result.accept(visitor);
            if (iterationLimit < 0 || iterationLimit > ++iterationCounter) continue;
            IterationLimitExceeded.throwIt(iterationCounter, result);
        }
        return result;
    }

    public IExpr[] egcd(IExpr b) {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public IExpr gcd(IExpr b) {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public IExpr abs() {
        if (this instanceof INumber) {
            return ((INumber)((Object)this)).eabs();
        }
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public boolean isZERO() {
        return this.isZero();
    }

    @Override
    public int signum() {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public IExpr subtract(IExpr that) {
        return this.plus((IExpr)that.negate());
    }

    @Override
    public IExpr sum(IExpr that) {
        return this.plus(that);
    }

    @Override
    public ElemFactory<IExpr> factory() {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public String toScript() {
        return this.toString();
    }

    @Override
    public String toScriptFactory() {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public IExpr divide(IExpr that) {
        return this.div(that);
    }

    @Override
    public boolean isONE() {
        return this.isOne();
    }

    @Override
    public boolean isUnit() {
        return this.isOne();
    }

    @Override
    public IExpr remainder(IExpr S) {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public IExpr negate() {
        throw new UnsupportedOperationException(this.toString());
    }
}

