/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import apache.harmony.math.BigInteger;
import apache.harmony.math.Rational;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.matheclipse.basic.Config;
import org.matheclipse.core.convert.Object2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.Namespace;
import org.matheclipse.core.eval.SystemNamespace;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.ComplexSym;
import org.matheclipse.core.expression.FractionSym;
import org.matheclipse.core.expression.ISymbolObserver;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.expression.MethodSymbol;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.Pattern;
import org.matheclipse.core.expression.StringX;
import org.matheclipse.core.expression.Symbol;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.reflection.system.Package;

public class F {
    private static final HashMap<String, ISymbol> fSymbolMap = new HashMap();
    public static ISymbolObserver SYMBOL_OBSERVER = new ISymbolObserver(){

        @Override
        public final boolean createPredefinedSymbol(String symbol) {
            return false;
        }

        @Override
        public void createUserSymbol(ISymbol symbol) {
        }
    };
    public static ISymbol Abs;
    public static ISymbol And;
    public static ISymbol Append;
    public static ISymbol Apart;
    public static ISymbol Apply;
    public static ISymbol ArcCos;
    public static ISymbol ArcSin;
    public static ISymbol ArcTan;
    public static ISymbol ArcCosh;
    public static ISymbol ArcSinh;
    public static ISymbol ArcTanh;
    public static ISymbol AtomQ;
    public static ISymbol Binomial;
    public static ISymbol Break;
    public static ISymbol Ceiling;
    public static ISymbol Complex;
    public static ISymbol CompoundExpression;
    public static ISymbol Condition;
    public static ISymbol Continue;
    public static ISymbol Cos;
    public static ISymbol Cosh;
    public static ISymbol Cross;
    public static ISymbol D;
    public static ISymbol Denominator;
    public static ISymbol Depth;
    public static ISymbol Derivative;
    public static ISymbol Det;
    public static ISymbol Dot;
    public static ISymbol Equal;
    public static ISymbol EvenQ;
    public static ISymbol Expand;
    public static ISymbol ExpandAll;
    public static ISymbol Factor;
    public static ISymbol Factorial;
    public static ISymbol FactorInteger;
    public static ISymbol Fibonacci;
    public static ISymbol FindRoot;
    public static ISymbol Floor;
    public static ISymbol FreeQ;
    public static ISymbol FullForm;
    public static ISymbol Function;
    public static ISymbol GCD;
    public static ISymbol Greater;
    public static ISymbol GreaterEqual;
    public static ISymbol Head;
    public static ISymbol Hold;
    public static ISymbol If;
    public static ISymbol IntegerQ;
    public static ISymbol Integrate;
    public static ISymbol Inverse;
    public static ISymbol Length;
    public static ISymbol Less;
    public static ISymbol LessEqual;
    public static ISymbol Level;
    public static ISymbol Map;
    public static ISymbol MapAll;
    public static ISymbol MatrixPower;
    public static ISymbol Max;
    public static ISymbol MemberQ;
    public static ISymbol Min;
    public static ISymbol Mod;
    public static ISymbol N;
    public static ISymbol Numerator;
    public static ISymbol Negative;
    public static ISymbol NonNegative;
    public static ISymbol Not;
    public static ISymbol NumberQ;
    public static ISymbol OddQ;
    public static ISymbol Or;
    public static ISymbol Order;
    public static ISymbol OrderedQ;
    public static ISymbol Part;
    public static ISymbol Plot;
    public static ISymbol Plot3D;
    public static ISymbol Plus;
    public static ISymbol Positive;
    public static ISymbol Power;
    public static ISymbol Prepend;
    public static ISymbol PrimeQ;
    public static ISymbol Print;
    public static ISymbol Product;
    public static ISymbol Quotient;
    public static ISymbol Rational;
    public static ISymbol RootOf;
    public static ISymbol ReplaceAll;
    public static ISymbol Reverse;
    public static ISymbol RotateLeft;
    public static ISymbol RotateRight;
    public static ISymbol Rule;
    public static ISymbol RuleDelayed;
    public static ISymbol Set;
    public static ISymbol SetAttributes;
    public static ISymbol SetDelayed;
    public static ISymbol Sign;
    public static ISymbol SignCmp;
    public static ISymbol Sin;
    public static ISymbol Sinh;
    public static ISymbol Sort;
    public static ISymbol Sum;
    public static ISymbol Tan;
    public static ISymbol Tanh;
    public static ISymbol Times;
    public static ISymbol Timing;
    public static ISymbol Together;
    public static ISymbol Tr;
    public static ISymbol Trace;
    public static ISymbol Transpose;
    public static ISymbol TrueQ;
    public static ISymbol Trunc;
    public static ISymbol Unequal;
    public static ISymbol While;
    public static IInteger C0;
    public static IInteger C1;
    public static IInteger C2;
    public static IInteger C3;
    public static IInteger C4;
    public static IInteger C5;
    public static IComplex CI;
    public static IComplex CNI;
    public static IFraction C1D2;
    public static IFraction CN1D2;
    public static IFraction C1D3;
    public static IFraction CN1D3;
    public static IFraction C1D4;
    public static IFraction CN1D4;
    public static INum CD0;
    public static INum CD1;
    public static IAST CInfinity;
    public static IAST CNInfinity;
    public static IInteger CN1;
    public static ISymbol ComplexInfinity;
    public static ISymbol Constant;
    public static ISymbol DirectedInfinity;
    public static ISymbol False;
    public static ISymbol Flat;
    public static ISymbol HoldAll;
    public static ISymbol HoldFirst;
    public static ISymbol HoldRest;
    public static ISymbol Indeterminate;
    public static ISymbol Infinity;
    public static ISymbol Line;
    public static ISymbol Limit;
    public static ISymbol List;
    public static ISymbol Listable;
    public static ISymbol NHoldAll;
    public static ISymbol NHoldFirst;
    public static ISymbol NHoldRest;
    public static ISymbol Null;
    public static ISymbol NumericFunction;
    public static ISymbol OneIdentity;
    public static ISymbol Orderless;
    public static ISymbol E;
    public static ISymbol Pi;
    public static ISymbol Log;
    public static ISymbol True;
    public static ISymbol Second;
    public static ISymbol BoxRatios;
    public static ISymbol MeshRange;
    public static ISymbol PlotRange;
    public static ISymbol AxesStyle;
    public static ISymbol Automatic;
    public static ISymbol AxesOrigin;
    public static ISymbol Axes;
    public static ISymbol Background;
    public static ISymbol White;
    public static ISymbol Slot;
    public static ISymbol Options;
    public static ISymbol Graphics;
    public static ISymbol SurfaceGraphics;
    public static ISymbol Show;
    public static ISymbol IntegerHead;
    public static ISymbol RationalHead;
    public static ISymbol SymbolHead;
    public static ISymbol RealHead;
    public static ISymbol ComplexHead;
    public static ISymbol PatternHead;
    public static ISymbol BlankHead;
    public static ISymbol StringHead;
    public static ISymbol MethodHead;
    private static boolean isSystemInitialized;

    static {
        isSystemInitialized = false;
    }

    public static IAST Abs(IExpr a0) {
        return F.unary(Abs, a0);
    }

    public static IAST ArcCos(IExpr a0) {
        return F.unary(ArcCos, a0);
    }

    public static IAST Append(IExpr a0) {
        return F.unary(Append, a0);
    }

    public static IAST Apart(IExpr a0) {
        return F.unary(Apart, a0);
    }

    public static IAST Apply(IExpr a0, IExpr a1) {
        return F.binary(Apply, a0, a1);
    }

    public static IAST ArcSin(IExpr a0) {
        return F.unary(ArcSin, a0);
    }

    public static IAST ArcTan(IExpr a0) {
        return F.unary(ArcTan, a0);
    }

    public static IAST ArcTan(IExpr a0, IExpr a1) {
        return F.binary(ArcTan, a0, a1);
    }

    public static IAST CNInfinity() {
        return F.binary(Times, CN1, Infinity);
    }

    public static IAST Condition(IExpr a0, IExpr a1) {
        return F.binary(Condition, a0, a1);
    }

    public static IAST Cos(IExpr a0) {
        return F.unary(Cos, a0);
    }

    public static IAST Cosh(IExpr a0) {
        return F.unary(Cosh, a0);
    }

    public static IAST Cross(IExpr a0, IExpr a1) {
        return F.binary(Cross, a0, a1);
    }

    public static IAST D() {
        return F.function(D);
    }

    public static IAST D(IExpr a0, IExpr a1) {
        return F.binary(D, a0, a1);
    }

    public static IAST Denominator(IExpr a0) {
        return F.unary(Denominator, a0);
    }

    public static IAST Depth(IExpr a0) {
        return F.unary(Depth, a0);
    }

    public static IAST Det(IExpr a0) {
        return F.unary(Det, a0);
    }

    public static IAST Divide(IExpr a0, IExpr a1) {
        return F.binary(Times, a0, F.binary(Power, a1, CN1));
    }

    public static IAST Dot(IExpr a0, IExpr a1) {
        return F.binary(Dot, a0, a1);
    }

    public static IAST Dot(IExpr ... a) {
        return F.ast(a, Dot);
    }

    public static IAST Equal(IExpr a0, IExpr a1) {
        return F.binary(Equal, a0, a1);
    }

    public static IAST Equal(IExpr ... a) {
        return F.ast(a, Equal);
    }

    public static IAST Expand(IExpr a0) {
        return F.unary(Expand, a0);
    }

    public static IAST ExpandAll(IExpr a0) {
        return F.unary(ExpandAll, a0);
    }

    public static IAST Factor(IExpr a0) {
        return F.unary(Factor, a0);
    }

    public static IAST Factorial(IExpr a0) {
        return F.unary(Factorial, a0);
    }

    public static IAST Fibonacci(IExpr a0) {
        return F.unary(Fibonacci, a0);
    }

    public static IAST FreeQ(IExpr a0) {
        return F.unary(FreeQ, a0);
    }

    public static IAST FullForm(IExpr a0) {
        return F.unary(FullForm, a0);
    }

    public static IAST GCD(IExpr a0, IExpr a1) {
        return F.binary(GCD, a0, a1);
    }

    public static IAST Graphics() {
        return F.function(Graphics);
    }

    public static IAST Hold(IExpr a0) {
        return F.unary(Hold, a0);
    }

    public static IAST Numerator(IExpr a0) {
        return F.unary(Numerator, a0);
    }

    public static synchronized void initSymbols() {
        F.initSymbols(null, null, false);
    }

    public static synchronized void initSymbols(String fileName) {
        F.initSymbols(fileName, null, false);
    }

    public static synchronized void initSymbols(String fileName, ISymbolObserver symbolObserver, boolean noPackageLoading) {
        if (!isSystemInitialized) {
            isSystemInitialized = true;
            C0 = IntegerSym.valueOf(0L);
            C1 = IntegerSym.valueOf(1L);
            C2 = IntegerSym.valueOf(2L);
            C3 = IntegerSym.valueOf(3L);
            C4 = IntegerSym.valueOf(4L);
            C5 = IntegerSym.valueOf(5L);
            CN1 = IntegerSym.valueOf(-1L);
            C1D2 = FractionSym.valueOf(1L, 2L);
            C1D3 = FractionSym.valueOf(1L, 3L);
            C1D4 = FractionSym.valueOf(1L, 4L);
            CN1D2 = FractionSym.valueOf(-1L, 2L);
            CN1D3 = FractionSym.valueOf(-1L, 3L);
            CN1D4 = FractionSym.valueOf(-1L, 4L);
            CI = ComplexSym.valueOf(BigInteger.ZERO, BigInteger.ONE);
            CNI = ComplexSym.valueOf(BigInteger.ZERO, BigInteger.MINUS_ONE);
            CD0 = Num.valueOf(0.0);
            CD1 = Num.valueOf(1.0);
            Set = F.predefinedSymbol("Set");
            SetDelayed = F.predefinedSymbol("SetDelayed");
            List = F.predefinedSymbol("List");
            Log = F.predefinedSymbol("Log");
            True = F.predefinedSymbol("True");
            False = F.predefinedSymbol("False");
            Null = F.predefinedSymbol("Null");
            E = F.predefinedSymbol("E");
            Pi = F.predefinedSymbol("Pi");
            Second = F.predefinedSymbol("Second");
            Indeterminate = F.predefinedSymbol("Indeterminate");
            Infinity = F.predefinedSymbol("Infinity");
            ComplexInfinity = F.predefinedSymbol("ComplexInfinity");
            DirectedInfinity = F.predefinedSymbol("DirectedInfinity");
            Listable = F.predefinedSymbol("Listable");
            Constant = F.predefinedSymbol("Constant");
            NumericFunction = F.predefinedSymbol("NumericFunction");
            Orderless = F.predefinedSymbol("Orderless");
            OneIdentity = F.predefinedSymbol("OneIdentity");
            Flat = F.predefinedSymbol("Flat");
            HoldFirst = F.predefinedSymbol("HoldFirst");
            HoldRest = F.predefinedSymbol("HoldRest");
            HoldAll = F.predefinedSymbol("HoldAll");
            NHoldFirst = F.predefinedSymbol("NHoldFirst");
            NHoldRest = F.predefinedSymbol("NHoldRest");
            NHoldAll = F.predefinedSymbol("NHoldAll");
            Line = F.predefinedSymbol("Line");
            BoxRatios = F.predefinedSymbol("BoxRatios");
            MeshRange = F.predefinedSymbol("MeshRange");
            PlotRange = F.predefinedSymbol("PlotRange");
            AxesStyle = F.predefinedSymbol("AxesStyle");
            Automatic = F.predefinedSymbol("Automatic");
            AxesOrigin = F.predefinedSymbol("AxesOrigin");
            Axes = F.predefinedSymbol("Axes");
            Background = F.predefinedSymbol("Background");
            White = F.predefinedSymbol("White");
            IntegerHead = F.predefinedSymbol("Integer");
            RationalHead = F.predefinedSymbol("Rational");
            SymbolHead = F.predefinedSymbol("Symbol");
            RealHead = F.predefinedSymbol("Real");
            ComplexHead = F.predefinedSymbol("Complex");
            PatternHead = F.predefinedSymbol("Pattern");
            BlankHead = F.predefinedSymbol("Blank");
            StringHead = F.predefinedSymbol("String");
            MethodHead = F.predefinedSymbol("MethodHead");
            Slot = F.predefinedSymbol("Slot");
            Options = F.predefinedSymbol("Options");
            Graphics = F.predefinedSymbol("Graphics");
            ReplaceAll = F.predefinedSymbol("ReplaceAll");
            Show = F.predefinedSymbol("Show");
            SurfaceGraphics = F.predefinedSymbol("SurfaceGraphics");
            Abs = F.predefinedSymbol("Abs");
            And = F.predefinedSymbol("And");
            Append = F.predefinedSymbol("Append");
            Apart = F.predefinedSymbol("Apart");
            Apply = F.predefinedSymbol("Apply");
            ArcCos = F.predefinedSymbol("ArcCos");
            ArcSin = F.predefinedSymbol("ArcSin");
            ArcTan = F.predefinedSymbol("ArcTan");
            ArcCosh = F.predefinedSymbol("ArcCosh");
            ArcSinh = F.predefinedSymbol("ArcSinh");
            ArcTanh = F.predefinedSymbol("ArcTanh");
            AtomQ = F.predefinedSymbol("AtomQ");
            Binomial = F.predefinedSymbol("Binomial");
            Break = F.predefinedSymbol("Break");
            Ceiling = F.predefinedSymbol("Ceil");
            CompoundExpression = F.predefinedSymbol("CompoundExpression");
            Condition = F.predefinedSymbol("Condition");
            Continue = F.predefinedSymbol("Continue");
            Cos = F.predefinedSymbol("Cos");
            Cosh = F.predefinedSymbol("Cosh");
            Cross = F.predefinedSymbol("Cross");
            D = F.predefinedSymbol("D");
            Denominator = F.predefinedSymbol("Denominator");
            Derivative = F.predefinedSymbol("Derivative");
            Det = F.predefinedSymbol("Det");
            Dot = F.predefinedSymbol("Dot");
            Equal = F.predefinedSymbol("Equal");
            EvenQ = F.predefinedSymbol("EvenQ");
            Expand = F.predefinedSymbol("Expand");
            ExpandAll = F.predefinedSymbol("ExpandAll");
            Factor = F.predefinedSymbol("Factor");
            Factorial = F.predefinedSymbol("Factorial");
            FactorInteger = F.predefinedSymbol("FactorInteger");
            Fibonacci = F.predefinedSymbol("Fibonacci");
            FindRoot = F.predefinedSymbol("FindRoot");
            Floor = F.predefinedSymbol("Floor");
            FreeQ = F.predefinedSymbol("FreeQ");
            FullForm = F.predefinedSymbol("FullForm");
            Function = F.predefinedSymbol("Function");
            GCD = F.predefinedSymbol("GCD");
            Greater = F.predefinedSymbol("Greater");
            GreaterEqual = F.predefinedSymbol("GreaterEqual");
            Head = F.predefinedSymbol("Head");
            Hold = F.predefinedSymbol("Hold");
            If = F.predefinedSymbol("If");
            IntegerQ = F.predefinedSymbol("IntegerQ");
            Integrate = F.predefinedSymbol("Integrate");
            Inverse = F.predefinedSymbol("Inverse");
            Length = F.predefinedSymbol("Length");
            Less = F.predefinedSymbol("Less");
            LessEqual = F.predefinedSymbol("LessEqual");
            Level = F.predefinedSymbol("Level");
            Limit = F.predefinedSymbol("Limit");
            Map = F.predefinedSymbol("Map");
            MapAll = F.predefinedSymbol("MapAll");
            MatrixPower = F.predefinedSymbol("MatrixPower");
            Max = F.predefinedSymbol("Max");
            MemberQ = F.predefinedSymbol("MemberQ");
            Min = F.predefinedSymbol("Min");
            Mod = F.predefinedSymbol("Mod");
            N = F.predefinedSymbol("N");
            Negative = F.predefinedSymbol("Negative");
            NonNegative = F.predefinedSymbol("NonNegative");
            Not = F.predefinedSymbol("Not");
            NumberQ = F.predefinedSymbol("NumberQ");
            Numerator = F.predefinedSymbol("Numerator");
            OddQ = F.predefinedSymbol("OddQ");
            Or = F.predefinedSymbol("Or");
            Order = F.predefinedSymbol("Order");
            OrderedQ = F.predefinedSymbol("OrderedQ");
            Part = F.predefinedSymbol("Part");
            Plot = F.predefinedSymbol("Plot");
            Plot3D = F.predefinedSymbol("Plot3D");
            Plus = F.predefinedSymbol("Plus");
            Plus.setDefaultValue(C0);
            Positive = F.predefinedSymbol("Positive");
            Power = F.predefinedSymbol("Power");
            Power.setDefaultValue(2, C1);
            Prepend = F.predefinedSymbol("Prepend");
            PrimeQ = F.predefinedSymbol("PrimeQ");
            Print = F.predefinedSymbol("Print");
            Product = F.predefinedSymbol("Product");
            Quotient = F.predefinedSymbol("Quotient");
            Reverse = F.predefinedSymbol("Reverse");
            RootOf = F.predefinedSymbol("RootOf");
            RotateLeft = F.predefinedSymbol("RotateLeft");
            RotateRight = F.predefinedSymbol("RotateRight");
            Rule = F.predefinedSymbol("Rule");
            RuleDelayed = F.predefinedSymbol("RuleDelayed");
            SetAttributes = F.predefinedSymbol("SetAttributes");
            Sign = F.predefinedSymbol("Sign");
            SignCmp = F.predefinedSymbol("SignCmp");
            Sin = F.predefinedSymbol("Sin");
            Sinh = F.predefinedSymbol("Sinh");
            Sort = F.predefinedSymbol("Sort");
            Sum = F.predefinedSymbol("Sum");
            Tan = F.predefinedSymbol("Tan");
            Tanh = F.predefinedSymbol("Tanh");
            Times = F.predefinedSymbol("Times");
            Times.setDefaultValue(C1);
            Timing = F.predefinedSymbol("Timing");
            Together = F.predefinedSymbol("Together");
            Tr = F.predefinedSymbol("Tr");
            Trace = F.predefinedSymbol("Trace");
            Transpose = F.predefinedSymbol("Transpose");
            TrueQ = F.predefinedSymbol("TrueQ");
            Trunc = F.predefinedSymbol("Trunc");
            Unequal = F.predefinedSymbol("Unequal");
            While = F.predefinedSymbol("While");
            CInfinity = F.function(DirectedInfinity, (IExpr)C1);
            CNInfinity = F.function(DirectedInfinity, (IExpr)CN1);
            if (symbolObserver != null) {
                SYMBOL_OBSERVER = symbolObserver;
            }
            if (!noPackageLoading) {
                InputStream systemPackage;
                InputStreamReader reader = null;
                if (fileName != null) {
                    try {
                        reader = new FileReader(fileName);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                if (reader == null && (systemPackage = F.class.getResourceAsStream("/System.mep")) != null) {
                    reader = new InputStreamReader(systemPackage);
                }
                if (reader != null) {
                    Package.loadPackage(EvalEngine.get(), reader);
                }
            }
        }
    }

    public static IAST Integrate(IExpr a0, IExpr a1) {
        return F.binary(Integrate, a0, a1);
    }

    public static IAST Inverse(IExpr a0) {
        return F.unary(Inverse, a0);
    }

    public static IAST Less(IExpr a0, IExpr a1) {
        return F.binary(Less, a0, a1);
    }

    public static IAST LessEqual(IExpr a0, IExpr a1) {
        return F.binary(LessEqual, a0, a1);
    }

    public static IAST Line() {
        return F.function(Line);
    }

    public static IAST LinearSolve(IExpr a0, IExpr a1) {
        return F.binary(F.symbol("LinearSolve"), a0, a1);
    }

    public static IAST Limit(IExpr a0, IExpr a1) {
        return F.binary(Limit, a0, a1);
    }

    public static IAST List() {
        return F.function(List);
    }

    public static IAST List(IExpr a0) {
        return F.unary(List, a0);
    }

    public static IAST List(IExpr a0, IExpr a1) {
        return F.binary(List, a0, a1);
    }

    public static IAST List(double ... numbers) {
        IExpr[] a = new INum[numbers.length];
        int i = 0;
        while (i < numbers.length) {
            a[i] = F.num(numbers[i]);
            ++i;
        }
        return F.ast(a, List);
    }

    public static IAST List(long ... numbers) {
        IExpr[] a = new IInteger[numbers.length];
        int i = 0;
        while (i < numbers.length) {
            a[i] = F.integer(numbers[i]);
            ++i;
        }
        return F.ast(a, List);
    }

    public static IAST List(IExpr ... a) {
        return F.ast(a, List);
    }

    public static IAST Log(IExpr a0) {
        return F.unary(Log, a0);
    }

    public static IAST Map(IExpr a0) {
        return F.unary(Map, a0);
    }

    public static IAST MapAll(IExpr a0) {
        return F.unary(MapAll, a0);
    }

    public static IAST MatrixPower(IExpr a0) {
        return F.unary(MatrixPower, a0);
    }

    public static IAST Max() {
        return F.function(Max);
    }

    public static IAST Max(IExpr a0, IExpr a1) {
        return F.binary(Max, a0, a1);
    }

    public static IAST MemberQ(IExpr a0) {
        return F.unary(MemberQ, a0);
    }

    public static IAST Min() {
        return F.function(Min);
    }

    public static IAST Min(IExpr a0, IExpr a1) {
        return F.binary(Min, a0, a1);
    }

    public static IAST N(IExpr a0) {
        return F.unary(N, a0);
    }

    public static IAST Negate(IExpr a) {
        return F.binary(Times, CN1, a);
    }

    public static IAST NumberQ(IExpr a0) {
        return F.unary(NumberQ, a0);
    }

    public static IAST Options(IExpr a0) {
        return F.unary(Options, a0);
    }

    public static IAST Plus() {
        return F.function(Plus);
    }

    public static IAST Plus(IExpr a0) {
        return F.unary(Plus, a0);
    }

    public static IAST Plus(IExpr a0, IExpr a1) {
        return F.binary(Plus, a0, a1);
    }

    public static IAST Plus(IExpr ... a) {
        return F.ast(a, Plus);
    }

    public static IAST Power() {
        return F.function(Power);
    }

    public static IAST Power(IExpr a0, IExpr a1) {
        return F.binary(Power, a0, a1);
    }

    public static IAST Power(IExpr a0, long exp) {
        return F.binary(Power, a0, F.integer(exp));
    }

    public static IAST PowerExpand(IExpr a0) {
        return F.unary(F.symbol("PowerExpand"), a0);
    }

    public static IAST Prepend(IExpr a0) {
        return F.unary(Prepend, a0);
    }

    public static IAST PrimeQ(IExpr a0) {
        return F.unary(PrimeQ, a0);
    }

    public static IAST ReplaceAll(IExpr a0, IExpr a1) {
        return F.binary(ReplaceAll, a0, a1);
    }

    public static IAST Roots(IExpr a0) {
        return F.unary(F.symbol("Roots"), a0);
    }

    public static IAST Rule(IExpr a0, IExpr a1) {
        return F.binary(Rule, a0, a1);
    }

    public static IAST RuleDelayed(IExpr a0, IExpr a1) {
        return F.binary(RuleDelayed, a0, a1);
    }

    public static IAST Set(IExpr a0, IExpr a1) {
        return F.binary(Set, a0, a1);
    }

    public static IAST SetAttributes(IExpr a0) {
        return F.unary(SetAttributes, a0);
    }

    public static IAST SetDelayed(IExpr a0, IExpr a1) {
        return F.binary(SetDelayed, a0, a1);
    }

    public static IAST Show(IExpr a0) {
        return F.unary(Show, a0);
    }

    public static IAST Simplify(IExpr a0) {
        return F.unary(F.symbol("Simplify"), a0);
    }

    public static IAST Sin(IExpr a0) {
        return F.unary(Sin, a0);
    }

    public static IAST Sinh(IExpr a0) {
        return F.unary(Sinh, a0);
    }

    public static IAST Slot(IExpr a0) {
        return F.unary(Slot, a0);
    }

    public static IAST Slot(int i) {
        return F.unary(Slot, F.integer(i));
    }

    public static IAST Sqr(IExpr a0) {
        return F.binary(Power, a0, C2);
    }

    public static IAST Sqrt(IExpr a0) {
        return F.binary(Power, a0, C1D2);
    }

    public static IAST Subtract(IExpr a0, IExpr a1) {
        return F.binary(Plus, a0, F.binary(Times, CN1, a1));
    }

    public static IAST SurfaceGraphics() {
        return F.function(SurfaceGraphics);
    }

    public static IAST Tan(IExpr a0) {
        return F.unary(Tan, a0);
    }

    public static IAST Tanh(IExpr a0) {
        return F.unary(Tanh, a0);
    }

    public static IAST Times() {
        return F.function(Times);
    }

    public static IAST Times(IExpr a0) {
        return F.unary(Times, a0);
    }

    public static IAST Times(IExpr a0, IExpr a1) {
        return F.binary(Times, a0, a1);
    }

    public static IAST Times(IExpr ... a) {
        return F.ast(a, Times);
    }

    public static IAST Together(IExpr a0) {
        return F.unary(Together, a0);
    }

    public static IAST Tr(IExpr a0) {
        return F.unary(Tr, a0);
    }

    public static IAST Trace(IExpr a0) {
        return F.unary(Trace, a0);
    }

    public static IAST Transpose(IExpr a0) {
        return F.unary(Transpose, a0);
    }

    public static IAST ast(IAST f, IExpr head, boolean include, int first, int last) {
        AST ast = null;
        if (include) {
            ast = AST.newInstance(last - first, head);
            int i = first;
            while (i < last) {
                ast.add((IExpr)f.get(i));
                ++i;
            }
        } else {
            ast = AST.newInstance(f.size() - last + first - 1, head);
            int i = 1;
            while (i < first) {
                ast.add((IExpr)f.get(i));
                ++i;
            }
            int j = last;
            while (j < f.size()) {
                ast.add((IExpr)f.get(j));
                ++j;
            }
        }
        return ast;
    }

    public static IAST ast(IExpr head) {
        return AST.newInstance(head);
    }

    public static IAST $(IExpr head, IExpr ... a) {
        return F.ast(a, head);
    }

    public static IAST ast(IExpr head, int initialCapacity, boolean initNull) {
        AST ast = AST.newInstance(initialCapacity, head);
        if (initNull) {
            int i = 0;
            while (i < initialCapacity) {
                ast.add(null);
                ++i;
            }
        }
        return ast;
    }

    public static IAST ast(IExpr[] arr, IExpr head) {
        AST ast = AST.newInstance(arr.length, head);
        IExpr[] iExprArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            IExpr expr = iExprArray[n2];
            ast.add(expr);
            ++n2;
        }
        return ast;
    }

    public static IAST binary(IExpr head, IExpr a0, IExpr a1) {
        IAST ast = F.ast(head);
        ast.add(a0);
        ast.add(a1);
        return ast;
    }

    public static ISymbol bool(boolean value) {
        if (value) {
            return True;
        }
        return False;
    }

    public static IComplex complex(IFraction re) {
        return F.complex(re, F.fraction(0L, 1L));
    }

    public static IComplex complex(IFraction re, IFraction im) {
        return ComplexSym.valueOf(re, im);
    }

    public static IComplex complex(long real_numerator, long real_denominator, long imag_numerator, long imag_denominator) {
        return ComplexSym.valueOf(real_numerator, real_denominator, imag_numerator, imag_denominator);
    }

    public static IComplex complex(double realPart, double imagPart) {
        return ComplexSym.valueOf(FractionSym.valueOf(realPart), FractionSym.valueOf(imagPart));
    }

    public static IComplex complex(IInteger re, IInteger im) {
        return ComplexSym.valueOf(re, im);
    }

    public static IComplexNum complexNum(double r) {
        return F.complexNum(r, 0.0);
    }

    public static IComplexNum complexNum(double r, double i) {
        return ComplexNum.valueOf(r, i);
    }

    public static IExpr eval(ISymbol head, IExpr a0) {
        IAST ast = F.ast(head);
        ast.add(a0);
        return EvalEngine.eval(ast);
    }

    public static IExpr eval(ISymbol head, IExpr a0, IExpr a1) {
        IAST ast = F.ast(head);
        ast.add(a0);
        ast.add(a1);
        return EvalEngine.eval(ast);
    }

    public static IExpr eval(ISymbol head, IExpr a0, IExpr a1, IExpr a2) {
        IAST ast = F.ast(head);
        ast.add(a0);
        ast.add(a1);
        ast.add(a2);
        return EvalEngine.eval(ast);
    }

    public static IExpr evalNull(ISymbol head, IExpr a0) {
        IAST ast = F.ast(head);
        ast.add(a0);
        return EvalEngine.evalNull(ast);
    }

    public static IExpr evalNull(ISymbol head, IExpr a0, IExpr a1) {
        IAST ast = F.ast(head);
        ast.add(a0);
        ast.add(a1);
        return EvalEngine.evalNull(ast);
    }

    public static IExpr evalNull(ISymbol head, IExpr a0, IExpr a1, IExpr a2) {
        IAST ast = F.ast(head);
        ast.add(a0);
        ast.add(a1);
        ast.add(a2);
        return EvalEngine.evalNull(ast);
    }

    public static IExpr evaln(IExpr a0) {
        return F.eval(N, a0);
    }

    public static IFraction fraction(IInteger numerator, IInteger denominator) {
        return FractionSym.valueOf(numerator, denominator);
    }

    public static IFraction fraction(BigInteger numerator, BigInteger denominator) {
        return FractionSym.valueOf(numerator, denominator);
    }

    public static IFraction fraction(java.math.BigInteger jmNumeratorBig, java.math.BigInteger jmDenominatorBig) {
        return FractionSym.valueOf(new BigInteger(jmNumeratorBig.toByteArray()), new BigInteger(jmDenominatorBig.toByteArray()));
    }

    public static IFraction fraction(long numerator, long denominator) {
        return FractionSym.valueOf(numerator, denominator);
    }

    public static IFraction fraction(Rational value) {
        return FractionSym.valueOf(value);
    }

    public static IFraction fraction(double value) {
        return FractionSym.valueOf(value);
    }

    public static IAST function(IExpr head) {
        IAST list = F.ast(head);
        return list;
    }

    public static IAST function(IExpr head, IExpr arg0) {
        IAST list = F.ast(head);
        list.add(arg0);
        return list;
    }

    public static IAST function(IExpr head, IExpr arg0, IExpr arg1) {
        IAST list = F.ast(head);
        list.add(arg0);
        list.add(arg1);
        return list;
    }

    public static IAST function(ISymbol head) {
        IAST list = F.ast(head);
        return list;
    }

    public static IAST function(ISymbol head, IExpr arg0) {
        IAST list = F.ast(head);
        list.add(arg0);
        return list;
    }

    public static IAST function(ISymbol head, IExpr arg0, IExpr arg1) {
        IAST list = F.ast(head);
        list.add(arg0);
        list.add(arg1);
        return list;
    }

    public static IAST function(String head) {
        IAST list = F.ast(F.symbol(head));
        return list;
    }

    public static IAST function(String head, IExpr arg0) {
        IAST list = F.ast(F.symbol(head));
        list.add(arg0);
        return list;
    }

    public static IAST function(String head, IExpr arg0, IExpr arg1) {
        IAST list = F.ast(F.symbol(head));
        list.add(arg0);
        list.add(arg1);
        return list;
    }

    public static final Namespace getNamespace() {
        return SystemNamespace.DEFAULT;
    }

    public static IInteger integer(BigInteger integerValue) {
        return IntegerSym.valueOf(integerValue);
    }

    public static IInteger integer(java.math.BigInteger jmBig) {
        return IntegerSym.valueOf(new BigInteger(jmBig.toByteArray()));
    }

    public static IInteger integer(long integerValue) {
        return IntegerSym.valueOf(integerValue);
    }

    public static IInteger integer(String integerString, int numberFormat) {
        return IntegerSym.valueOf(integerString, numberFormat);
    }

    public static Num num(double d) {
        return Num.valueOf(d);
    }

    public static Num num(String doubleString) {
        return Num.valueOf(Double.parseDouble(doubleString));
    }

    public static IPattern pattern(ISymbol symbol) {
        if (symbol == null) {
            return Pattern.valueOf(null);
        }
        return Pattern.valueOf((Symbol)symbol);
    }

    public static IPattern pattern(ISymbol symbol, IExpr check, boolean def) {
        if (symbol == null) {
            return Pattern.valueOf(null, check, def);
        }
        return Pattern.valueOf((Symbol)symbol, check, def);
    }

    public static IPattern pattern(ISymbol symbol, IExpr check) {
        if (symbol == null) {
            return Pattern.valueOf(null, check);
        }
        return Pattern.valueOf((Symbol)symbol, check);
    }

    public static IPattern pattern(String symbolName) {
        if (symbolName == null) {
            return Pattern.valueOf(null);
        }
        return Pattern.valueOf((Symbol)F.symbol(symbolName));
    }

    public static IPattern pattern(String symbolName, IExpr check) {
        if (symbolName == null) {
            return Pattern.valueOf(null, check);
        }
        return Pattern.valueOf((Symbol)F.symbol(symbolName), check);
    }

    public static IPattern pattern(String symbolName, IExpr check, boolean def) {
        if (symbolName == null) {
            return Pattern.valueOf(null, check, def);
        }
        return Pattern.valueOf((Symbol)F.symbol(symbolName), check, def);
    }

    public static ISymbol predefinedSymbol(String symbolName) {
        ISymbol temp = fSymbolMap.get(symbolName);
        if (temp != null) {
            return temp;
        }
        temp = new Symbol(symbolName);
        fSymbolMap.put(symbolName, temp);
        return temp;
    }

    public static final IStringX stringx(String str) {
        return StringX.valueOf(str);
    }

    public static final IStringX stringx(StringBuffer str) {
        return StringX.valueOf(str);
    }

    public static ISymbol method(String symbolName, String packageName, String className, String methodName) {
        return new MethodSymbol(symbolName, packageName, className, methodName);
    }

    public static ISymbol method(String symbolName, String className, String methodName) {
        return new MethodSymbol(symbolName, className, methodName);
    }

    public static ISymbol symbol(String symbolName) {
        ISymbol symbol = fSymbolMap.get(symbolName);
        if (symbol != null) {
            return symbol;
        }
        EvalEngine engine = EvalEngine.get();
        Map<String, ISymbol> variableMap = engine.getVariableMap();
        symbol = variableMap.get(symbolName);
        if (symbol != null) {
            return symbol;
        }
        if (Config.SERVER_MODE) {
            ISymbol secondTry;
            if (Character.isUpperCase(symbolName.charAt(0)) && SYMBOL_OBSERVER.createPredefinedSymbol(symbolName) && (secondTry = fSymbolMap.get(symbolName)) != null) {
                return secondTry;
            }
            symbol = new Symbol(symbolName);
            variableMap.put(symbolName, symbol);
            if (symbolName.charAt(0) == '$') {
                SYMBOL_OBSERVER.createUserSymbol(symbol);
            }
        } else {
            symbol = new Symbol(symbolName);
            fSymbolMap.put(symbolName, symbol);
            if (Character.isUpperCase(symbolName.charAt(0))) {
                SystemNamespace.DEFAULT.setEvaluator(symbol);
            }
        }
        return symbol;
    }

    public static ISymbol local(String symbolName, IExpr value) {
        Symbol temp = new Symbol(symbolName);
        temp.pushLocalVariable(value);
        return temp;
    }

    public static ISymbol local(String symbolName) {
        return F.local(symbolName, null);
    }

    public static void popLocal(ISymbol temp) {
        temp.popLocalVariable();
    }

    public static IAST unary(IExpr head, IExpr a0) {
        IAST ast = F.ast(head);
        ast.add(a0);
        return ast;
    }

    public static IExpr plus(Integer i, IExpr b) {
        return F.function(Plus, (IExpr)F.integer(i.longValue()), b);
    }

    public static IExpr plus(IExpr a, Integer i) {
        return F.function(Plus, a, (IExpr)F.integer(i.longValue()));
    }

    public static IExpr minus(Integer i, IExpr b) {
        return F.function(Plus, (IExpr)F.integer(i.longValue()), (IExpr)F.function(Times, b, (IExpr)CN1));
    }

    public static IExpr minus(IExpr a, Integer i) {
        return F.function(Plus, a, (IExpr)F.function(Times, (IExpr)F.integer(i.longValue()), (IExpr)CN1));
    }

    public static IExpr multiply(Integer i, IExpr b) {
        return F.function(Times, (IExpr)F.integer(i.longValue()), b);
    }

    public static IExpr multiply(IExpr a, Integer i) {
        return F.function(Times, a, (IExpr)F.integer(i.longValue()));
    }

    public static IExpr div(IExpr a, Integer i) {
        return F.function(Times, a, (IExpr)F.function(Power, (IExpr)F.integer(i.longValue()), (IExpr)CN1));
    }

    public static IExpr div(Integer i, IExpr b) {
        return F.function(Times, (IExpr)F.integer(i.longValue()), (IExpr)F.function(Power, b, (IExpr)CN1));
    }

    public static IExpr mod(IExpr a, Integer i) {
        return F.function(Mod, a, (IExpr)F.integer(i.longValue()));
    }

    public static IExpr mod(Integer i, IExpr b) {
        return F.function(Mod, (IExpr)F.integer(i.longValue()), b);
    }

    public static IExpr and(IExpr a, Integer i) {
        return F.function(And, a, (IExpr)F.integer(i.longValue()));
    }

    public static IExpr and(Integer i, IExpr b) {
        return F.function(And, (IExpr)F.integer(i.longValue()), b);
    }

    public static IExpr or(IExpr a, Integer i) {
        return F.function(Or, a, (IExpr)F.integer(i.longValue()));
    }

    public static IExpr or(Integer i, IExpr b) {
        return F.function(Or, (IExpr)F.integer(i.longValue()), b);
    }

    public static boolean isCase(IExpr a, IExpr b) {
        PatternMatcher matcher;
        if (a instanceof IAST && (matcher = new PatternMatcher(a)).apply(b)) {
            matcher.setPatternValue2Local(a);
            return true;
        }
        return F.equals(a, b);
    }

    public static boolean isCase(IExpr a, Integer i) {
        return F.isCase(a, (IExpr)F.integer(i.longValue()));
    }

    public static boolean isCase(Integer i, IExpr b) {
        return F.equals(i, b);
    }

    public static boolean isCase(IExpr a, java.math.BigInteger i) {
        return F.isCase(a, (IExpr)F.integer(i));
    }

    public static boolean isCase(java.math.BigInteger i, IExpr b) {
        return F.equals(i, b);
    }

    public static boolean isZero(double value) {
        return F.isZero(value, Config.DOUBLE_EPSILON);
    }

    public static boolean isZero(double value, double epsilon) {
        return Math.abs(value) < epsilon;
    }

    public static IExpr eval(IExpr a) {
        return EvalEngine.eval(a);
    }

    public static IExpr evalExpandAll(IExpr a) {
        return EvalEngine.eval(F.ExpandAll(a));
    }

    public static IExpr evalBlock(IExpr expr, ISymbol symbol, IExpr localValue) {
        try {
            symbol.pushLocalVariable(localValue);
            IExpr iExpr = F.eval(expr);
            return iExpr;
        }
        finally {
            symbol.popLocalVariable();
        }
    }

    public static boolean evalTrue(IExpr expr) {
        return EvalEngine.get().evaluate(expr).equals(True);
    }

    public static IExpr cast(Object obj) {
        return Object2Expr.CONST.convert(obj);
    }

    public static boolean equals(IExpr a, IExpr b) {
        IExpr tempA = a;
        IExpr tempB = b;
        if (a.isAST()) {
            tempA = F.eval(a);
        }
        if (b.isAST()) {
            tempB = F.eval(b);
        }
        return tempA.equals(tempB);
    }

    public static boolean equals(IExpr a, java.math.BigInteger i) {
        IExpr tempA = a;
        IInteger tempB = F.integer(i);
        if (a.isAST()) {
            tempA = F.eval(a);
        }
        return tempA.equals(tempB);
    }

    public static boolean equals(java.math.BigInteger i, IExpr b) {
        IInteger tempA = F.integer(i);
        IExpr tempB = b;
        if (b instanceof AST) {
            tempB = F.eval(b);
        }
        return tempA.equals(tempB);
    }

    public static boolean equals(IExpr a, Integer i) {
        IExpr tempA = a;
        IInteger tempB = F.integer(i.longValue());
        if (a instanceof AST) {
            tempA = F.eval(a);
        }
        return tempA.equals(tempB);
    }

    public static boolean equals(Integer i, IExpr b) {
        IInteger tempA = F.integer(i.longValue());
        IExpr tempB = b;
        if (b instanceof AST) {
            tempB = F.eval(b);
        }
        return tempA.equals(tempB);
    }

    public static int compareTo(IExpr a, IExpr b) throws UnsupportedOperationException {
        if (a instanceof ISignedNumber && b instanceof ISignedNumber) {
            return a.compareTo(b);
        }
        IExpr tempA = F.eval(a);
        IExpr tempB = F.eval(b);
        if (tempA instanceof ISignedNumber && tempB instanceof ISignedNumber) {
            return tempA.compareTo(tempB);
        }
        throw new UnsupportedOperationException("compareTo() - first or second argument could not be converted into a signed number.");
    }

    public static int compareTo(IExpr a, Integer i) throws UnsupportedOperationException {
        if (a instanceof ISignedNumber) {
            return a.compareTo(F.integer(i.longValue()));
        }
        IExpr temp = F.eval(a);
        if (temp instanceof ISignedNumber) {
            return temp.compareTo(F.integer(i.longValue()));
        }
        throw new UnsupportedOperationException("compareTo() - first argument could not be converted into a signed number.");
    }

    public static int compareTo(Integer i, IExpr b) throws UnsupportedOperationException {
        if (b instanceof ISignedNumber) {
            return F.integer(i.longValue()).compareTo(b);
        }
        IExpr temp = F.eval(b);
        if (temp instanceof ISignedNumber) {
            return F.integer(i.longValue()).compareTo(temp);
        }
        throw new UnsupportedOperationException("compareTo() - second argument could not be converted into a signed number.");
    }

    public static int compareTo(IExpr a, java.math.BigInteger i) throws UnsupportedOperationException {
        if (a instanceof ISignedNumber) {
            return a.compareTo(F.integer(i));
        }
        IExpr temp = F.eval(a);
        if (temp instanceof ISignedNumber) {
            return temp.compareTo(F.integer(i));
        }
        throw new UnsupportedOperationException("compareTo() - first argument could not be converted into a signed number.");
    }

    public static int compareTo(java.math.BigInteger i, IExpr b) throws UnsupportedOperationException {
        if (b instanceof ISignedNumber) {
            return F.integer(i).compareTo(b);
        }
        IExpr temp = F.eval(b);
        if (temp instanceof ISignedNumber) {
            return F.integer(i).compareTo(temp);
        }
        throw new UnsupportedOperationException("compareTo() - second argument could not be converted into a signed number.");
    }

    public static IExpr plus(java.math.BigInteger i, IExpr b) {
        return F.function(Plus, (IExpr)F.integer(i), b);
    }

    public static IExpr plus(IExpr a, java.math.BigInteger i) {
        return F.function(Plus, a, (IExpr)F.integer(i));
    }

    public static IExpr minus(java.math.BigInteger i, IExpr b) {
        return F.function(Plus, (IExpr)F.integer(i), (IExpr)F.function(Times, b, (IExpr)CN1));
    }

    public static IExpr minus(IExpr a, java.math.BigInteger i) {
        return F.function(Plus, a, (IExpr)F.function(Times, (IExpr)F.integer(i), (IExpr)CN1));
    }

    public static IExpr multiply(java.math.BigInteger i, IExpr b) {
        return F.function(Times, (IExpr)F.integer(i), b);
    }

    public static IExpr multiply(IExpr a, java.math.BigInteger i) {
        return F.function(Times, a, (IExpr)F.integer(i));
    }

    public static IExpr div(IExpr a, java.math.BigInteger i) {
        return F.function(Times, a, (IExpr)F.function(Power, (IExpr)F.integer(i), (IExpr)CN1));
    }

    public static IExpr div(java.math.BigInteger i, IExpr b) {
        return F.function(Times, (IExpr)F.integer(i), (IExpr)F.function(Power, b, (IExpr)CN1));
    }

    public static IExpr mod(IExpr a, java.math.BigInteger i) {
        return F.function(Mod, a, (IExpr)F.integer(i));
    }

    public static IExpr mod(java.math.BigInteger i, IExpr b) {
        return F.function(Mod, (IExpr)F.integer(i), b);
    }

    public static IExpr and(IExpr a, java.math.BigInteger i) {
        return F.function(And, a, (IExpr)F.integer(i));
    }

    public static IExpr and(java.math.BigInteger i, IExpr b) {
        return F.function(And, (IExpr)F.integer(i), b);
    }

    public static IExpr or(IExpr a, java.math.BigInteger i) {
        return F.function(Or, a, (IExpr)F.integer(i));
    }

    public static IExpr or(java.math.BigInteger i, IExpr b) {
        return F.function(Or, (IExpr)F.integer(i), b);
    }
}

