/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import apache.harmony.math.BigInteger;
import apache.harmony.math.Rational;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;

public class FractionSym
extends ExprImpl
implements IFraction {
    private static final long serialVersionUID = 2396715994276842438L;
    Rational fRational = null;

    protected static FractionSym newInstance(Rational rational) {
        FractionSym r = new FractionSym();
        r.fRational = rational;
        return r;
    }

    public static FractionSym valueOf(BigInteger numerator) {
        FractionSym r = new FractionSym();
        r.fRational = Rational.valueOf(numerator, BigInteger.ONE);
        return r;
    }

    public static FractionSym valueOf(Rational rat) {
        FractionSym r = new FractionSym();
        r.fRational = Rational.valueOf(rat);
        return r;
    }

    public static FractionSym valueOf(BigInteger numerator, BigInteger denominator) {
        FractionSym r = new FractionSym();
        r.fRational = Rational.valueOf(numerator, denominator);
        return r;
    }

    public static FractionSym valueOf(IInteger numerator, IInteger denominator) {
        FractionSym r = new FractionSym();
        r.fRational = Rational.valueOf(numerator.getBigNumerator(), denominator.getBigNumerator());
        return r;
    }

    public static FractionSym valueOf(long numerator, long denominator) {
        FractionSym r = new FractionSym();
        r.fRational = Rational.valueOf(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
        return r;
    }

    public static FractionSym valueOf(double value) {
        FractionSym r = new FractionSym();
        r.fRational = Rational.valueOf(value);
        return r;
    }

    private FractionSym() {
    }

    @Override
    public boolean isZero() {
        return this.fRational.getNumerator().equals(BigInteger.ZERO);
    }

    @Override
    public boolean equalsInt(int i) {
        return this.fRational.getNumerator().equals(BigInteger.valueOf(i)) && this.fRational.getDenominator().equals(BigInteger.ONE);
    }

    @Override
    public BigInteger getBigDenominator() {
        return this.fRational.getDenominator();
    }

    @Override
    public BigInteger getBigNumerator() {
        return this.fRational.getNumerator();
    }

    @Override
    public IInteger getDenominator() {
        return IntegerSym.valueOf(this.fRational.getDenominator());
    }

    @Override
    public IInteger getNumerator() {
        return IntegerSym.valueOf(this.fRational.getNumerator());
    }

    @Override
    public int hierarchy() {
        return 16;
    }

    @Override
    public IFraction add(IFraction parm1) {
        return FractionSym.newInstance(this.fRational.plus(((FractionSym)parm1).fRational));
    }

    @Override
    public IFraction multiply(IFraction parm1) {
        return FractionSym.newInstance(this.fRational.times(((FractionSym)parm1).fRational));
    }

    @Override
    public boolean isNegative() {
        return this.fRational.getNumerator().compareTo(BigInteger.ZERO) == -1;
    }

    @Override
    public boolean isPositive() {
        return this.fRational.getNumerator().compareTo(BigInteger.ZERO) == 1;
    }

    @Override
    public FractionSym eabs() {
        return FractionSym.newInstance(this.fRational.abs());
    }

    public Rational add(Rational that) {
        return this.fRational.plus(that);
    }

    @Override
    public Rational divide(Rational that) {
        return this.fRational.divide(that);
    }

    @Override
    public double doubleValue() {
        return this.fRational.doubleValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FractionSym) {
            return this.fRational.equals(((FractionSym)obj).fRational);
        }
        return false;
    }

    public BigInteger getDividend() {
        return this.fRational.getNumerator();
    }

    public BigInteger getDivisor() {
        return this.fRational.getDenominator();
    }

    @Override
    public int hashCode() {
        return this.fRational.hashCode();
    }

    public long longValue() {
        return this.fRational.longValue();
    }

    @Override
    public Rational multiply(Rational that) {
        return this.fRational.times(that);
    }

    @Override
    public ISignedNumber negate() {
        return FractionSym.newInstance(this.fRational.opposite());
    }

    @Override
    public IExpr opposite() {
        return FractionSym.newInstance(this.fRational.opposite());
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof FractionSym) {
            return this.add((FractionSym)that);
        }
        if (that instanceof IntegerSym) {
            return this.add(FractionSym.valueOf(((IntegerSym)that).fInteger));
        }
        return super.plus(that);
    }

    @Override
    public ISignedNumber minus(ISignedNumber that) {
        if (that instanceof FractionSym) {
            return this.add((FractionSym)that.negate());
        }
        if (this.isZero()) {
            return that.negate();
        }
        if (that instanceof IntegerSym) {
            return this.minus(FractionSym.valueOf(((IntegerSym)that).fInteger));
        }
        return Num.valueOf(this.doubleValue() - that.doubleValue());
    }

    @Override
    public IFraction pow(int exp) {
        if (exp <= 0) {
            throw new IllegalArgumentException("exp: " + exp + " should be a positive number");
        }
        IFraction powSqr = this;
        FractionSym result = null;
        while (exp >= 1) {
            if ((exp & 1) == 1) {
                result = result == null ? powSqr : result.multiply(powSqr);
            }
            powSqr = powSqr.multiply(powSqr);
            exp >>>= 1;
        }
        return result;
    }

    @Override
    public IExpr inverse() {
        return FractionSym.newInstance(this.fRational.inverse());
    }

    public BigInteger round() {
        return this.fRational.round();
    }

    @Override
    public Rational subtract(Rational that) {
        return this.fRational.minus(that);
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof FractionSym) {
            return this.multiply((FractionSym)that);
        }
        if (that instanceof IntegerSym) {
            return this.multiply(FractionSym.valueOf(((IntegerSym)that).fInteger));
        }
        return super.times(that);
    }

    @Override
    public String internalFormString(boolean callSymbolFactory) {
        int numerator = this.fRational.getNumerator().intValue();
        int denominator = this.fRational.getDenominator().intValue();
        if (numerator == 1) {
            switch (denominator) {
                case 2: {
                    return "C1D2";
                }
                case 3: {
                    return "C1D3";
                }
                case 4: {
                    return "C1D4";
                }
            }
        }
        if (numerator == -1) {
            switch (denominator) {
                case 2: {
                    return "CN1D2";
                }
                case 3: {
                    return "CN1D3";
                }
                case 4: {
                    return "CN1D4";
                }
            }
        }
        return "fraction(" + numerator + "L," + denominator + "L)";
    }

    public String toString() {
        return String.valueOf(this.fRational.getNumerator().toString()) + "/" + this.fRational.getDenominator().toString();
    }

    @Override
    public String fullFormString() {
        StringBuffer buf = new StringBuffer("Rational[");
        buf.append(this.fRational.getNumerator().toString().toString());
        buf.append(',');
        buf.append(this.fRational.getDenominator().toString().toString());
        buf.append(']');
        return buf.toString();
    }

    @Override
    public Rational getRational() {
        return this.fRational;
    }

    @Override
    public int sign() {
        return this.fRational.getNumerator().signum();
    }

    @Override
    public int complexSign() {
        return this.sign();
    }

    @Override
    public ISignedNumber ceil() {
        BigInteger[] result = this.fRational.getNumerator().divideAndRemainder(this.fRational.getDenominator());
        if (!result[1].isPositive()) {
            return IntegerSym.valueOf(result[0]);
        }
        return IntegerSym.valueOf(result[0].plus(BigInteger.ONE));
    }

    @Override
    public ISignedNumber floor() {
        BigInteger[] result = this.fRational.getNumerator().divideAndRemainder(this.fRational.getDenominator());
        if (!result[1].isNegative()) {
            return IntegerSym.valueOf(result[0]);
        }
        return IntegerSym.valueOf(result[0].minus(BigInteger.ONE));
    }

    @Override
    public int compareTo(IExpr obj) {
        if (obj instanceof FractionSym) {
            return this.fRational.compareTo(((FractionSym)obj).fRational);
        }
        if (obj instanceof IntegerSym) {
            return this.fRational.compareTo(Rational.valueOf(((IntegerSym)obj).fInteger, BigInteger.ONE));
        }
        return this.hierarchy() - obj.hierarchy();
    }

    @Override
    public boolean isLessThan(ISignedNumber obj) {
        if (obj instanceof FractionSym) {
            return this.fRational.compareTo(((FractionSym)obj).fRational) < 0;
        }
        if (obj instanceof IntegerSym) {
            return this.fRational.compareTo(Rational.valueOf(((IntegerSym)obj).fInteger, BigInteger.ONE)) < 0;
        }
        return this.fRational.doubleValue() < obj.doubleValue();
    }

    @Override
    public boolean isGreaterThan(ISignedNumber obj) {
        if (obj instanceof FractionSym) {
            return this.fRational.compareTo(((FractionSym)obj).fRational) > 0;
        }
        if (obj instanceof IntegerSym) {
            return this.fRational.compareTo(Rational.valueOf(((IntegerSym)obj).fInteger, BigInteger.ONE)) > 0;
        }
        return this.fRational.doubleValue() < obj.doubleValue();
    }

    @Override
    public ISymbol head() {
        return F.RationalHead;
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }
}

